/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.builder;

import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonStructure;
import javax.json.JsonValue;
import javax.json.JsonWriter;
import org.apache.sling.feature.Artifact;
import org.apache.sling.feature.ArtifactId;
import org.apache.sling.feature.Artifacts;
import org.apache.sling.feature.Configuration;
import org.apache.sling.feature.Configurations;
import org.apache.sling.feature.Extension;
import org.apache.sling.feature.Feature;
import org.apache.sling.feature.MatchingRequirement;
import org.apache.sling.feature.builder.ArtifactProvider;
import org.apache.sling.feature.builder.BuilderContext;
import org.apache.sling.feature.builder.HandlerContext;
import org.apache.sling.feature.builder.MergeHandler;
import org.apache.sling.feature.builder.PostProcessHandler;
import org.osgi.framework.Version;
import org.osgi.resource.Capability;

class BuilderUtil {
    static final String CATCHALL_OVERRIDE = "*:*:";

    BuilderUtil() {
    }

    static void mergeVariables(Feature targetFeature, Feature sourceFeature, Map<String, String> overrides) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        HashMap<String, Map<String, Object>> metadata = new HashMap<String, Map<String, Object>>();
        for (Map.Entry<String, String> entry : targetFeature.getVariables().entrySet()) {
            result.put(entry.getKey(), overrides.containsKey(entry.getKey()) ? overrides.get(entry.getKey()) : entry.getValue());
            metadata.put(entry.getKey(), targetFeature.getVariableMetadata(entry.getKey()));
        }
        for (Map.Entry<String, String> entry : sourceFeature.getVariables().entrySet()) {
            ArrayList<ArtifactId> targetIds = metadata.containsKey(entry.getKey()) ? new ArrayList<ArtifactId>(targetFeature.getFeatureOrigins((Map)metadata.get(entry.getKey()))) : new ArrayList();
            targetIds.add(sourceFeature.getId());
            if (overrides.containsKey(entry.getKey())) {
                result.put(entry.getKey(), overrides.get(entry.getKey()));
            } else {
                String value = entry.getValue();
                if (value != null) {
                    String targetValue = targetFeature.getVariables().get(entry.getKey());
                    if (targetValue != null) {
                        if (!value.equals(targetValue)) {
                            throw new IllegalStateException(String.format("Can't merge variable '%s' defined twice (as '%s' v.s. '%s') and not overridden.", entry.getKey(), value, targetValue));
                        }
                    } else {
                        result.put(entry.getKey(), value);
                    }
                } else if (!targetFeature.getVariables().containsKey(entry.getKey())) {
                    result.put(entry.getKey(), value);
                }
            }
            metadata.put(entry.getKey(), new LinkedHashMap<String, Object>(sourceFeature.getVariableMetadata(entry.getKey())));
            targetFeature.setFeatureOrigins((Map)metadata.get(entry.getKey()), targetIds);
        }
        targetFeature.getVariables().clear();
        targetFeature.getVariables().putAll(result);
        for (Map.Entry<String, String> entry : metadata.entrySet()) {
            targetFeature.getVariableMetadata(entry.getKey()).putAll((Map)((Object)entry.getValue()));
        }
    }

    static void mergeArtifacts(Artifacts target, Artifacts source, Feature sourceFeature, List<ArtifactId> artifactOverrides, String originKey) {
        for (Artifact artifactFromSource : source) {
            LinkedHashSet<Artifact> allExistingInTarget = new LinkedHashSet<Artifact>();
            for (ArtifactId id : artifactFromSource.getAliases(true)) {
                for (Artifact targetArtifact : target) {
                    if (!id.isSame(targetArtifact.getId())) continue;
                    allExistingInTarget.add(targetArtifact);
                }
                BuilderUtil.findAliasedArtifacts(id, target, allExistingInTarget);
            }
            ArrayList<Artifact> selectedArtifacts = new ArrayList<Artifact>();
            if (allExistingInTarget.isEmpty()) {
                selectedArtifacts.add(artifactFromSource);
            }
            int insertPos = target.size();
            int count = 0;
            for (Artifact existing : allExistingInTarget) {
                if (sourceFeature.getId().toMvnId().equals(existing.getMetadata().get(originKey))) {
                    selectedArtifacts.add(count++, existing);
                    selectedArtifacts.add(artifactFromSource);
                    continue;
                }
                List<Artifact> artifacts = BuilderUtil.selectArtifactOverride(sourceFeature, existing, artifactFromSource, artifactOverrides, sourceFeature.getId());
                if (artifacts.size() > 1) {
                    selectedArtifacts.add(count++, artifacts.remove(0));
                }
                selectedArtifacts.addAll(artifacts);
                Artifact same = null;
                while ((same = target.getSame(existing.getId())) != null) {
                    int p = target.indexOf(same);
                    if (p < insertPos) {
                        insertPos = p;
                    }
                    target.remove(p);
                }
            }
            for (Artifact sa : new LinkedHashSet(selectedArtifacts)) {
                Artifact cp = BuilderUtil.addFeatureOrigin(sa.copy(sa.getId()), sourceFeature, sa);
                cp.getMetadata().put(BuilderUtil.class.getName() + "added", "true");
                if (originKey != null && sourceFeature != null && source.contains(sa) && sa.getMetadata().get(originKey) == null) {
                    cp.getMetadata().put(originKey, sourceFeature.getId().toMvnId());
                }
                if (insertPos == target.size()) {
                    target.add(cp);
                    insertPos = target.size();
                    continue;
                }
                target.add(insertPos, cp);
                ++insertPos;
            }
        }
        for (Artifact artifact : target) {
            artifact.getMetadata().remove(BuilderUtil.class.getName() + "added");
        }
    }

    static List<Artifact> selectArtifactOverride(Artifact fromTarget, Artifact fromSource, List<ArtifactId> artifactOverrides) {
        return BuilderUtil.selectArtifactOverride(null, fromTarget, fromSource, artifactOverrides, null);
    }

    static List<Artifact> selectArtifactOverride(Feature source, Artifact fromTarget, Artifact fromSource, List<ArtifactId> artifactOverrides, ArtifactId sourceID) {
        if (fromTarget.getId().equals(fromSource.getId())) {
            return Collections.singletonList(BuilderUtil.addFeatureOrigin(BuilderUtil.selectStartOrder(fromTarget, fromSource, fromSource), source, fromSource, fromTarget));
        }
        Set<ArtifactId> commonPrefixes = BuilderUtil.getCommonArtifactIds(fromTarget, fromSource);
        if (commonPrefixes.isEmpty()) {
            throw new IllegalStateException("Internal error selecting override. No common prefix between " + fromTarget + " and " + fromSource);
        }
        ArrayList<Artifact> result = new ArrayList<Artifact>();
        if (artifactOverrides.isEmpty() && fromTarget.getMetadata().containsKey(BuilderUtil.class.getName() + "added")) {
            result.add(fromTarget);
            result.add(BuilderUtil.addFeatureOrigin(fromSource, source, fromSource));
            return result;
        }
        block0: for (ArtifactId prefix : commonPrefixes) {
            for (ArtifactId override : artifactOverrides) {
                if (!BuilderUtil.match(prefix, override)) continue;
                String rule = override.getVersion();
                if ("ALL".equalsIgnoreCase(rule)) {
                    result.add(fromTarget);
                    result.add(fromSource);
                    break block0;
                }
                if ("HIGHEST".equalsIgnoreCase(rule)) {
                    Version a1v = fromTarget.getAliases(true).stream().filter(prefix::isSame).findFirst().get().getOSGiVersion();
                    Version a2v = fromSource.getAliases(true).stream().filter(prefix::isSame).findFirst().get().getOSGiVersion();
                    result.add(BuilderUtil.addFeatureOrigin(BuilderUtil.selectStartOrder(fromTarget, fromSource, a1v.compareTo(a2v) > 0 ? fromTarget : fromSource), source, fromSource, fromTarget));
                    break block0;
                }
                if ("FIRST".equalsIgnoreCase(rule)) {
                    result.add(BuilderUtil.addFeatureOrigin(BuilderUtil.selectStartOrder(fromTarget, fromSource, fromTarget), source, fromSource, fromTarget));
                    break block0;
                }
                if ("LATEST".equalsIgnoreCase(rule)) {
                    result.add(BuilderUtil.addFeatureOrigin(BuilderUtil.selectStartOrder(fromTarget, fromSource, fromSource), source, fromSource, fromTarget));
                    break block0;
                }
                if (fromTarget.getId().getVersion().equals(rule)) {
                    result.add(BuilderUtil.addFeatureOrigin(BuilderUtil.selectStartOrder(fromTarget, fromSource, fromTarget), source, fromSource, fromTarget));
                    break block0;
                }
                if (fromSource.getId().getVersion().equals(rule)) {
                    result.add(BuilderUtil.addFeatureOrigin(BuilderUtil.selectStartOrder(fromTarget, fromSource, fromSource), source, fromSource, fromTarget));
                    break block0;
                }
                result.add(BuilderUtil.addFeatureOrigin(BuilderUtil.selectStartOrder(fromTarget, fromSource, new Artifact(override)), source, fromSource, fromTarget));
                break block0;
            }
        }
        if (!result.isEmpty()) {
            return result;
        }
        throw new IllegalStateException("Artifact override rule required to select between these two artifacts " + fromTarget + " and " + fromSource + ". The rule must be specified for " + commonPrefixes);
    }

    private static Artifact selectStartOrder(Artifact a, Artifact b, Artifact target) {
        int startOrderA = a.getStartOrder();
        int startOrderB = b.getStartOrder();
        int startOrderNew = startOrderA == 0 ? startOrderB : (startOrderB == 0 ? startOrderA : (startOrderA < startOrderB ? startOrderA : startOrderB));
        if (startOrderNew != target.getStartOrder()) {
            Artifact result = target.copy(target.getId());
            result.setStartOrder(startOrderNew);
            return result;
        }
        return target;
    }

    private static Artifact addFeatureOrigin(Artifact result, Feature sourceFeature, Artifact sourceArtifact, Artifact targetArtifact) {
        LinkedHashSet<ArtifactId> originFeatures = new LinkedHashSet<ArtifactId>();
        List<ArtifactId> targetOrigins = Arrays.asList(targetArtifact.getFeatureOrigins());
        originFeatures.addAll(targetOrigins);
        List<ArtifactId> sourceOrigings = Arrays.asList(sourceArtifact.getFeatureOrigins());
        if (sourceFeature != null && sourceOrigings.isEmpty()) {
            originFeatures.add(sourceFeature.getId());
        } else {
            originFeatures.addAll(sourceOrigings);
        }
        Object[] origins = originFeatures.toArray(new ArtifactId[0]);
        if (Arrays.equals(origins, result.getFeatureOrigins())) {
            return result;
        }
        result = result.copy(result.getId());
        result.setFeatureOrigins((ArtifactId[])origins);
        return result;
    }

    private static Artifact addFeatureOrigin(Artifact result, Feature sourceFeature, Artifact sourceArtifact) {
        LinkedHashSet<ArtifactId> originFeatures = new LinkedHashSet<ArtifactId>();
        List<ArtifactId> sourceOrigins = Arrays.asList(sourceArtifact.getFeatureOrigins());
        if (sourceFeature != null && sourceOrigins.isEmpty()) {
            originFeatures.add(sourceFeature.getId());
        } else if (!sourceOrigins.isEmpty()) {
            originFeatures.addAll(sourceOrigins);
        }
        Object[] origins = originFeatures.toArray(new ArtifactId[0]);
        if (Arrays.equals(origins, result.getFeatureOrigins())) {
            return result;
        }
        result = result.copy(result.getId());
        result.setFeatureOrigins((ArtifactId[])origins);
        return result;
    }

    private static boolean match(ArtifactId id, ArtifactId override) {
        int matchCount = 0;
        if ("*".equals(override.getGroupId())) {
            ++matchCount;
        } else if (id.getGroupId().equals(override.getGroupId())) {
            ++matchCount;
        }
        if ("*".equals(override.getArtifactId())) {
            ++matchCount;
        } else if (id.getArtifactId().equals(override.getArtifactId())) {
            ++matchCount;
        }
        if ("*".equals(override.getType())) {
            ++matchCount;
        } else if (id.getType().equals(override.getType())) {
            ++matchCount;
        }
        if ("*".equals(override.getClassifier())) {
            ++matchCount;
        } else if (Objects.equals(id.getClassifier(), override.getClassifier())) {
            ++matchCount;
        }
        return matchCount == 4;
    }

    private static boolean match(Configuration config, String override) {
        boolean result;
        if (override.equals("*")) {
            result = true;
        } else if (Configuration.isFactoryConfiguration(config.getPid())) {
            if (Configuration.isFactoryConfiguration(override)) {
                String overridePID;
                String configPID = Configuration.getFactoryPid(config.getPid());
                if (BuilderUtil.match(configPID, overridePID = Configuration.getFactoryPid(override))) {
                    String configName = Configuration.getName(config.getPid());
                    String overrideName = Configuration.getName(override);
                    result = BuilderUtil.match(configName, overrideName);
                } else {
                    result = false;
                }
            } else {
                result = false;
            }
        } else {
            result = BuilderUtil.match(config.getPid(), override);
        }
        return result;
    }

    private static boolean match(String value, String override) {
        boolean result;
        if (override.endsWith("*")) {
            override = override.substring(0, override.length() - 1);
            result = value.startsWith(override);
        } else {
            result = value.equals(override);
        }
        return result;
    }

    private static Set<ArtifactId> getCommonArtifactIds(Artifact a1, Artifact a2) {
        HashSet<ArtifactId> result = new HashSet<ArtifactId>();
        for (ArtifactId id : a1.getAliases(true)) {
            for (ArtifactId c : a2.getAliases(true)) {
                if (!id.isSame(c)) continue;
                result.add(id);
            }
        }
        return result;
    }

    private static void findAliasedArtifacts(ArtifactId id, Artifacts targetBundles, Set<Artifact> result) {
        for (Artifact a : targetBundles) {
            for (ArtifactId aid : a.getAliases(false)) {
                if (!aid.isSame(id)) continue;
                result.add(a);
            }
        }
    }

    static void mergeConfigurations(Configurations target, Configurations source, Map<String, String> overrides, ArtifactId sourceFeatureId) {
        for (Configuration cfg : source) {
            List<ArtifactId> sourceOrigins = cfg.getFeatureOrigins().isEmpty() ? Collections.singletonList(sourceFeatureId) : cfg.getFeatureOrigins();
            Configuration found = target.getConfiguration(cfg.getPid());
            if (found != null) {
                boolean handled = false;
                block1: for (Map.Entry<String, String> override : overrides.entrySet()) {
                    String key;
                    Enumeration<String> i;
                    if (!BuilderUtil.match(cfg, override.getKey())) continue;
                    if ("USE_LATEST".equals(override.getValue())) {
                        int idx = target.indexOf(found);
                        target.remove(found);
                        found = cfg.copy(cfg.getPid());
                        target.add(idx, found);
                        BuilderUtil.setPropertyFeatureOrigins(found, sourceFeatureId);
                        handled = true;
                        break;
                    }
                    if ("PROPERTY_CLASH".equals(override.getValue())) {
                        List<ArtifactId> origins = found.getFeatureOrigins();
                        i = cfg.getProperties().keys();
                        while (i.hasMoreElements()) {
                            key = i.nextElement();
                            if (found.getProperties().get(key) != null) break block1;
                            found.getProperties().put(key, cfg.getProperties().get(key));
                            cfg.setFeatureOrigins(key, cfg.getFeatureOrigins(key, sourceFeatureId));
                        }
                        found.setFeatureOrigins(origins);
                        handled = true;
                        break;
                    }
                    if ("MERGE_LATEST".equals(override.getValue())) {
                        List<ArtifactId> origins = found.getFeatureOrigins();
                        i = cfg.getProperties().keys();
                        while (i.hasMoreElements()) {
                            key = i.nextElement();
                            found.getProperties().put(key, cfg.getProperties().get(key));
                            ArrayList<ArtifactId> propOrigins = new ArrayList<ArtifactId>(found.getFeatureOrigins(key));
                            propOrigins.addAll(cfg.getFeatureOrigins(key, sourceFeatureId));
                            found.setFeatureOrigins(key, propOrigins);
                        }
                        found.setFeatureOrigins(origins);
                        handled = true;
                        break;
                    }
                    if ("USE_FIRST".equals(override.getValue())) {
                        handled = true;
                        found = null;
                        break;
                    }
                    if (!"MERGE_FIRST".equals(override.getValue())) break;
                    List<ArtifactId> origins = found.getFeatureOrigins();
                    i = cfg.getProperties().keys();
                    while (i.hasMoreElements()) {
                        key = i.nextElement();
                        if (found.getProperties().get(key) != null) continue;
                        found.getProperties().put(key, cfg.getProperties().get(key));
                        cfg.setFeatureOrigins(key, cfg.getFeatureOrigins(key, sourceFeatureId));
                    }
                    found.setFeatureOrigins(origins);
                    handled = true;
                    break;
                }
                if (!handled) {
                    throw new IllegalStateException("Configuration override rule required to select between configurations for " + cfg.getPid());
                }
            } else {
                found = cfg.copy(cfg.getPid());
                target.add(found);
                BuilderUtil.setPropertyFeatureOrigins(found, sourceFeatureId);
                if (!found.getFeatureOrigins().isEmpty()) {
                    found = null;
                }
            }
            if (found == null) continue;
            ArrayList<ArtifactId> origins = new ArrayList<ArtifactId>(found.getFeatureOrigins());
            origins.addAll(sourceOrigins);
            found.setFeatureOrigins(origins);
        }
    }

    private static void setPropertyFeatureOrigins(Configuration cfg, ArtifactId sourceFeatureId) {
        for (String propName : Collections.list(cfg.getConfigurationProperties().keys())) {
            cfg.setFeatureOrigins(propName, cfg.getFeatureOrigins(propName, sourceFeatureId));
        }
    }

    static void mergeFrameworkProperties(Feature targetFeature, Feature sourceFeature, Map<String, String> overrides) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        HashMap<String, Map<String, Object>> metadata = new HashMap<String, Map<String, Object>>();
        for (Map.Entry<String, String> entry : targetFeature.getFrameworkProperties().entrySet()) {
            result.put(entry.getKey(), overrides.containsKey(entry.getKey()) ? overrides.get(entry.getKey()) : entry.getValue());
            metadata.put(entry.getKey(), targetFeature.getFrameworkPropertyMetadata(entry.getKey()));
        }
        for (Map.Entry<String, String> entry : sourceFeature.getFrameworkProperties().entrySet()) {
            ArrayList<ArtifactId> targetIds = metadata.containsKey(entry.getKey()) ? new ArrayList<ArtifactId>(targetFeature.getFeatureOrigins((Map)metadata.get(entry.getKey()))) : new ArrayList();
            targetIds.add(sourceFeature.getId());
            if (overrides.containsKey(entry.getKey())) {
                result.put(entry.getKey(), overrides.get(entry.getKey()));
            } else {
                String value = entry.getValue();
                if (value != null) {
                    String targetValue = targetFeature.getFrameworkProperties().get(entry.getKey());
                    if (targetValue != null) {
                        if (!value.equals(targetValue)) {
                            throw new IllegalStateException(String.format("Can't merge framework property '%s' defined twice (as '%s' v.s. '%s') and not overridden.", entry.getKey(), value, targetValue));
                        }
                    } else {
                        result.put(entry.getKey(), value);
                    }
                } else if (!targetFeature.getFrameworkProperties().containsKey(entry.getKey())) {
                    result.put(entry.getKey(), value);
                }
            }
            metadata.put(entry.getKey(), new HashMap<String, Object>(sourceFeature.getFrameworkPropertyMetadata(entry.getKey())));
            targetFeature.setFeatureOrigins((Map)metadata.get(entry.getKey()), targetIds);
        }
        targetFeature.getFrameworkProperties().clear();
        targetFeature.getFrameworkProperties().putAll(result);
        for (Map.Entry<String, String> entry : metadata.entrySet()) {
            targetFeature.getFrameworkPropertyMetadata(entry.getKey()).putAll((Map)((Object)entry.getValue()));
        }
    }

    static void mergeRequirements(List<MatchingRequirement> target, List<MatchingRequirement> source) {
        for (MatchingRequirement req : source) {
            if (target.contains(req)) continue;
            target.add(req);
        }
    }

    static void mergeCapabilities(List<Capability> target, List<Capability> source) {
        for (Capability cap : source) {
            if (target.contains(cap)) continue;
            target.add(cap);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void mergeExtensions(Extension target, Extension source, Feature sourceFeature, List<ArtifactId> artifactOverrides, String originKey) {
        switch (target.getType()) {
            case TEXT: {
                target.setText((target.getText() != null && !target.getText().trim().isEmpty() ? target.getText() + "\n" : "") + source.getText());
                return;
            }
            case JSON: {
                JsonStructure struct2;
                JsonStructure struct1;
                if (target.getJSON() == null) {
                    target.setJSON(source.getJSON());
                    return;
                }
                try (StringReader reader = new StringReader(target.getJSON());){
                    struct1 = Json.createReader((Reader)reader).read();
                }
                try (StringReader reader = new StringReader(source.getJSON());){
                    struct2 = Json.createReader((Reader)reader).read();
                }
                if (struct1.getValueType() != struct2.getValueType()) {
                    throw new IllegalStateException("Found different JSON types for extension " + target.getName() + " : " + struct1.getValueType() + " and " + struct2.getValueType());
                }
                if (struct1.getValueType() == JsonValue.ValueType.ARRAY) {
                    JsonArrayBuilder builder = Json.createArrayBuilder();
                    Stream.concat(((JsonArray)struct1).stream(), ((JsonArray)struct2).stream()).forEachOrdered(arg_0 -> ((JsonArrayBuilder)builder).add(arg_0));
                    struct1 = builder.build();
                } else {
                    struct1 = BuilderUtil.merge((JsonObject)struct1, (JsonObject)struct2);
                }
                StringWriter buffer = new StringWriter();
                try (JsonWriter writer = Json.createWriter((Writer)buffer);){
                    writer.write(struct1);
                }
                target.setJSON(buffer.toString());
                return;
            }
            case ARTIFACTS: {
                BuilderUtil.mergeArtifacts(target.getArtifacts(), source.getArtifacts(), sourceFeature, artifactOverrides, originKey);
                return;
            }
        }
    }

    static void mergeExtensions(Feature target, Feature source, BuilderContext context, List<ArtifactId> artifactOverrides, String originKey, boolean prototypeMerge, boolean initialMerge) {
        for (Extension ext : source.getExtensions()) {
            boolean found = false;
            for (Extension extension : new ArrayList<Extension>(target.getExtensions())) {
                if (!extension.getName().equals(ext.getName())) continue;
                found = true;
                if (extension.getType() != ext.getType()) {
                    throw new IllegalStateException("Found different types for extension " + extension.getName() + " : " + (Object)((Object)extension.getType()) + " and " + (Object)((Object)ext.getType()));
                }
                boolean handled = false;
                for (MergeHandler me : context.getMergeExtensions()) {
                    if (!me.canMerge(extension)) continue;
                    me.merge(new HandlerContextImpl(context, me, prototypeMerge, initialMerge), target, source, extension, ext);
                    handled = true;
                    break;
                }
                if (handled) continue;
                BuilderUtil.mergeExtensions(extension, ext, source, artifactOverrides, originKey);
            }
            if (found) continue;
            boolean handled = false;
            for (MergeHandler mh : context.getMergeExtensions()) {
                if (!mh.canMerge(ext)) continue;
                mh.merge(new HandlerContextImpl(context, mh, prototypeMerge, initialMerge), target, source, null, ext);
                handled = true;
                break;
            }
            if (handled) continue;
            Extension extension = new Extension(ext.getType(), ext.getName(), ext.getState());
            target.getExtensions().add(extension);
            BuilderUtil.mergeExtensions(extension, ext, source, artifactOverrides, originKey);
        }
        for (Extension ext : new ArrayList<Extension>(target.getExtensions())) {
            for (PostProcessHandler ppe : context.getPostProcessExtensions()) {
                ppe.postProcess(new HandlerContextImpl(context, ppe, prototypeMerge, initialMerge), target, ext);
            }
        }
    }

    private static JsonObject merge(JsonObject obj1, JsonObject obj2) {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        for (Map.Entry entry : obj1.entrySet()) {
            builder.add((String)entry.getKey(), (JsonValue)entry.getValue());
        }
        for (Map.Entry entry : obj2.entrySet()) {
            if (!obj1.containsKey(entry.getKey())) {
                builder.add((String)entry.getKey(), (JsonValue)entry.getValue());
                continue;
            }
            JsonValue oldValue = (JsonValue)obj1.get(entry.getKey());
            if (oldValue.getValueType() != ((JsonValue)entry.getValue()).getValueType()) {
                builder.add((String)entry.getKey(), (JsonValue)entry.getValue());
                continue;
            }
            if (oldValue.getValueType() == JsonValue.ValueType.ARRAY) {
                JsonArrayBuilder arrayBuilder = Json.createArrayBuilder();
                Stream.concat(((JsonArray)oldValue).stream(), ((JsonArray)entry.getValue()).stream()).forEachOrdered(arg_0 -> ((JsonArrayBuilder)arrayBuilder).add(arg_0));
                builder.add((String)entry.getKey(), (JsonValue)arrayBuilder.build());
                continue;
            }
            if (oldValue.getValueType() == JsonValue.ValueType.OBJECT) {
                builder.add((String)entry.getKey(), (JsonValue)BuilderUtil.merge((JsonObject)oldValue, (JsonObject)entry.getValue()));
                continue;
            }
            builder.add((String)entry.getKey(), (JsonValue)entry.getValue());
        }
        return builder.build();
    }

    static class HandlerContextImpl
    implements HandlerContext {
        private final ArtifactProvider artifactProvider;
        private final Map<String, String> configuration;
        private final boolean prototypeMerge;
        private final boolean initialMerge;

        HandlerContextImpl(BuilderContext bc, MergeHandler handler, boolean prototype, boolean initial) {
            this.artifactProvider = bc.getArtifactProvider();
            this.configuration = this.getHandlerConfiguration(bc, handler);
            this.prototypeMerge = prototype;
            this.initialMerge = initial;
        }

        HandlerContextImpl(BuilderContext bc, PostProcessHandler handler, boolean prototype, boolean initial) {
            this.artifactProvider = bc.getArtifactProvider();
            this.configuration = this.getHandlerConfiguration(bc, handler);
            this.prototypeMerge = prototype;
            this.initialMerge = initial;
        }

        private Map<String, String> getHandlerConfiguration(BuilderContext bc, Object handler) {
            Map<String, String> handlerSpecific;
            String name;
            HashMap<String, String> result = new HashMap<String, String>();
            Map<String, String> overall = bc.getHandlerConfigurations().get("all");
            if (overall != null) {
                result.putAll(overall);
            }
            if ((name = HandlerContextImpl.getHandlerName(handler)) != null && (handlerSpecific = bc.getHandlerConfigurations().get(name)) != null) {
                result.putAll(handlerSpecific);
            }
            return result;
        }

        private static String getHandlerName(Object handler) {
            return handler.getClass().getSimpleName();
        }

        @Override
        public ArtifactProvider getArtifactProvider() {
            return this.artifactProvider;
        }

        @Override
        public Map<String, String> getConfiguration() {
            return this.configuration;
        }

        @Override
        public boolean isInitialMerge() {
            return this.initialMerge;
        }

        @Override
        public boolean isPrototypeMerge() {
            return this.prototypeMerge;
        }
    }
}

