/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.sling.feature.Artifact;
import org.apache.sling.feature.ArtifactId;
import org.apache.sling.feature.Bundles;
import org.apache.sling.feature.Configuration;
import org.apache.sling.feature.Configurations;
import org.apache.sling.feature.Extension;
import org.apache.sling.feature.Extensions;
import org.apache.sling.feature.MapWithMetadata;
import org.apache.sling.feature.MatchingRequirement;
import org.apache.sling.feature.Prototype;
import org.apache.sling.feature.impl.felix.utils.resource.AbstractCapabilityRequirement;
import org.apache.sling.feature.impl.felix.utils.resource.CapabilityImpl;
import org.apache.sling.feature.impl.felix.utils.resource.RequirementImpl;
import org.osgi.resource.Capability;
import org.osgi.resource.Resource;
import org.osgi.util.converter.Converters;

public class Feature
implements Comparable<Feature> {
    private final ArtifactId id;
    private final Bundles bundles = new Bundles();
    private final Configurations configurations = new Configurations();
    private final MapWithMetadata frameworkProperties = new MapWithMetadata();
    private final List<MatchingRequirement> requirements = new ArrayList<MatchingRequirement>();
    private final List<Capability> capabilities = new ArrayList<Capability>();
    private final Extensions extensions = new Extensions();
    private final MapWithMetadata variables = new MapWithMetadata();
    private String location;
    private String title;
    private String description;
    private String vendor;
    private String license;
    private boolean assembled = false;
    private boolean finalFlag = false;
    private boolean completeFlag = false;
    private Prototype prototype;

    public Feature(ArtifactId id) {
        if (id == null) {
            throw new IllegalArgumentException("id must not be null.");
        }
        this.id = id;
    }

    public ArtifactId getId() {
        return this.id;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String value) {
        this.location = value;
    }

    public Bundles getBundles() {
        return this.bundles;
    }

    public Configurations getConfigurations() {
        return this.configurations;
    }

    public Map<String, String> getFrameworkProperties() {
        return this.frameworkProperties;
    }

    public List<MatchingRequirement> getRequirements() {
        return this.requirements;
    }

    public List<Capability> getCapabilities() {
        return this.capabilities;
    }

    public Prototype getPrototype() {
        return this.prototype;
    }

    public void setPrototype(Prototype prototype) {
        this.prototype = prototype;
    }

    public Extensions getExtensions() {
        return this.extensions;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Map<String, String> getVariables() {
        return this.variables;
    }

    public String getVendor() {
        return this.vendor;
    }

    public void setVendor(String vendor) {
        this.vendor = vendor;
    }

    public String getLicense() {
        return this.license;
    }

    public void setLicense(String license) {
        this.license = license;
    }

    public boolean isFinal() {
        return this.finalFlag;
    }

    public void setFinal(boolean flag) {
        this.finalFlag = flag;
    }

    public boolean isComplete() {
        return this.completeFlag;
    }

    public void setComplete(boolean flag) {
        this.completeFlag = flag;
    }

    public boolean isAssembled() {
        return this.assembled;
    }

    public void setAssembled(boolean flag) {
        this.assembled = flag;
    }

    public Map<String, Object> getFrameworkPropertyMetadata(String key) {
        return this.frameworkProperties.getMetadata(key);
    }

    public Map<String, Object> getVariableMetadata(String key) {
        return this.variables.getMetadata(key);
    }

    public List<ArtifactId> getFeatureOrigins(Map<String, Object> metadata) {
        ArrayList<ArtifactId> list = new ArrayList<ArtifactId>();
        Object origins = metadata.get("feature-origins");
        if (origins != null) {
            String[] values;
            for (String v : values = (String[])Converters.standardConverter().convert(origins).to(String[].class)) {
                list.add(ArtifactId.parse(v));
            }
        }
        if (list.isEmpty()) {
            list.add(this.getId());
        }
        return Collections.unmodifiableList(list);
    }

    public void setFeatureOrigins(Map<String, Object> metadata, List<ArtifactId> featureOrigins) {
        if (featureOrigins == null || featureOrigins.isEmpty()) {
            metadata.remove("feature-origins");
        } else if (featureOrigins.size() == 1 && this.getId().equals(featureOrigins.get(0))) {
            metadata.remove("feature-origins");
        } else {
            List list = featureOrigins.stream().map(ArtifactId::toMvnId).collect(Collectors.toList());
            String[] values = (String[])Converters.standardConverter().convert(list).to(String[].class);
            metadata.put("feature-origins", values);
        }
    }

    public Feature copy() {
        return this.copy(this.getId());
    }

    public Feature copy(ArtifactId id) {
        AbstractCapabilityRequirement c;
        Feature result = new Feature(id);
        result.setLocation(this.getLocation());
        result.setTitle(this.getTitle());
        result.setDescription(this.getDescription());
        result.setVendor(this.getVendor());
        result.setLicense(this.getLicense());
        result.setAssembled(this.isAssembled());
        result.setFinal(this.isFinal());
        result.setComplete(this.isComplete());
        result.getVariables().putAll(this.getVariables());
        for (String string : this.getVariables().keySet()) {
            result.getVariableMetadata(string).putAll(this.getVariableMetadata(string));
        }
        for (Artifact artifact : this.getBundles()) {
            result.getBundles().add(artifact.copy(artifact.getId()));
        }
        for (Configuration configuration : this.getConfigurations()) {
            result.getConfigurations().add(configuration.copy(configuration.getPid()));
        }
        result.getFrameworkProperties().putAll(this.getFrameworkProperties());
        for (String string : this.getFrameworkProperties().keySet()) {
            result.getFrameworkPropertyMetadata(string).putAll(this.getFrameworkPropertyMetadata(string));
        }
        for (MatchingRequirement matchingRequirement : this.getRequirements()) {
            c = new MatchingRequirementImpl(null, matchingRequirement.getNamespace(), matchingRequirement.getDirectives(), matchingRequirement.getAttributes());
            result.getRequirements().add((MatchingRequirement)((Object)c));
        }
        for (Capability capability : this.getCapabilities()) {
            c = new CapabilityImpl(null, capability.getNamespace(), capability.getDirectives(), capability.getAttributes());
            result.getCapabilities().add((Capability)c);
        }
        Prototype i = this.getPrototype();
        if (i != null) {
            Prototype prototype = new Prototype(i.getId());
            prototype.getBundleRemovals().addAll(i.getBundleRemovals());
            prototype.getConfigurationRemovals().addAll(i.getConfigurationRemovals());
            prototype.getExtensionRemovals().addAll(i.getExtensionRemovals());
            prototype.getFrameworkPropertiesRemovals().addAll(i.getFrameworkPropertiesRemovals());
            prototype.getArtifactExtensionRemovals().putAll(i.getArtifactExtensionRemovals());
            result.setPrototype(prototype);
        }
        for (Extension e : this.getExtensions()) {
            Extension c3 = new Extension(e.getType(), e.getName(), e.getState());
            switch (c3.getType()) {
                case ARTIFACTS: {
                    for (Artifact a : e.getArtifacts()) {
                        c3.getArtifacts().add(a.copy(a.getId()));
                    }
                    break;
                }
                case JSON: {
                    c3.setJSON(e.getJSON());
                    break;
                }
                case TEXT: {
                    c3.setText(e.getText());
                }
            }
            result.getExtensions().add(c3);
        }
        return result;
    }

    @Override
    public int compareTo(Feature o) {
        return this.id.compareTo(o.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return this.id.equals(((Feature)obj).id);
    }

    public String toString() {
        return (this.isAssembled() ? "Assembled Feature" : "Feature") + " [id=" + this.getId().toMvnId() + (this.getLocation() != null ? ", location=" + this.getLocation() : "") + "]";
    }

    private static class MatchingRequirementImpl
    extends RequirementImpl
    implements MatchingRequirement {
        public MatchingRequirementImpl(Resource res, String ns, Map<String, String> dirs, Map<String, Object> attrs) {
            super(res, ns, dirs, attrs);
        }
    }
}

