/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.extension.apiregions.api.config.validation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.sling.feature.ArtifactId;
import org.apache.sling.feature.Configuration;
import org.apache.sling.feature.Feature;
import org.apache.sling.feature.builder.FeatureProvider;
import org.apache.sling.feature.extension.apiregions.api.config.ConfigurableEntity;
import org.apache.sling.feature.extension.apiregions.api.config.ConfigurationApi;
import org.apache.sling.feature.extension.apiregions.api.config.FactoryConfigurationDescription;
import org.apache.sling.feature.extension.apiregions.api.config.FrameworkPropertyDescription;
import org.apache.sling.feature.extension.apiregions.api.config.Operation;
import org.apache.sling.feature.extension.apiregions.api.config.Region;
import org.apache.sling.feature.extension.apiregions.api.config.validation.ConfigurationValidationResult;
import org.apache.sling.feature.extension.apiregions.api.config.validation.ConfigurationValidator;
import org.apache.sling.feature.extension.apiregions.api.config.validation.FeatureValidationResult;
import org.apache.sling.feature.extension.apiregions.api.config.validation.PropertyValidationResult;
import org.apache.sling.feature.extension.apiregions.api.config.validation.PropertyValidator;

public class FeatureValidator {
    private final ConfigurationValidator configurationValidator = new ConfigurationValidator();
    private final PropertyValidator propertyValidator = new PropertyValidator();
    private FeatureProvider featureProvider;
    private boolean liveValues = false;
    final Map<ArtifactId, Region> cache = new HashMap<ArtifactId, Region>();

    public FeatureValidator() {
        this.configurationValidator.setCache(this.cache);
    }

    public FeatureProvider getFeatureProvider() {
        return this.featureProvider;
    }

    public void setFeatureProvider(FeatureProvider provider) {
        this.featureProvider = provider;
    }

    public boolean isLiveValues() {
        return this.liveValues;
    }

    public void setLiveValues(boolean value) {
        this.liveValues = value;
        this.configurationValidator.setLiveValues(value);
        this.propertyValidator.setLiveValues(value);
    }

    public FeatureValidationResult validate(Feature feature) {
        return this.validate(feature, ConfigurationApi.getConfigurationApi(feature));
    }

    public FeatureValidationResult validate(Feature feature, ConfigurationApi api) {
        RegionInfo regionInfo;
        FeatureValidationResult result = new FeatureValidationResult();
        if (api == null) {
            throw new IllegalArgumentException();
        }
        this.cache.putAll(api.getFeatureToRegionCache());
        this.cache.put(feature.getId(), api.detectRegion());
        for (Configuration config : feature.getConfigurations()) {
            ConfigurationValidationResult cvr;
            ConfigurationValidationResult r;
            ConfigurableEntity desc;
            regionInfo = this.getRegionInfo(feature, config, this.cache);
            if (regionInfo == null) {
                ConfigurationValidationResult cvr2 = new ConfigurationValidationResult();
                cvr2.getErrors().add("Unable to properly validate configuration, region info cannot be determined");
                result.getConfigurationResults().put(config.getPid(), cvr2);
            } else if (config.isFactoryConfiguration()) {
                desc = api.getFactoryConfigurationDescriptions().get(config.getFactoryPid());
                if (desc != null) {
                    r = this.configurationValidator.validate(config, desc, regionInfo.region, api.getMode());
                    result.getConfigurationResults().put(config.getPid(), r);
                    if (regionInfo.region != Region.INTERNAL) {
                        if (((FactoryConfigurationDescription)desc).getOperations().isEmpty()) {
                            ConfigurationValidator.setResult(r, api.getMode(), desc, "No operations allowed for factory configuration");
                        } else if (regionInfo.isUpdate && !((FactoryConfigurationDescription)desc).getOperations().contains((Object)Operation.UPDATE)) {
                            ConfigurationValidator.setResult(r, api.getMode(), desc, "Updating of factory configuration is not allowed");
                        } else if (!regionInfo.isUpdate && !((FactoryConfigurationDescription)desc).getOperations().contains((Object)Operation.CREATE)) {
                            ConfigurationValidator.setResult(r, api.getMode(), desc, "Creation of factory configuration is not allowed");
                        }
                        if (((FactoryConfigurationDescription)desc).getInternalNames().contains(config.getName())) {
                            ConfigurationValidator.setResult(r, api.getMode(), desc, "Factory configuration with name is not allowed");
                        }
                    }
                } else if (regionInfo.region != Region.INTERNAL && api.getInternalFactoryConfigurations().contains(config.getFactoryPid())) {
                    cvr = new ConfigurationValidationResult();
                    ConfigurationValidator.setResult(cvr, api.getMode(), desc, "Factory configuration is not allowed");
                    result.getConfigurationResults().put(config.getPid(), cvr);
                }
            } else {
                desc = api.getConfigurationDescriptions().get(config.getPid());
                if (desc != null) {
                    r = this.configurationValidator.validate(config, desc, regionInfo.region, api.getMode());
                    result.getConfigurationResults().put(config.getPid(), r);
                } else if (regionInfo.region != Region.INTERNAL && api.getInternalConfigurations().contains(config.getPid())) {
                    cvr = new ConfigurationValidationResult();
                    ConfigurationValidator.setResult(cvr, api.getMode(), desc, "Configuration is not allowed");
                    result.getConfigurationResults().put(config.getPid(), cvr);
                }
            }
            result.getConfigurationResults().computeIfAbsent(config.getPid(), id -> new ConfigurationValidationResult());
        }
        for (String frameworkProperty : feature.getFrameworkProperties().keySet()) {
            regionInfo = this.getRegionInfo(feature, frameworkProperty, this.cache);
            if (regionInfo == null) {
                PropertyValidationResult pvr = new PropertyValidationResult();
                pvr.getErrors().add("Unable to properly validate framework property, region info cannot be determined");
                result.getFrameworkPropertyResults().put(frameworkProperty, pvr);
            } else {
                PropertyValidationResult pvr;
                FrameworkPropertyDescription fpd = api.getFrameworkPropertyDescriptions().get(frameworkProperty);
                if (fpd != null) {
                    pvr = this.propertyValidator.validate(feature.getFrameworkProperties().get(frameworkProperty), fpd, api.getMode());
                    result.getFrameworkPropertyResults().put(frameworkProperty, pvr);
                } else if (regionInfo.region != Region.INTERNAL && api.getInternalFrameworkProperties().contains(frameworkProperty)) {
                    pvr = new PropertyValidationResult();
                    PropertyValidator.setResult(pvr, null, api.getMode(), null, "Framework property is not allowed");
                    result.getFrameworkPropertyResults().put(frameworkProperty, pvr);
                }
            }
            result.getFrameworkPropertyResults().computeIfAbsent(frameworkProperty, id -> new PropertyValidationResult());
        }
        return result;
    }

    public boolean applyDefaultValues(Feature feature, FeatureValidationResult result) {
        boolean changed = false;
        for (Map.Entry<String, ConfigurationValidationResult> entry : result.getConfigurationResults().entrySet()) {
            Configuration cfg;
            if (entry.getValue().isUseDefaultValue() && (cfg = feature.getConfigurations().getConfiguration(entry.getKey())) != null) {
                ArrayList keys = new ArrayList(Collections.list(cfg.getConfigurationProperties().keys()));
                for (String k : keys) {
                    cfg.getProperties().remove(k);
                }
            }
            for (Map.Entry<String, PropertyValidationResult> propEntry : entry.getValue().getPropertyResults().entrySet()) {
                Configuration cfg2;
                if (!propEntry.getValue().isUseDefaultValue() || (cfg2 = feature.getConfigurations().getConfiguration(entry.getKey())) == null) continue;
                if (propEntry.getValue().getDefaultValue() == null) {
                    cfg2.getProperties().remove(propEntry.getKey());
                } else {
                    cfg2.getProperties().put(propEntry.getKey(), propEntry.getValue().getDefaultValue());
                }
                changed = true;
            }
        }
        for (Map.Entry<String, Object> entry : result.getFrameworkPropertyResults().entrySet()) {
            if (!((PropertyValidationResult)entry.getValue()).isUseDefaultValue()) continue;
            if (((PropertyValidationResult)entry.getValue()).getDefaultValue() == null) {
                feature.getFrameworkProperties().remove(entry.getKey());
            } else {
                feature.getFrameworkProperties().put(entry.getKey(), ((PropertyValidationResult)entry.getValue()).getDefaultValue().toString());
            }
            changed = true;
        }
        return changed;
    }

    static Region getConfigurationApiRegion(ArtifactId id, Map<ArtifactId, Region> cache) {
        Region result = cache.get(id);
        if (result == null) {
            result = Region.GLOBAL;
            cache.put(id, result);
        }
        return result;
    }

    RegionInfo getRegionInfo(Feature feature, Configuration cfg, Map<ArtifactId, Region> cache) {
        RegionInfo result = new RegionInfo();
        List list = cfg.getFeatureOrigins();
        if (!list.isEmpty()) {
            boolean global = false;
            for (ArtifactId id : list) {
                Region region = FeatureValidator.getConfigurationApiRegion(id, cache);
                if (region == null) {
                    return null;
                }
                if (region != Region.GLOBAL) continue;
                global = true;
                break;
            }
            result.region = global ? Region.GLOBAL : Region.INTERNAL;
            result.isUpdate = list.size() > 1;
        } else {
            Region region = FeatureValidator.getConfigurationApiRegion(feature.getId(), cache);
            result.region = region == Region.INTERNAL ? Region.INTERNAL : Region.GLOBAL;
            result.isUpdate = false;
        }
        return result;
    }

    static Region getRegionInfo(Region cfgRegion, Configuration cfg, String propertyName, Map<ArtifactId, Region> cache) {
        List list = cfg.getFeatureOrigins(propertyName);
        if (!list.isEmpty()) {
            boolean global = false;
            for (ArtifactId id : list) {
                Region region = FeatureValidator.getConfigurationApiRegion(id, cache);
                if (region == null) {
                    return null;
                }
                if (region != Region.GLOBAL) continue;
                global = true;
                break;
            }
            return global ? Region.GLOBAL : Region.INTERNAL;
        }
        return cfgRegion;
    }

    RegionInfo getRegionInfo(Feature feature, String frameworkProperty, Map<ArtifactId, Region> cache) {
        List list = feature.getFeatureOrigins(feature.getFrameworkPropertyMetadata(frameworkProperty));
        boolean global = false;
        for (ArtifactId id : list) {
            Region region = FeatureValidator.getConfigurationApiRegion(id, cache);
            if (region == null) {
                return null;
            }
            if (region != Region.GLOBAL) continue;
            global = true;
            break;
        }
        RegionInfo result = new RegionInfo();
        result.region = global ? Region.GLOBAL : Region.INTERNAL;
        result.isUpdate = list.size() > 1;
        return result;
    }

    static final class RegionInfo {
        public Region region;
        public boolean isUpdate;

        RegionInfo() {
        }
    }
}

