/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.extension.apiregions.analyser;

import java.io.IOException;
import javax.json.JsonArray;
import org.apache.sling.feature.Extension;
import org.apache.sling.feature.Extensions;
import org.apache.sling.feature.Feature;
import org.apache.sling.feature.analyser.task.AnalyserTask;
import org.apache.sling.feature.analyser.task.AnalyserTaskContext;
import org.apache.sling.feature.extension.apiregions.api.ApiRegions;

public abstract class AbstractApiRegionsAnalyserTask
implements AnalyserTask {
    public final void execute(AnalyserTaskContext ctx) throws Exception {
        ApiRegions apiRegions;
        Feature feature = ctx.getFeature();
        Extensions extensions = feature.getExtensions();
        Extension apiRegionsExtension = extensions.getByName("api-regions");
        if (apiRegionsExtension == null) {
            return;
        }
        if (apiRegionsExtension.getJSON() == null || apiRegionsExtension.getJSON().isEmpty()) {
            return;
        }
        if (apiRegionsExtension.getJSONStructure() == null) {
            ctx.reportError("API Regions '" + apiRegionsExtension.getJSON() + "' does not represent a valid JSON 'api-regions'");
            return;
        }
        try {
            apiRegions = ApiRegions.parse((JsonArray)apiRegionsExtension.getJSONStructure());
        }
        catch (IOException e) {
            ctx.reportError("API Regions '" + apiRegionsExtension.getJSON() + "' does not represent a valid JSON 'api-regions': " + e.getMessage());
            return;
        }
        this.execute(apiRegions, ctx);
    }

    protected abstract void execute(ApiRegions var1, AnalyserTaskContext var2) throws Exception;
}

