/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.packaging.impl;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Properties;
import java.util.regex.PatternSyntaxException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.vault.fs.config.MetaInf;
import org.apache.jackrabbit.vault.fs.io.AccessControlHandling;
import org.apache.jackrabbit.vault.fs.io.Archive;
import org.apache.jackrabbit.vault.fs.io.ImportOptions;
import org.apache.jackrabbit.vault.fs.io.Importer;
import org.apache.jackrabbit.vault.fs.io.ZipArchive;
import org.apache.jackrabbit.vault.fs.io.ZipNioArchive;
import org.apache.jackrabbit.vault.packaging.InstallContext;
import org.apache.jackrabbit.vault.packaging.InstallHookProcessor;
import org.apache.jackrabbit.vault.packaging.InstallHookProcessorFactory;
import org.apache.jackrabbit.vault.packaging.PackageException;
import org.apache.jackrabbit.vault.packaging.PackageId;
import org.apache.jackrabbit.vault.packaging.PackageProperties;
import org.apache.jackrabbit.vault.packaging.VaultPackage;
import org.apache.jackrabbit.vault.packaging.impl.AdminPermissionChecker;
import org.apache.jackrabbit.vault.packaging.impl.InstallContextImpl;
import org.apache.jackrabbit.vault.packaging.impl.InstallHookProcessorImpl;
import org.apache.jackrabbit.vault.packaging.impl.OsgiAwarePropertiesUtil;
import org.apache.jackrabbit.vault.packaging.impl.PackagePropertiesImpl;
import org.apache.jackrabbit.vault.packaging.registry.impl.AbstractPackageRegistry;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZipVaultPackage
extends PackagePropertiesImpl
implements VaultPackage,
Closeable {
    private static final Logger log = LoggerFactory.getLogger(ZipVaultPackage.class);
    private static final String PROP_USE_NIO_ARCHIVE = "vault.useNioArchive";
    private Archive archive;

    public ZipVaultPackage(File file, boolean isTmpFile) throws IOException {
        this(file, isTmpFile, false);
    }

    public ZipVaultPackage(File file, boolean isTmpFile, boolean strict) throws IOException {
        this(file.toPath(), isTmpFile, strict);
    }

    public ZipVaultPackage(Path file, boolean isTmpFile, boolean strict) throws IOException {
        this(OsgiAwarePropertiesUtil.getBooleanProperty(PROP_USE_NIO_ARCHIVE) ? new ZipNioArchive(file, isTmpFile) : new ZipArchive(file.toFile(), isTmpFile), strict);
    }

    public ZipVaultPackage(Archive archive, boolean strict) throws IOException {
        this.archive = archive;
        if (strict) {
            try {
                archive.open(true);
            }
            catch (IOException e) {
                throw new IOException("Error while loading package " + archive, e);
            }
        }
    }

    @Override
    public void close() {
        if (this.archive != null) {
            this.archive.close();
            this.archive = null;
        }
    }

    @Override
    public Archive getArchive() {
        if (this.archive == null) {
            PackageId packageId = this.getCachedId();
            String pidSuffix = packageId != null ? " (" + packageId + ")" : "";
            throw new IllegalStateException("Package already closed" + pidSuffix);
        }
        try {
            this.archive.open(false);
        }
        catch (IOException e) {
            throw new IllegalStateException("Archive " + this.archive + " not valid.", e);
        }
        return this.archive;
    }

    @Override
    public boolean isValid() {
        try {
            return this.getMetaInf().getFilter() != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public boolean isClosed() {
        return this.archive == null;
    }

    @Override
    public File getFile() {
        return this.archive instanceof ZipArchive ? ((ZipArchive)this.archive).getFile() : null;
    }

    @Override
    public MetaInf getMetaInf() {
        try {
            return this.getArchive().getMetaInf();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public long getSize() {
        return this.archive instanceof ZipArchive ? ((ZipArchive)this.archive).getFileSize() : -1L;
    }

    public void extract(Session session, ImportOptions opts, @NotNull AbstractPackageRegistry.SecurityConfig securityConfig, boolean isStrict, boolean isOverwritePrimaryTypesOfFolders) throws PackageException, RepositoryException {
        this.extract(this.prepareExtract(session, opts, securityConfig, isStrict, isOverwritePrimaryTypesOfFolders), null);
    }

    @Override
    public void extract(Session session, ImportOptions opts) throws RepositoryException, PackageException {
        this.extract(session, opts, new AbstractPackageRegistry.SecurityConfig(null, null), false, true);
    }

    @Override
    public PackageProperties getProperties() {
        return this;
    }

    protected InstallContextImpl prepareExtract(Session session, ImportOptions opts, @NotNull AbstractPackageRegistry.SecurityConfig securityConfig, boolean isStrictByDefault, boolean overwritePrimaryTypesOfFoldersByDefault) throws PackageException, RepositoryException {
        if (!this.isValid()) {
            throw new IllegalStateException("Package not valid.");
        }
        InstallHookProcessor hooks = opts instanceof InstallHookProcessorFactory ? ((InstallHookProcessorFactory)((Object)opts)).createInstallHookProcessor() : new InstallHookProcessorImpl();
        try {
            String cndPattern;
            if (!opts.isDryRun()) {
                hooks.registerHooks(this.archive, opts.getHookClassLoader());
            }
            this.checkAllowanceToInstallPackage(session, hooks, securityConfig);
            if (Boolean.parseBoolean(this.getProperty("noIntermediateSaves"))) {
                opts.setAutoSaveThreshold(0x7FFFFFFE);
            }
            Importer importer = new Importer(opts, isStrictByDefault, overwritePrimaryTypesOfFoldersByDefault);
            AccessControlHandling ac = this.getACHandling();
            if (opts.getAccessControlHandling() == null) {
                opts.setAccessControlHandling(ac);
            }
            if ((cndPattern = this.getProperty("cndPattern")) != null) {
                try {
                    opts.setCndPattern(cndPattern);
                }
                catch (PatternSyntaxException e) {
                    throw new PackageException("Specified CND pattern not valid.", e);
                }
            }
            return new InstallContextImpl(session, "/", this, importer, hooks);
        }
        catch (RepositoryException | PackageException e) {
            try {
                hooks.close();
            }
            catch (IOException exceptionDuringClose) {
                e.addSuppressed(exceptionDuringClose);
            }
            throw e;
        }
    }

    protected void checkAllowanceToInstallPackage(@NotNull Session session, @NotNull InstallHookProcessor hookProcessor, @NotNull AbstractPackageRegistry.SecurityConfig securityConfig) throws PackageException, RepositoryException {
        if (this.requiresRoot() && !AdminPermissionChecker.hasAdministrativePermissions(session, securityConfig.getAuthIdsForRootInstallation())) {
            throw new PackageException("Package extraction requires admin session as it has the 'requiresRoot' flag (userid '" + session.getUserID() + "' not allowed).");
        }
        if (hookProcessor.hasHooks() && !AdminPermissionChecker.hasAdministrativePermissions(session, securityConfig.getAuthIdsForHookExecution())) {
            throw new PackageException("Package extraction requires admin session as it has a hook (userid '" + session.getUserID() + "' not allowed).");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void extract(InstallContextImpl ctx, List<String> subPackages) throws RepositoryException, PackageException {
        log.debug("Extracting {}", (Object)this.getId());
        InstallHookProcessor hooks = ctx.getHooks();
        Importer importer = ctx.getImporter();
        try {
            if (!hooks.execute(ctx)) {
                ctx.setPhase(InstallContext.Phase.PREPARE_FAILED);
                hooks.execute(ctx);
                throw new PackageException("Error while executing an install hook during prepare phase.");
            }
            try {
                importer.run(this.archive, ctx.getSession(), ctx.getImportRootPath());
            }
            catch (Exception e) {
                log.error("Error during install.", (Throwable)e);
                ctx.setPhase(InstallContext.Phase.INSTALL_FAILED);
                hooks.execute(ctx);
                if (e instanceof RepositoryException) {
                    throw (RepositoryException)((Object)e);
                }
                throw new PackageException(e);
            }
            ctx.setPhase(InstallContext.Phase.INSTALLED);
            if (!hooks.execute(ctx)) {
                ctx.setPhase(InstallContext.Phase.INSTALL_FAILED);
                hooks.execute(ctx);
                throw new PackageException("Error while executing an install hook during installed phase.");
            }
            if (importer.hasErrors() && ctx.getOptions().isStrict(importer.isStrictByDefault())) {
                ctx.setPhase(InstallContext.Phase.INSTALL_FAILED);
                hooks.execute(ctx);
                throw new PackageException("Errors during import.");
            }
        }
        finally {
            ctx.setPhase(InstallContext.Phase.END);
            hooks.execute(ctx);
            try {
                hooks.close();
            }
            catch (IOException e) {
                log.warn("Error closing hook processor", (Throwable)e);
            }
        }
        if (subPackages != null) {
            subPackages.addAll(importer.getSubPackages());
        }
        log.debug("Extracting {} completed.", (Object)this.getId());
    }

    @Override
    protected Properties getPropertiesMap() {
        return this.getMetaInf().getProperties();
    }
}

