/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.cpconverter.vltpkg;

import java.io.IOException;
import java.util.Map;
import org.apache.jackrabbit.vault.fs.io.Archive;
import org.apache.jackrabbit.vault.packaging.PackageId;
import org.apache.jackrabbit.vault.packaging.PackageManager;
import org.apache.sling.feature.cpconverter.ContentPackage2FeatureModelConverter;
import org.apache.sling.feature.cpconverter.ConverterException;
import org.apache.sling.feature.cpconverter.handlers.EntryHandler;
import org.apache.sling.feature.cpconverter.handlers.GroupEntryHandler;
import org.apache.sling.feature.cpconverter.handlers.SlingInitialContentBundleHandler;
import org.apache.sling.feature.cpconverter.handlers.UsersEntryHandler;
import org.apache.sling.feature.cpconverter.handlers.VersionResolverContentPackageEntryHandler;
import org.apache.sling.feature.cpconverter.vltpkg.BaseVaultPackageScanner;
import org.jetbrains.annotations.NotNull;

public final class RecollectorVaultPackageScanner
extends BaseVaultPackageScanner {
    private final ContentPackage2FeatureModelConverter converter;
    private final EntryHandler[] handlers;

    public RecollectorVaultPackageScanner(@NotNull ContentPackage2FeatureModelConverter converter, @NotNull PackageManager packageManager, boolean strictValidation, @NotNull Map<PackageId, String> subContentPackages, @NotNull ContentPackage2FeatureModelConverter.SlingInitialContentPolicy slingInitialContentPolicy) {
        super(packageManager, strictValidation);
        this.converter = converter;
        VersionResolverContentPackageEntryHandler versionResolverContentPackageEntryHandler = new VersionResolverContentPackageEntryHandler(this, subContentPackages);
        this.handlers = new EntryHandler[]{new UsersEntryHandler(), new GroupEntryHandler(), versionResolverContentPackageEntryHandler, new SlingInitialContentBundleHandler(versionResolverContentPackageEntryHandler, slingInitialContentPolicy)};
    }

    @Override
    protected void onFile(@NotNull String path, @NotNull Archive archive, @NotNull Archive.Entry entry) throws IOException, ConverterException {
        for (EntryHandler handler : this.handlers) {
            if (!handler.matches(path)) continue;
            handler.handle(path, archive, entry, this.converter);
        }
    }
}

