/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.cpconverter.vltpkg;

import java.io.IOException;
import java.io.OutputStream;
import java.util.AbstractMap;
import java.util.Map;
import javax.jcr.NamespaceException;
import javax.jcr.RepositoryException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.NameFactory;
import org.apache.jackrabbit.spi.commons.conversion.IllegalNameException;
import org.apache.jackrabbit.spi.commons.conversion.NameParser;
import org.apache.jackrabbit.spi.commons.name.NameFactoryImpl;
import org.apache.jackrabbit.spi.commons.namespace.NamespaceResolver;
import org.apache.jackrabbit.util.Text;
import org.apache.jackrabbit.vault.fs.io.DocViewFormat;
import org.apache.jackrabbit.vault.util.xml.serialize.FormattingXmlStreamWriter;
import org.apache.jackrabbit.vault.util.xml.serialize.OutputFormat;
import org.apache.sling.contentparser.api.ContentHandler;
import org.apache.sling.feature.cpconverter.vltpkg.DocViewSerializerContentHandlerException;
import org.apache.sling.feature.cpconverter.vltpkg.JcrNamespaceRegistry;
import org.apache.sling.feature.cpconverter.vltpkg.ValueConverter;
import org.jetbrains.annotations.NotNull;

public class DocViewSerializerContentHandler
implements ContentHandler,
AutoCloseable {
    private final XMLStreamWriter writer;
    private final JcrNamespaceRegistry nsRegistry;
    private String currentPath = "/";
    boolean isFirstElement = true;

    public DocViewSerializerContentHandler(OutputStream outputStream, JcrNamespaceRegistry nsRegistry) {
        this.nsRegistry = nsRegistry;
        try {
            this.writer = FormattingXmlStreamWriter.create((OutputStream)outputStream, (OutputFormat)new DocViewFormat().getXmlOutputFormat());
            this.writer.writeStartDocument();
            this.writer.setNamespaceContext(nsRegistry);
        }
        catch (XMLStreamException e) {
            throw new DocViewSerializerContentHandlerException("Can not start document", e);
        }
    }

    public void resource(String path, Map<String, Object> properties) {
        String parent = Text.getRelativeParent((String)path, (int)1);
        String name = Text.getName((String)path);
        if (name.isEmpty()) {
            name = "jcr:root";
        }
        if (!parent.equals(this.currentPath)) {
            this.closeParents(parent);
        }
        this.currentPath = path;
        try {
            Map.Entry<String, Name> prefixAndQualifiedName = this.resolvePrefixedName(name);
            this.writeElement(prefixAndQualifiedName);
            if (this.isFirstElement) {
                for (String prefix : this.nsRegistry.getPrefixes()) {
                    this.writer.writeNamespace(prefix, this.nsRegistry.getURI(prefix));
                }
                this.isFirstElement = false;
            }
            for (Map.Entry entry : properties.entrySet()) {
                prefixAndQualifiedName = this.resolvePrefixedName((String)entry.getKey());
                this.writer.writeAttribute(prefixAndQualifiedName.getKey(), prefixAndQualifiedName.getValue().getNamespaceURI(), prefixAndQualifiedName.getValue().getLocalName(), ValueConverter.toString((String)entry.getKey(), entry.getValue()));
            }
        }
        catch (XMLStreamException e) {
            throw new DocViewSerializerContentHandlerException("Can not start element", e);
        }
        catch (RepositoryException e) {
            throw new DocViewSerializerContentHandlerException("Can not emit namespace declarations", e);
        }
    }

    private boolean writeElement(Map.Entry<String, Name> prefixAndQualifiedName) throws XMLStreamException {
        String key = prefixAndQualifiedName.getKey();
        String namespaceURI = prefixAndQualifiedName.getValue().getNamespaceURI();
        String localName = this.getValidLocalName(prefixAndQualifiedName);
        if (StringUtils.isNotBlank((CharSequence)localName)) {
            if (StringUtils.isNotBlank((CharSequence)namespaceURI) && StringUtils.isNotBlank((CharSequence)this.nsRegistry.getPrefix(namespaceURI)) && StringUtils.isNotBlank((CharSequence)key)) {
                this.writer.writeStartElement(namespaceURI, localName);
            } else if (StringUtils.isNotBlank((CharSequence)namespaceURI) && StringUtils.isNotBlank((CharSequence)key)) {
                this.writer.writeStartElement(key, namespaceURI, localName);
            } else {
                this.writer.writeStartElement(localName);
            }
        } else {
            return false;
        }
        return true;
    }

    @NotNull
    private String getValidLocalName(Map.Entry<String, Name> prefixAndQualifiedName) {
        String localName = prefixAndQualifiedName.getValue().getLocalName();
        String firstCharacter = localName.substring(0, 1);
        if (StringUtils.isNumeric((CharSequence)firstCharacter)) {
            localName = "_x003" + firstCharacter + "_" + StringUtils.substring((String)localName, (int)1);
        }
        return localName;
    }

    public void closeParents(String stopAtParent) {
        try {
            while (!this.currentPath.equals(stopAtParent)) {
                this.writer.writeEndElement();
                String newCurrentPath = Text.getRelativeParent((String)this.currentPath, (int)1);
                if (!newCurrentPath.equals(this.currentPath)) {
                    this.currentPath = newCurrentPath;
                    continue;
                }
                break;
            }
        }
        catch (XMLStreamException e) {
            throw new DocViewSerializerContentHandlerException("Can not end element", e);
        }
    }

    Map.Entry<String, Name> resolvePrefixedName(String name) {
        int posColon = name.indexOf(58);
        if (posColon == -1) {
            return new AbstractMap.SimpleEntry<String, Name>("", NameFactoryImpl.getInstance().create("", name));
        }
        try {
            String prefix = name.substring(0, posColon);
            return new AbstractMap.SimpleEntry<String, Name>(prefix, NameParser.parse((String)name, (NamespaceResolver)this.nsRegistry, (NameFactory)NameFactoryImpl.getInstance()));
        }
        catch (NamespaceException | IllegalNameException e) {
            throw new DocViewSerializerContentHandlerException("Could not resolve namespace URI for name " + name, e);
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.closeParents("");
            this.writer.writeEndDocument();
        }
        catch (XMLStreamException e) {
            throw new DocViewSerializerContentHandlerException("Can not end document", e);
        }
    }
}

