/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.cpconverter.handlers.slinginitialcontent;

import java.util.Set;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.feature.cpconverter.handlers.slinginitialcontent.SlingInitialContentBundleEntryMetaData;
import org.apache.sling.feature.cpconverter.handlers.slinginitialcontent.VaultContentXMLContentCreator;
import org.jetbrains.annotations.NotNull;

class ContentPackageEntryPathComputer {
    private final Set<SlingInitialContentBundleEntryMetaData> bundleEntries;
    private final String contentPackageEntryPath;
    private final VaultContentXMLContentCreator contentCreator;

    ContentPackageEntryPathComputer(@NotNull Set<SlingInitialContentBundleEntryMetaData> bundleEntries, @NotNull String contentPackageEntryPath, @NotNull VaultContentXMLContentCreator contentCreator) {
        this.bundleEntries = bundleEntries;
        this.contentPackageEntryPath = contentPackageEntryPath;
        this.contentCreator = contentCreator;
    }

    @NotNull
    String compute() {
        String recomputedContentPackageEntryPath = FilenameUtils.removeExtension((String)this.contentPackageEntryPath);
        if (StringUtils.isNotBlank((CharSequence)this.contentCreator.getPrimaryNodeName())) {
            recomputedContentPackageEntryPath = StringUtils.substringBeforeLast((String)recomputedContentPackageEntryPath, (String)"/");
            recomputedContentPackageEntryPath = recomputedContentPackageEntryPath + "/" + this.contentCreator.getPrimaryNodeName();
        }
        String checkIfRecomputedPathCandidate = StringUtils.removeStart((String)recomputedContentPackageEntryPath, (String)"/jcr_root");
        recomputedContentPackageEntryPath = this.bundleEntries.stream().anyMatch(bundleEntry -> StringUtils.equals((CharSequence)checkIfRecomputedPathCandidate, (CharSequence)bundleEntry.getRepositoryPath())) ? recomputedContentPackageEntryPath + ".dir/" + ".content.xml" : recomputedContentPackageEntryPath + "/" + ".content.xml";
        return recomputedContentPackageEntryPath;
    }
}

