/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.osgi;

import aQute.bnd.annotation.ConsumerType;
import aQute.bnd.annotation.ProviderType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.sling.commons.osgi.ServiceUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ProviderType
public final class RankedServices<T>
implements Iterable<T> {
    private final ChangeListener changeListener;
    private final SortedMap<Comparable<Object>, T> serviceMap = new TreeMap<Comparable<Object>, T>();
    private volatile Collection<T> sortedServices = Collections.emptyList();

    public RankedServices() {
        this(null);
    }

    public RankedServices(ChangeListener changeListener) {
        this.changeListener = changeListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bind(T service, Map<String, Object> props) {
        SortedMap<Comparable<Object>, T> sortedMap = this.serviceMap;
        synchronized (sortedMap) {
            this.serviceMap.put(ServiceUtil.getComparableForServiceRanking(props), service);
            this.updateSortedServices();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbind(T service, Map<String, Object> props) {
        SortedMap<Comparable<Object>, T> sortedMap = this.serviceMap;
        synchronized (sortedMap) {
            this.serviceMap.remove(ServiceUtil.getComparableForServiceRanking(props));
            this.updateSortedServices();
        }
    }

    private void updateSortedServices() {
        ArrayList<T> copiedList = new ArrayList<T>(this.serviceMap.values());
        this.sortedServices = Collections.unmodifiableList(copiedList);
        if (this.changeListener != null) {
            this.changeListener.changed();
        }
    }

    public Collection<T> get() {
        return this.sortedServices;
    }

    @Override
    public Iterator<T> iterator() {
        return this.sortedServices.iterator();
    }

    @ConsumerType
    public static interface ChangeListener {
        public void changed();
    }
}

