/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.cpconverter.accesscontrol;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.jcr.NamespaceException;
import org.apache.jackrabbit.spi.PrivilegeDefinition;
import org.apache.jackrabbit.spi.commons.conversion.DefaultNamePathResolver;
import org.apache.jackrabbit.spi.commons.conversion.NameResolver;
import org.apache.jackrabbit.spi.commons.namespace.NamespaceResolver;
import org.apache.jackrabbit.util.Text;
import org.apache.jackrabbit.vault.fs.spi.PrivilegeDefinitions;
import org.apache.sling.feature.cpconverter.ConverterException;
import org.apache.sling.feature.cpconverter.accesscontrol.AbstractUser;
import org.apache.sling.feature.cpconverter.accesscontrol.AccessControlEntry;
import org.apache.sling.feature.cpconverter.accesscontrol.AclManager;
import org.apache.sling.feature.cpconverter.accesscontrol.EnforceInfo;
import org.apache.sling.feature.cpconverter.accesscontrol.Group;
import org.apache.sling.feature.cpconverter.accesscontrol.Mapping;
import org.apache.sling.feature.cpconverter.accesscontrol.SystemUser;
import org.apache.sling.feature.cpconverter.accesscontrol.User;
import org.apache.sling.feature.cpconverter.features.FeaturesManager;
import org.apache.sling.feature.cpconverter.repoinit.NoOpVisitor;
import org.apache.sling.feature.cpconverter.repoinit.OperationProcessor;
import org.apache.sling.feature.cpconverter.repoinit.createpath.CreatePathSegmentProcessor;
import org.apache.sling.feature.cpconverter.shared.RepoPath;
import org.apache.sling.feature.cpconverter.vltpkg.VaultPackageAssembler;
import org.apache.sling.repoinit.parser.RepoInitParsingException;
import org.apache.sling.repoinit.parser.impl.RepoInitParserService;
import org.apache.sling.repoinit.parser.impl.WithPathOptions;
import org.apache.sling.repoinit.parser.operations.AclLine;
import org.apache.sling.repoinit.parser.operations.CreatePath;
import org.apache.sling.repoinit.parser.operations.CreateServiceUser;
import org.apache.sling.repoinit.parser.operations.DisableServiceUser;
import org.apache.sling.repoinit.parser.operations.Operation;
import org.apache.sling.repoinit.parser.operations.OperationVisitor;
import org.apache.sling.repoinit.parser.operations.RegisterNodetypes;
import org.apache.sling.repoinit.parser.operations.RegisterPrivilege;
import org.apache.sling.repoinit.parser.operations.SetAclPrincipalBased;
import org.apache.sling.repoinit.parser.operations.SetAclPrincipals;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAclManager
implements AclManager,
EnforceInfo {
    private static final Logger log = LoggerFactory.getLogger(DefaultAclManager.class);
    private final RepoPath enforcePrincipalBasedSupportedPath;
    private final String systemRelPath;
    private final OperationProcessor processor = new OperationProcessor();
    private final Set<SystemUser> systemUsers = new LinkedHashSet<SystemUser>();
    private final Set<SystemUser> globalSystemUsers = new LinkedHashSet<SystemUser>();
    private final Set<String> systemUserIds = new LinkedHashSet<String>();
    private final Set<Group> groups = new LinkedHashSet<Group>();
    private final Set<User> users = new LinkedHashSet<User>();
    private final Set<Mapping> mappings = new HashSet<Mapping>();
    private final Set<String> mappedById = new HashSet<String>();
    private final Map<String, List<AccessControlEntry>> acls = new HashMap<String, List<AccessControlEntry>>();
    private final List<RegisterNodetypes> nodetypeOperations = new LinkedList<RegisterNodetypes>();
    private volatile PrivilegeDefinitions privilegeDefinitions;
    private RepoPath userRootPath;

    public DefaultAclManager() throws ConverterException {
        this(null, "system");
    }

    public DefaultAclManager(@Nullable String enforcePrincipalBasedSupportedPath, @NotNull String systemRelPath) throws ConverterException {
        if (enforcePrincipalBasedSupportedPath != null && !enforcePrincipalBasedSupportedPath.contains(systemRelPath)) {
            throw new ConverterException("Relative path for system users " + systemRelPath + " not included in " + enforcePrincipalBasedSupportedPath);
        }
        this.enforcePrincipalBasedSupportedPath = enforcePrincipalBasedSupportedPath == null ? null : new RepoPath(enforcePrincipalBasedSupportedPath);
        this.systemRelPath = systemRelPath;
    }

    @Override
    public boolean addUser(@NotNull User user) {
        return this.users.add(user);
    }

    @Override
    public boolean addGroup(@NotNull Group group) {
        return this.groups.add(group);
    }

    @Override
    public boolean addSystemUser(@NotNull SystemUser systemUser) {
        this.globalSystemUsers.add(systemUser);
        if (this.systemUsers.add(systemUser)) {
            this.recordSystemUserIds(systemUser.getId());
            this.setUserRoot(systemUser.getPath());
            return true;
        }
        return false;
    }

    @Override
    public void addMapping(@NotNull Mapping mapping) {
        if (this.mappings.add(mapping)) {
            for (SystemUser user : this.globalSystemUsers) {
                if (!mapping.mapsUser(user.getId())) continue;
                this.mappedById.add(user.getId());
            }
        }
    }

    @Override
    public boolean addAccessControlEntry(@NotNull String systemUser, @NotNull AccessControlEntry acl) {
        if (this.globalSystemUsers.stream().filter(su -> su.getId().equals(systemUser)).findFirst().isPresent()) {
            this.acls.computeIfAbsent(systemUser, k -> new LinkedList()).add(acl);
            return true;
        }
        return false;
    }

    @Override
    public void addRepoinitExtension(@NotNull List<VaultPackageAssembler> packageAssemblers, @NotNull FeaturesManager featureManager) throws IOException, ConverterException {
        try (Formatter formatter = new Formatter();){
            if (this.privilegeDefinitions != null) {
                DefaultAclManager.registerPrivileges(this.privilegeDefinitions, formatter);
            }
            for (RegisterNodetypes op : this.nodetypeOperations) {
                formatter.format("%s", op.asRepoInitString());
            }
            this.addUsersAndGroups(formatter);
            this.addPaths(formatter, packageAssemblers);
            this.acls.forEach((systemUserID, authorizations) -> this.globalSystemUsers.stream().filter(su -> su.getId().equals(systemUserID)).findFirst().ifPresent(systemUser -> this.addStatements((SystemUser)systemUser, (List<AccessControlEntry>)authorizations, formatter)));
            String text = formatter.toString();
            if (!text.isEmpty()) {
                featureManager.addOrAppendRepoInitExtension("content-package", text, null);
            }
        }
    }

    @Override
    public void addRepoinitExtention(@NotNull String source, @Nullable String repoInitText, @Nullable String runMode, @NotNull FeaturesManager featuresManager) throws IOException, ConverterException {
        if (repoInitText == null || repoInitText.trim().isEmpty()) {
            return;
        }
        if ("seed".equalsIgnoreCase(runMode)) {
            try {
                List ops = new RepoInitParserService().parse((Reader)new StringReader(repoInitText));
                for (Operation op : ops) {
                    op.accept((OperationVisitor)new NoOpVisitor(){

                        @Override
                        public void visitCreateServiceUser(CreateServiceUser createServiceUser) {
                            DefaultAclManager.this.recordSystemUserIds(createServiceUser.getUsername());
                        }
                    });
                }
            }
            catch (RepoInitParsingException e) {
                throw new ConverterException(e.getMessage(), e);
            }
            return;
        }
        try (Formatter formatter = new Formatter();){
            if (this.enforcePrincipalBased()) {
                List ops = new RepoInitParserService().parse((Reader)new StringReader(repoInitText));
                this.processor.apply(ops, formatter, this);
            } else {
                formatter.format("%s", repoInitText);
            }
            String text = formatter.toString().trim();
            if (!text.isEmpty()) {
                featuresManager.addOrAppendRepoInitExtension(source, text, runMode);
            }
        }
        catch (RepoInitParsingException e) {
            throw new ConverterException(e.getMessage(), e);
        }
    }

    private void addUsersAndGroups(@NotNull Formatter formatter) throws ConverterException {
        for (SystemUser systemUser : this.systemUsers) {
            CreateServiceUser operation = new CreateServiceUser(systemUser.getId(), new WithPathOptions(this.calculateIntermediatePath(systemUser), this.enforcePrincipalBased(systemUser)));
            formatter.format("%s", operation.asRepoInitString());
            if (systemUser.getDisabledReason() != null) {
                DisableServiceUser disable = new DisableServiceUser(systemUser.getId(), systemUser.getDisabledReason());
                disable.setServiceUser(true);
                formatter.format("%s", disable.asRepoInitString());
            }
            if (!this.aclIsBelow(systemUser.getPath())) continue;
            throw new ConverterException("Detected policy on subpath of system-user: " + systemUser);
        }
        for (Group g : this.groups) {
            if (!this.aclStartsWith(g.getPath())) continue;
            throw new ConverterException("Detected policy on group: " + g);
        }
        for (User u : this.users) {
            if (!this.aclStartsWith(u.getPath())) continue;
            throw new ConverterException("Detected policy on user: " + u);
        }
    }

    @NotNull
    private String calculateIntermediatePath(@NotNull SystemUser systemUser) throws ConverterException {
        RepoPath intermediatePath = systemUser.getIntermediatePath();
        if (this.enforcePrincipalBased(systemUser)) {
            return this.calculateEnforcedIntermediatePath(intermediatePath.toString());
        }
        return this.getRelativeIntermediatePath(intermediatePath.toString());
    }

    private void addPaths(@NotNull Formatter formatter, @NotNull List<VaultPackageAssembler> packageAssemblers) {
        Set paths = this.acls.entrySet().stream().filter(entry -> {
            Optional<SystemUser> su = this.getSystemUser((String)entry.getKey());
            return su.isPresent() && !this.enforcePrincipalBased(su.get());
        }).map(Map.Entry::getValue).flatMap(Collection::stream).filter(((Predicate<AccessControlEntry>)AccessControlEntry::isPrincipalBased).negate()).map(AccessControlEntry::getRepositoryPath).collect(Collectors.toSet());
        paths.stream().filter(path -> paths.stream().noneMatch(other -> !other.equals(path) && other.startsWith((RepoPath)path))).filter(((Predicate<RepoPath>)RepoPath::isRepositoryPath).negate()).filter(path -> Stream.of(this.systemUsers, this.users, this.groups).flatMap(Collection::stream).noneMatch(user -> user.getPath().startsWith((RepoPath)path))).map(path -> this.getCreatePath((RepoPath)path, packageAssemblers)).filter(Objects::nonNull).forEach(path -> formatter.format("%s", path.asRepoInitString()));
    }

    private boolean aclStartsWith(@NotNull RepoPath path) {
        return this.acls.values().stream().flatMap(Collection::stream).anyMatch(acl -> acl.getRepositoryPath().startsWith(path));
    }

    private boolean aclIsBelow(@NotNull RepoPath path) {
        return this.acls.values().stream().flatMap(Collection::stream).anyMatch(acl -> acl.getRepositoryPath().startsWith(path) && !acl.getRepositoryPath().equals(path));
    }

    private void addStatements(@NotNull SystemUser systemUser, @NotNull List<AccessControlEntry> authorizations, @NotNull Formatter formatter) {
        SetAclPrincipalBased operation;
        LinkedHashMap<AccessControlEntry, String> resourceEntries = new LinkedHashMap<AccessControlEntry, String>();
        LinkedHashMap<AccessControlEntry, String> principalEntries = new LinkedHashMap<AccessControlEntry, String>();
        authorizations.forEach(entry -> {
            String path = this.getRepoInitPath(entry.getRepositoryPath(), systemUser);
            if (entry.isPrincipalBased() || this.enforcePrincipalBased(systemUser)) {
                principalEntries.put((AccessControlEntry)entry, path);
            } else {
                resourceEntries.put((AccessControlEntry)entry, path);
            }
        });
        if (!principalEntries.isEmpty()) {
            operation = new SetAclPrincipalBased(Collections.singletonList(systemUser.getId()), DefaultAclManager.asAcLines(principalEntries));
            formatter.format("%s", operation.asRepoInitString());
        }
        if (!resourceEntries.isEmpty()) {
            operation = new SetAclPrincipals(Collections.singletonList(systemUser.getId()), DefaultAclManager.asAcLines(resourceEntries));
            formatter.format("%s", operation.asRepoInitString());
        }
    }

    private static List<AclLine> asAcLines(@NotNull Map<AccessControlEntry, String> entries) {
        ArrayList<AclLine> lines = new ArrayList<AclLine>();
        entries.forEach((entry, path) -> lines.add(entry.asAclLine((String)path)));
        return lines;
    }

    private boolean enforcePrincipalBased() {
        return this.enforcePrincipalBasedSupportedPath != null;
    }

    private boolean enforcePrincipalBased(@NotNull SystemUser systemUser) {
        return this.enforcePrincipalBased(systemUser.getId());
    }

    @NotNull
    private Optional<SystemUser> getSystemUser(@NotNull String id) {
        return this.systemUsers.stream().filter(systemUser -> systemUser.getId().equals(id)).findFirst();
    }

    @Override
    public void addNodetypeRegistration(@NotNull String cndStatements) {
        this.nodetypeOperations.add(new RegisterNodetypes(cndStatements));
    }

    @Override
    public void addPrivilegeDefinitions(@NotNull PrivilegeDefinitions privilegeDefinitions) {
        this.privilegeDefinitions = privilegeDefinitions;
    }

    @Override
    public void reset() {
        this.systemUsers.clear();
        this.acls.clear();
        this.nodetypeOperations.clear();
        this.privilegeDefinitions = null;
    }

    @Override
    public void recordSystemUserIds(String ... systemUserIds) {
        for (String id : systemUserIds) {
            if (!this.systemUserIds.add(id) || !this.mappings.stream().anyMatch(mapping -> mapping.mapsUser(id))) continue;
            this.mappedById.add(id);
        }
    }

    @Override
    public boolean enforcePrincipalBased(@NotNull String systemUserId) {
        if (this.enforcePrincipalBased() && this.systemUserIds.contains(systemUserId)) {
            if (this.mappedById.contains(systemUserId)) {
                log.warn("Skip enforcing principal-based access control setup for system user '{}' due to existing mapping by id.", (Object)systemUserId);
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public String calculateEnforcedIntermediatePath(@Nullable String intermediatePath) throws ConverterException {
        if (this.enforcePrincipalBasedSupportedPath == null) {
            throw new IllegalStateException("No supported path configured");
        }
        String supportedPath = this.getRelativeIntermediatePath(this.enforcePrincipalBasedSupportedPath.toString());
        if (intermediatePath == null || intermediatePath.isEmpty()) {
            return supportedPath;
        }
        String relIntermediate = this.getRelativeIntermediatePath(intermediatePath);
        if (Text.isDescendantOrEqual((String)supportedPath, (String)relIntermediate)) {
            return relIntermediate;
        }
        String parent = Text.getRelativeParent((String)relIntermediate, (int)1);
        while (!parent.isEmpty() && !"/".equals(parent)) {
            if (Text.isDescendantOrEqual((String)parent, (String)supportedPath)) {
                String relpath = relIntermediate.substring(parent.length());
                return supportedPath + relpath;
            }
            parent = Text.getRelativeParent((String)parent, (int)1);
        }
        throw new ConverterException("Cannot calculate intermediate path for service user. Configured Supported path " + this.enforcePrincipalBasedSupportedPath + " has no common ancestor with " + intermediatePath);
    }

    @NotNull
    private String getRelativeIntermediatePath(@NotNull String intermediatePath) throws ConverterException {
        String rel;
        if (intermediatePath.equals(this.systemRelPath) || intermediatePath.startsWith(this.systemRelPath + "/")) {
            return intermediatePath;
        }
        String p = intermediatePath + "/";
        int i = p.indexOf(rel = "/" + this.systemRelPath + "/");
        if (i == -1) {
            throw new ConverterException("Invalid intermediate path for system user " + intermediatePath + ". Must include " + this.systemRelPath);
        }
        return intermediatePath.substring(i + 1);
    }

    @Nullable
    protected CreatePath getCreatePath(@NotNull RepoPath path, @NotNull List<VaultPackageAssembler> packageAssemblers) {
        if (path.getParent() == null) {
            log.debug("Omit create path statement for path '{}'", (Object)path);
            return null;
        }
        CreatePath cp = new CreatePath(null);
        boolean foundType = CreatePathSegmentProcessor.processSegments(path, packageAssemblers, cp);
        if (!foundType && this.isBelowUserRoot(path)) {
            log.warn("Failed to extract primary type information for node at path '{}'", (Object)path);
            return null;
        }
        return cp;
    }

    @NotNull
    private String getRepoInitPath(@NotNull RepoPath path, @NotNull SystemUser systemUser) {
        if (path.isRepositoryPath()) {
            return ":repository";
        }
        if (DefaultAclManager.isHomePath(path, systemUser.getPath())) {
            return DefaultAclManager.getHomePath(systemUser);
        }
        AbstractUser other = DefaultAclManager.getOtherUser(path, Stream.of(this.systemUsers, this.groups).flatMap(Collection::stream));
        if (other != null) {
            return DefaultAclManager.getHomePath(other);
        }
        return path.toString();
    }

    private static boolean isHomePath(@NotNull RepoPath path, @NotNull RepoPath systemUserPath) {
        return path.equals(systemUserPath);
    }

    @Nullable
    private static AbstractUser getOtherUser(@NotNull RepoPath path, @NotNull Stream<? extends AbstractUser> abstractUsers) {
        return abstractUsers.filter(au -> path.startsWith(au.getPath())).findFirst().orElse(null);
    }

    @NotNull
    private static String getHomePath(@NotNull AbstractUser abstractUser) {
        return "home(" + abstractUser.getId() + ")";
    }

    private static void registerPrivileges(@NotNull PrivilegeDefinitions definitions, @NotNull Formatter formatter) {
        DefaultNamePathResolver nameResolver = new DefaultNamePathResolver((NamespaceResolver)definitions.getNamespaceMapping());
        for (PrivilegeDefinition privilege : definitions.getDefinitions()) {
            try {
                RegisterPrivilege operation = new RegisterPrivilege(nameResolver.getJCRName(privilege.getName()), privilege.isAbstract(), DefaultAclManager.getAggregatedNames(privilege, (NameResolver)nameResolver));
                formatter.format("%s", operation.asRepoInitString());
            }
            catch (NamespaceException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    @NotNull
    private static List<String> getAggregatedNames(@NotNull PrivilegeDefinition definition, @NotNull NameResolver nameResolver) {
        Set aggregatedNames = definition.getDeclaredAggregateNames();
        if (aggregatedNames.isEmpty()) {
            return Collections.emptyList();
        }
        return aggregatedNames.stream().map(name -> {
            try {
                return nameResolver.getJCRName(name);
            }
            catch (NamespaceException e) {
                throw new IllegalStateException(e);
            }
        }).collect(Collectors.toList());
    }

    private void setUserRoot(@NotNull RepoPath userPath) {
        if (this.userRootPath == null) {
            this.userRootPath = new RepoPath(Text.getAbsoluteParent((String)userPath.toString(), (int)0));
        }
    }

    private boolean isBelowUserRoot(@NotNull RepoPath path) {
        return this.userRootPath != null && path.startsWith(this.userRootPath);
    }
}

