/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.validation.spi.impl.nodetype;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.jcr.NamespaceException;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.ValueFormatException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.jcr2spi.nodetype.EffectiveNodeType;
import org.apache.jackrabbit.jcr2spi.nodetype.ItemDefinitionProvider;
import org.apache.jackrabbit.jcr2spi.nodetype.NodeTypeDefinitionProvider;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.QNodeDefinition;
import org.apache.jackrabbit.spi.QNodeTypeDefinition;
import org.apache.jackrabbit.spi.QPropertyDefinition;
import org.apache.jackrabbit.spi.QValue;
import org.apache.jackrabbit.spi.QValueFactory;
import org.apache.jackrabbit.spi.commons.conversion.IllegalNameException;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.spi.commons.conversion.NameResolver;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.apache.jackrabbit.spi.commons.name.NameFactoryImpl;
import org.apache.jackrabbit.spi.commons.nodetype.constraint.ValueConstraint;
import org.apache.jackrabbit.spi.commons.value.ValueFormat;
import org.apache.jackrabbit.value.ValueHelper;
import org.apache.jackrabbit.vault.fs.api.WorkspaceFilter;
import org.apache.jackrabbit.vault.fs.spi.ACLManagement;
import org.apache.jackrabbit.vault.fs.spi.UserManagement;
import org.apache.jackrabbit.vault.fs.spi.impl.jcr20.JackrabbitUserManagement;
import org.apache.jackrabbit.vault.fs.spi.impl.jcr20.JcrACLManagement;
import org.apache.jackrabbit.vault.util.DocViewNode;
import org.apache.jackrabbit.vault.util.DocViewProperty;
import org.apache.jackrabbit.vault.util.Text;
import org.apache.jackrabbit.vault.validation.spi.DocumentViewXmlValidator;
import org.apache.jackrabbit.vault.validation.spi.JcrPathValidator;
import org.apache.jackrabbit.vault.validation.spi.NodeContext;
import org.apache.jackrabbit.vault.validation.spi.ValidationMessage;
import org.apache.jackrabbit.vault.validation.spi.ValidationMessageSeverity;
import org.apache.jackrabbit.vault.validation.spi.impl.nodetype.DocViewPropertyValueFactory;
import org.apache.jackrabbit.vault.validation.spi.impl.nodetype.NodeNameAndType;
import org.apache.jackrabbit.vault.validation.spi.impl.nodetype.NodeTypeManagerProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeTypeValidator
implements DocumentViewXmlValidator,
JcrPathValidator {
    static final String MESSAGE_MANDATORY_CHILD_NODE_MISSING = "Mandatory child node missing: %s";
    static final String MESSAGE_PROPERTY_ERROR = "Error while retrieving property '%s': %s";
    static final String MESSAGE_UNKNOWN_NODE_TYPE_OR_NAMESPACE = "%s. Skip validation of nodes with that type/name";
    static final String MESSAGE_MISSING_PRIMARY_TYPE = "Mandatory jcr:primaryType missing on node '%s'";
    static final String MESSAGE_PROPERTY_NOT_ALLOWED = "Property '%s' is not allowed in node with types '[%s]': %s";
    static final String MESSAGE_MANDATORY_PROPERTY_MISSING = "Mandatory property '%s' missing in node with types [%s]";
    static final String MESSAGE_CHILD_NODE_OF_NOT_CONTAINED_PARENT_POTENTIALLY_NOT_ALLOWED = "Node '%s' is not allowed as child of not contained node with potential default types '[%s]': %s";
    static final String MESSAGE_CHILD_NODE_NOT_ALLOWED = "Node '%s' is not allowed as child of node with types '[%s]': %s";
    private final WorkspaceFilter filter;
    private final ValidationMessageSeverity defaultSeverity;
    private final ValidationMessageSeverity severityForUnknownNodeTypes;
    private final DocViewPropertyValueFactory docViewPropertyValueFactory;
    private final NodeTypeManagerProvider ntManagerProvider;
    private final Set<String> loggedUnknownNodeTypeMessages;
    private final EffectiveNodeType defaultType;
    private final UserManagement userManagement;
    private final ACLManagement aclManagement;
    private NodeContext protectedNodeContext;
    private Map<String, NodeNameAndType> nodeTypePerPath;
    private static final Collection<Name> ALLOWED_PROTECTED_PROPERTIES = Arrays.asList(NameConstants.JCR_PRIMARYTYPE, NameConstants.JCR_MIXINTYPES);
    private static final Map<Name, List<Name>> IGNORED_MANDATORY_PROPERTIES_PER_NODE_TYPE = Stream.of(new AbstractMap.SimpleEntry<Name, List<Name>>(NameConstants.NT_RESOURCE, Arrays.asList(NameConstants.JCR_DATA))).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue));

    public NodeTypeValidator(@NotNull WorkspaceFilter filter, @NotNull NodeTypeManagerProvider ntManagerProvider, @NotNull EffectiveNodeType defaultEffectiveNodeType, @NotNull ValidationMessageSeverity defaultSeverity, @NotNull ValidationMessageSeverity severityForUnknownNodeTypes) {
        this.filter = filter;
        this.ntManagerProvider = ntManagerProvider;
        this.defaultType = defaultEffectiveNodeType;
        this.defaultSeverity = defaultSeverity;
        this.severityForUnknownNodeTypes = severityForUnknownNodeTypes;
        this.docViewPropertyValueFactory = new DocViewPropertyValueFactory();
        this.userManagement = new JackrabbitUserManagement();
        this.aclManagement = new JcrACLManagement();
        this.loggedUnknownNodeTypeMessages = new HashSet<String>();
        this.nodeTypePerPath = new TreeMap<String, NodeNameAndType>();
    }

    static String getDocViewNodeLabel(DocViewNode node) {
        StringBuilder sb = new StringBuilder(node.name);
        sb.append(" [").append(node.primary);
        if (node.mixins != null && node.mixins.length > 0) {
            sb.append(" (").append(StringUtils.join((Object[])node.mixins, (String)", ")).append(")");
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    @Nullable
    public Collection<ValidationMessage> validate(@NotNull DocViewNode node, @NotNull NodeContext nodeContext, boolean isRoot) {
        if (node.primary == null) {
            if (this.filter.contains(nodeContext.getNodePath()) && !node.props.isEmpty()) {
                return Collections.singleton(new ValidationMessage(this.defaultSeverity, String.format(MESSAGE_MISSING_PRIMARY_TYPE, nodeContext.getNodePath())));
            }
            return null;
        }
        if (this.aclManagement.isACLNodeType(node.primary) || this.userManagement.isAuthorizableNodeType(node.primary)) {
            this.protectedNodeContext = nodeContext;
        }
        boolean allowProtectedSubNodesAndProperties = this.protectedNodeContext != null;
        LinkedList<ValidationMessage> messages = new LinkedList<ValidationMessage>();
        String parentNodePath = Text.getRelativeParent((String)nodeContext.getNodePath(), (int)1);
        NodeNameAndType parentNodeNameAndType = this.nodeTypePerPath.get(parentNodePath);
        NodeNameAndType newNodeNameAndType = null;
        try {
            if (!this.aclManagement.isACLNodeType(node.primary)) {
                String constraintViolation;
                boolean useDefaultNodeType;
                EffectiveNodeType parentNodeType;
                if (parentNodeNameAndType == null || !this.filter.contains(parentNodePath)) {
                    parentNodeType = this.defaultType;
                    useDefaultNodeType = true;
                } else if (!parentNodeNameAndType.isUnknown()) {
                    parentNodeType = parentNodeNameAndType.getEffectiveNodeType();
                    useDefaultNodeType = false;
                } else {
                    parentNodeType = null;
                    useDefaultNodeType = false;
                }
                if (parentNodeType != null && (constraintViolation = NodeTypeValidator.getChildNodeConstraintViolation(node, parentNodeType, this.ntManagerProvider.getNodeTypeDefinitionProvider(), this.ntManagerProvider.getNameResolver(), this.ntManagerProvider.getItemDefinitionProvider(), allowProtectedSubNodesAndProperties)) != null) {
                    messages.add(new ValidationMessage(this.defaultSeverity, String.format(useDefaultNodeType ? MESSAGE_CHILD_NODE_OF_NOT_CONTAINED_PARENT_POTENTIALLY_NOT_ALLOWED : MESSAGE_CHILD_NODE_NOT_ALLOWED, NodeTypeValidator.getDocViewNodeLabel(node), NodeTypeValidator.effectiveNodeTypeToString(this.ntManagerProvider.getNameResolver(), parentNodeType), constraintViolation)));
                }
            }
            newNodeNameAndType = new NodeNameAndType(this.ntManagerProvider.getNameResolver(), this.ntManagerProvider.getEffectiveNodeTypeProvider(), node);
            this.nodeTypePerPath.put(nodeContext.getNodePath(), newNodeNameAndType);
            ArrayList<Name> foundProperties = new ArrayList<Name>(node.props.size());
            for (DocViewProperty property : node.props.values()) {
                String constraintViolation = this.getPropertyConstraintViolation(property, newNodeNameAndType.getEffectiveNodeType(), allowProtectedSubNodesAndProperties);
                if (constraintViolation != null) {
                    messages.add(new ValidationMessage(this.defaultSeverity, String.format(MESSAGE_PROPERTY_NOT_ALLOWED, property, NodeTypeValidator.effectiveNodeTypeToString(this.ntManagerProvider.getNameResolver(), newNodeNameAndType.getEffectiveNodeType()), constraintViolation)));
                }
                foundProperties.add(NameFactoryImpl.getInstance().create(property.name));
            }
            for (QPropertyDefinition mandatoryPropertyDefinition : newNodeNameAndType.getEffectiveNodeType().getMandatoryQPropertyDefinitions()) {
                List<Name> ignoredProperties;
                if (mandatoryPropertyDefinition.isAutoCreated() || foundProperties.contains(mandatoryPropertyDefinition.getName()) || (ignoredProperties = IGNORED_MANDATORY_PROPERTIES_PER_NODE_TYPE.get(mandatoryPropertyDefinition.getDeclaringNodeType())) != null && ignoredProperties.contains(mandatoryPropertyDefinition.getName())) continue;
                messages.add(new ValidationMessage(this.defaultSeverity, String.format(MESSAGE_MANDATORY_PROPERTY_MISSING, mandatoryPropertyDefinition.getName(), NodeTypeValidator.effectiveNodeTypeToString(this.ntManagerProvider.getNameResolver(), newNodeNameAndType.getEffectiveNodeType()))));
            }
        }
        catch (NamespaceException | NoSuchNodeTypeException | IllegalNameException e) {
            if (!this.loggedUnknownNodeTypeMessages.contains(e.getMessage())) {
                messages.add(new ValidationMessage(this.severityForUnknownNodeTypes, String.format(MESSAGE_UNKNOWN_NODE_TYPE_OR_NAMESPACE, e.getMessage()), e));
                this.loggedUnknownNodeTypeMessages.add(e.getMessage());
            }
            if (newNodeNameAndType == null) {
                this.nodeTypePerPath.put(nodeContext.getNodePath(), NodeNameAndType.createUnknownNodeNameAndType(parentNodeNameAndType));
            }
        }
        catch (RepositoryException e) {
            throw new IllegalStateException("Could not validate nodes/properties against node types: " + e.getMessage(), e);
        }
        return messages;
    }

    @Override
    @Nullable
    public Collection<ValidationMessage> validateEnd(@NotNull DocViewNode node, @NotNull NodeContext nodeContext, boolean isRoot) {
        NodeNameAndType currentNodeNameAndType;
        if (nodeContext.equals(this.protectedNodeContext)) {
            this.protectedNodeContext = null;
        }
        if ((currentNodeNameAndType = this.nodeTypePerPath.get(nodeContext.getNodePath())) != null && !currentNodeNameAndType.isUnknown()) {
            LinkedList<ValidationMessage> messages = new LinkedList<ValidationMessage>();
            for (QNodeDefinition mandatoryNodeType : currentNodeNameAndType.getEffectiveNodeType().getMandatoryQNodeDefinitions()) {
                boolean foundRequiredChildNode;
                NodeNameAndType childNodeType;
                try {
                    childNodeType = this.nodeTypePerPath.get(nodeContext.getNodePath() + "/" + this.ntManagerProvider.getNameResolver().getJCRName(mandatoryNodeType.getName()));
                }
                catch (NamespaceException e1) {
                    throw new IllegalStateException("Could not find namespace for mandatory child node" + mandatoryNodeType.getName());
                }
                boolean bl = foundRequiredChildNode = childNodeType != null && childNodeType.fulfillsNodeDefinition(mandatoryNodeType);
                if (foundRequiredChildNode) continue;
                try {
                    messages.add(new ValidationMessage(this.defaultSeverity, String.format(MESSAGE_MANDATORY_CHILD_NODE_MISSING, NodeTypeValidator.nodeDefinitionToString(this.ntManagerProvider.getNameResolver(), mandatoryNodeType))));
                }
                catch (NamespaceException e) {
                    throw new IllegalStateException("Could not give out node types and name for " + mandatoryNodeType, e);
                }
            }
            return messages;
        }
        return null;
    }

    @Override
    @Nullable
    public Collection<ValidationMessage> validateJcrPath(@NotNull NodeContext nodeContext, boolean isFolder) {
        if (isFolder && !this.nodeTypePerPath.containsKey(nodeContext.getNodePath())) {
            try {
                NodeNameAndType nodeNameAndType = new NodeNameAndType(this.ntManagerProvider.getNameResolver(), this.ntManagerProvider.getEffectiveNodeTypeProvider(), Text.getName((String)nodeContext.getNodePath()), "{http://www.jcp.org/jcr/nt/1.0}folder", new String[0]);
                this.nodeTypePerPath.put(nodeContext.getNodePath(), nodeNameAndType);
            }
            catch (NamespaceException | NoSuchNodeTypeException | IllegalNameException e) {
                if (!this.loggedUnknownNodeTypeMessages.contains(e.getMessage())) {
                    this.loggedUnknownNodeTypeMessages.add(e.getMessage());
                    return Collections.singleton(new ValidationMessage(this.severityForUnknownNodeTypes, String.format(MESSAGE_UNKNOWN_NODE_TYPE_OR_NAMESPACE, e.getMessage()), e));
                }
            }
            catch (RepositoryException e) {
                throw new IllegalStateException("Could not validate nodes/properties against node types: " + e.getMessage(), e);
            }
        }
        return null;
    }

    static String effectiveNodeTypeToString(NameResolver nameResolver, EffectiveNodeType nodeType) throws NamespaceException {
        return NodeTypeValidator.joinAsQualifiedJcrName(nameResolver, nodeType.getMergedNodeTypes());
    }

    static String nodeDefinitionToString(NameResolver nameResolver, QNodeDefinition nodeDefinition) throws NamespaceException {
        return nameResolver.getJCRName(nodeDefinition.getName()) + " [" + NodeTypeValidator.joinAsQualifiedJcrName(nameResolver, nodeDefinition.getRequiredPrimaryTypes()) + "]";
    }

    private static String joinAsQualifiedJcrName(NameResolver nameResolver, Name[] names) throws NamespaceException {
        StringBuilder types = new StringBuilder();
        String delimiter = "";
        for (Name name : names) {
            types.append(delimiter).append(nameResolver.getJCRName(name));
            delimiter = ", ";
        }
        return types.toString();
    }

    private static QPropertyDefinition getPropertyDefinition(Name name, int type, EffectiveNodeType effectiveNodeType, ItemDefinitionProvider itemDefinitionProvider, boolean multiValued) throws NoSuchNodeTypeException, ConstraintViolationException {
        QPropertyDefinition def;
        try {
            def = itemDefinitionProvider.getQPropertyDefinition(effectiveNodeType.getAllNodeTypes(), name, type, multiValued);
        }
        catch (ConstraintViolationException e) {
            if (type != 0) {
                def = itemDefinitionProvider.getQPropertyDefinition(effectiveNodeType.getAllNodeTypes(), name, 0, multiValued);
            }
            throw e;
        }
        return def;
    }

    private static void validateValueConstraints(Value value, QPropertyDefinition def, ValueFactory valueFactory, QValueFactory qValueFactory, NamePathResolver namePathResolver) throws RepositoryException {
        Value v = def.getRequiredType() != 0 && def.getRequiredType() != value.getType() ? ValueHelper.convert((Value)value, (int)def.getRequiredType(), (ValueFactory)valueFactory) : value;
        QValue qValue = ValueFormat.getQValue((Value)v, (NamePathResolver)namePathResolver, (QValueFactory)qValueFactory);
        ValueConstraint.checkValueConstraints((QPropertyDefinition)def, (QValue[])new QValue[]{qValue});
    }

    String getPropertyConstraintViolation(DocViewProperty property, EffectiveNodeType effectiveNodeType, boolean allowProtected) throws RepositoryException {
        Name name = this.ntManagerProvider.getNameResolver().getQName(property.name);
        try {
            if (property.isMulti) {
                return NodeTypeValidator.getPropertyConstraintViolation(name, this.docViewPropertyValueFactory.getValues(property), effectiveNodeType, this.ntManagerProvider.getItemDefinitionProvider(), this.ntManagerProvider.getJcrValueFactory(), this.ntManagerProvider.getQValueFactory(), this.ntManagerProvider.getNamePathResolver(), allowProtected);
            }
            return NodeTypeValidator.getPropertyConstraintViolation(name, this.docViewPropertyValueFactory.getValue(property), effectiveNodeType, this.ntManagerProvider.getItemDefinitionProvider(), this.ntManagerProvider.getJcrValueFactory(), this.ntManagerProvider.getQValueFactory(), this.ntManagerProvider.getNamePathResolver(), allowProtected);
        }
        catch (NamespaceException e) {
            throw new NamespaceException(String.format(MESSAGE_PROPERTY_ERROR, property.name, e.getMessage()), (Throwable)e);
        }
        catch (RepositoryException e) {
            throw new RepositoryException(String.format(MESSAGE_PROPERTY_ERROR, property.name, e.getMessage()), (Throwable)e);
        }
    }

    static String getPropertyConstraintViolation(Name name, Value value, EffectiveNodeType effectiveNodeType, ItemDefinitionProvider itemDefinitionProvider, ValueFactory valueFactory, QValueFactory qValueFactory, NamePathResolver namePathResolver, boolean allowProtected) throws RepositoryException {
        QPropertyDefinition def;
        try {
            def = NodeTypeValidator.getPropertyDefinition(name, value.getType(), effectiveNodeType, itemDefinitionProvider, false);
        }
        catch (ConstraintViolationException t) {
            return "No property definition found for name!";
        }
        if (def.isProtected() && !allowProtected && !ALLOWED_PROTECTED_PROPERTIES.contains(name)) {
            return "Property is protected!";
        }
        try {
            NodeTypeValidator.validateValueConstraints(value, def, valueFactory, qValueFactory, namePathResolver);
        }
        catch (ConstraintViolationException e) {
            return "Property value does not satisfy constraints: " + e.getLocalizedMessage();
        }
        catch (ValueFormatException e) {
            return "Cannot convert property into type '" + def.getRequiredType() + "': " + e.getLocalizedMessage();
        }
        return null;
    }

    static String getPropertyConstraintViolation(Name name, Value[] values, EffectiveNodeType effectiveNodeType, ItemDefinitionProvider itemDefinitionProvider, ValueFactory valueFactory, QValueFactory qValueFactory, NamePathResolver namePathResolver, boolean allowProtected) throws RepositoryException {
        QPropertyDefinition def;
        int type = values.length > 0 ? values[0].getType() : 0;
        try {
            def = NodeTypeValidator.getPropertyDefinition(name, type, effectiveNodeType, itemDefinitionProvider, true);
        }
        catch (ConstraintViolationException t) {
            return "No property definition found for name!";
        }
        if (def.isProtected() && !allowProtected && !ALLOWED_PROTECTED_PROPERTIES.contains(name)) {
            return "Property is protected!";
        }
        if (!def.isMultiple()) {
            return "Property must be single-value!";
        }
        for (Value value : values) {
            try {
                NodeTypeValidator.validateValueConstraints(value, def, valueFactory, qValueFactory, namePathResolver);
            }
            catch (ConstraintViolationException e) {
                return "Property value does not satisfy constraints: " + e.getLocalizedMessage();
            }
            catch (ValueFormatException e) {
                return "Cannot convert property into type '" + def.getRequiredType() + "': " + e.getLocalizedMessage();
            }
        }
        return null;
    }

    static String getChildNodeConstraintViolation(DocViewNode node, EffectiveNodeType nodeType, NodeTypeDefinitionProvider nodeTypeDefinitionProvider, NameResolver nameResolver, ItemDefinitionProvider itemDefinitionProvider, boolean allowProtected) throws RepositoryException {
        QNodeTypeDefinition nodeTypeDefinition;
        Name nodeName;
        try {
            nodeName = nameResolver.getQName(node.name);
        }
        catch (NamespaceException | IllegalNameException e) {
            throw new IllegalNameException("Invalid node name " + node.name + ": '" + e.getMessage() + "'", e);
        }
        try {
            nodeTypeDefinition = nodeTypeDefinitionProvider.getNodeTypeDefinition(nameResolver.getQName(node.primary));
        }
        catch (NamespaceException | IllegalNameException e) {
            throw new IllegalNameException("Invalid primary type " + node.primary + ": '" + e.getMessage() + "'", e);
        }
        if (nodeTypeDefinition.isAbstract()) {
            return "Not allowed to add node with abstract node type as primary type";
        }
        if (nodeTypeDefinition.isMixin()) {
            return "Not allowed to add node with a mixin as primary node type";
        }
        try {
            QNodeDefinition nd = itemDefinitionProvider.getQNodeDefinition(nodeType, nodeName, nodeTypeDefinition.getName());
            if (!allowProtected && nd.isProtected()) {
                return "Node is protected and can not be manually added";
            }
            if (nd.isAutoCreated()) {
                return "Node is auto-created and can not be manually added";
            }
        }
        catch (ConstraintViolationException e) {
            return "Could not find matching child node definition in parent's node type";
        }
        return null;
    }

    @Override
    @Nullable
    public Collection<ValidationMessage> done() {
        return null;
    }
}

