/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.validation.spi.impl.nodetype;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import javax.jcr.AccessDeniedException;
import javax.jcr.NamespaceException;
import javax.jcr.NamespaceRegistry;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.ValueFactory;
import javax.jcr.nodetype.InvalidNodeTypeDefinitionException;
import javax.jcr.nodetype.NodeTypeExistsException;
import javax.jcr.nodetype.NodeTypeManager;
import org.apache.jackrabbit.commons.cnd.CndImporter;
import org.apache.jackrabbit.commons.cnd.ParseException;
import org.apache.jackrabbit.jcr2spi.ManagerProvider;
import org.apache.jackrabbit.jcr2spi.NamespaceRegistryImpl;
import org.apache.jackrabbit.jcr2spi.NamespaceStorage;
import org.apache.jackrabbit.jcr2spi.hierarchy.HierarchyManager;
import org.apache.jackrabbit.jcr2spi.lock.LockStateManager;
import org.apache.jackrabbit.jcr2spi.nodetype.EffectiveNodeTypeProvider;
import org.apache.jackrabbit.jcr2spi.nodetype.ItemDefinitionProvider;
import org.apache.jackrabbit.jcr2spi.nodetype.ItemDefinitionProviderImpl;
import org.apache.jackrabbit.jcr2spi.nodetype.NodeTypeDefinitionProvider;
import org.apache.jackrabbit.jcr2spi.nodetype.NodeTypeManagerImpl;
import org.apache.jackrabbit.jcr2spi.nodetype.NodeTypeRegistry;
import org.apache.jackrabbit.jcr2spi.nodetype.NodeTypeRegistryImpl;
import org.apache.jackrabbit.jcr2spi.security.AccessManager;
import org.apache.jackrabbit.jcr2spi.security.authorization.AccessControlProvider;
import org.apache.jackrabbit.jcr2spi.version.VersionManager;
import org.apache.jackrabbit.spi.QValueFactory;
import org.apache.jackrabbit.spi.commons.conversion.DefaultNamePathResolver;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.spi.commons.conversion.NameResolver;
import org.apache.jackrabbit.spi.commons.conversion.PathResolver;
import org.apache.jackrabbit.spi.commons.namespace.NamespaceMapping;
import org.apache.jackrabbit.spi.commons.namespace.NamespaceResolver;
import org.apache.jackrabbit.spi.commons.namespace.RegistryNamespaceResolver;
import org.apache.jackrabbit.spi.commons.nodetype.NodeTypeStorage;
import org.apache.jackrabbit.spi.commons.nodetype.NodeTypeStorageImpl;
import org.apache.jackrabbit.spi.commons.value.QValueFactoryImpl;
import org.apache.jackrabbit.value.ValueFactoryImpl;

public class NodeTypeManagerProvider
implements ManagerProvider,
NamespaceStorage {
    private final NamespaceMapping namespaceMapping = new NamespaceMapping();
    private final NamespaceRegistry namespaceRegistry;
    private final NamespaceResolver namespaceResolver;
    private final NamePathResolver npResolver;
    private final NodeTypeStorage nodeTypeStorage;
    private final NodeTypeRegistryImpl nodeTypeRegistry;
    private final NodeTypeManagerImpl nodeTypeManager;
    private final ItemDefinitionProvider itemDefinitionProvider;

    public NodeTypeManagerProvider() throws IOException, RepositoryException, ParseException {
        this.namespaceMapping.setMapping("", "");
        this.namespaceRegistry = new NamespaceRegistryImpl((NamespaceStorage)this);
        this.namespaceResolver = new RegistryNamespaceResolver(this.namespaceRegistry);
        this.npResolver = new DefaultNamePathResolver(this.namespaceResolver);
        this.nodeTypeStorage = new NodeTypeStorageImpl();
        this.nodeTypeRegistry = NodeTypeRegistryImpl.create((NodeTypeStorage)this.nodeTypeStorage, (NamespaceRegistry)this.namespaceRegistry);
        this.nodeTypeManager = new NodeTypeManagerImpl((NodeTypeRegistry)this.nodeTypeRegistry, (ManagerProvider)this);
        this.itemDefinitionProvider = new ItemDefinitionProviderImpl((EffectiveNodeTypeProvider)this.nodeTypeRegistry, null, null);
        try (InputStreamReader reader = new InputStreamReader(this.getClass().getResourceAsStream("/default-nodetypes.cnd"), StandardCharsets.US_ASCII);){
            this.registerNodeTypes(reader);
        }
    }

    public void registerNodeTypes(Reader reader) throws InvalidNodeTypeDefinitionException, NodeTypeExistsException, UnsupportedRepositoryOperationException, ParseException, RepositoryException, IOException {
        CndImporter.registerNodeTypes((Reader)reader, null, (NodeTypeManager)this.nodeTypeManager, (NamespaceRegistry)this.namespaceRegistry, (ValueFactory)this.getJcrValueFactory(), (boolean)false);
    }

    public NamePathResolver getNamePathResolver() {
        return this.npResolver;
    }

    public NameResolver getNameResolver() {
        return this.npResolver;
    }

    public PathResolver getPathResolver() {
        return this.npResolver;
    }

    public NamespaceResolver getNamespaceResolver() {
        return this.namespaceResolver;
    }

    public NodeTypeManager getNodeTypeManager() {
        return this.nodeTypeManager;
    }

    public HierarchyManager getHierarchyManager() {
        throw new UnsupportedOperationException();
    }

    public AccessManager getAccessManager() {
        throw new UnsupportedOperationException();
    }

    public LockStateManager getLockStateManager() {
        throw new UnsupportedOperationException();
    }

    public VersionManager getVersionStateManager() {
        throw new UnsupportedOperationException();
    }

    public ItemDefinitionProvider getItemDefinitionProvider() {
        return this.itemDefinitionProvider;
    }

    public NodeTypeDefinitionProvider getNodeTypeDefinitionProvider() {
        return this.nodeTypeManager;
    }

    public EffectiveNodeTypeProvider getEffectiveNodeTypeProvider() {
        return this.nodeTypeRegistry;
    }

    public ValueFactory getJcrValueFactory() throws RepositoryException {
        return ValueFactoryImpl.getInstance();
    }

    public QValueFactory getQValueFactory() throws RepositoryException {
        return QValueFactoryImpl.getInstance();
    }

    public AccessControlProvider getAccessControlProvider() throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    public Map<String, String> getRegisteredNamespaces() throws RepositoryException {
        return this.namespaceMapping.getPrefixToURIMapping();
    }

    public String getPrefix(String uri) throws NamespaceException, RepositoryException {
        return this.namespaceMapping.getPrefix(uri);
    }

    public String getURI(String prefix) throws NamespaceException, RepositoryException {
        return this.namespaceMapping.getURI(prefix);
    }

    public void registerNamespace(String prefix, String uri) throws NamespaceException, UnsupportedRepositoryOperationException, AccessDeniedException, RepositoryException {
        this.namespaceMapping.setMapping(prefix, uri);
    }

    public void unregisterNamespace(String uri) throws NamespaceException, UnsupportedRepositoryOperationException, AccessDeniedException, RepositoryException {
        this.namespaceMapping.removeMapping(uri);
    }
}

