/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.validation.spi.impl;

import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import org.apache.jackrabbit.vault.fs.api.ImportMode;
import org.apache.jackrabbit.vault.fs.api.PathFilterSet;
import org.apache.jackrabbit.vault.fs.api.WorkspaceFilter;
import org.apache.jackrabbit.vault.util.DocViewNode;
import org.apache.jackrabbit.vault.validation.spi.DocumentViewXmlValidator;
import org.apache.jackrabbit.vault.validation.spi.ValidationMessage;
import org.apache.jackrabbit.vault.validation.spi.ValidationMessageSeverity;
import org.jetbrains.annotations.NotNull;

public class MergeLimitationsValidator
implements DocumentViewXmlValidator {
    protected static final String PACKAGE_NON_ROOT_NODE_MERGED = "Non-empty Node '%s' is supposed to be imported with mode 'merge' but it is not the aggregator's root node. This is currently not supported by FileVault (https://issues.apache.org/jira/browse/JCRVLT-255).";
    private final ValidationMessageSeverity severity;
    private final Collection<String> rootNodePathsOfMergeRules;

    public MergeLimitationsValidator(ValidationMessageSeverity severity, WorkspaceFilter filter) {
        this.severity = severity;
        this.rootNodePathsOfMergeRules = new LinkedList<String>();
        for (PathFilterSet pathFilterSet : filter.getFilterSets()) {
            if (pathFilterSet.getImportMode() != ImportMode.MERGE) continue;
            this.rootNodePathsOfMergeRules.add(pathFilterSet.getRoot());
        }
    }

    @Override
    public Collection<ValidationMessage> done() {
        return null;
    }

    @Override
    public Collection<ValidationMessage> validate(@NotNull DocViewNode node, @NotNull String nodePath, @NotNull Path filePath, boolean isRoot) {
        if (!isRoot && !node.props.isEmpty() && this.rootNodePathsOfMergeRules.contains(nodePath)) {
            return Collections.singleton(new ValidationMessage(this.severity, String.format(PACKAGE_NON_ROOT_NODE_MERGED, nodePath)));
        }
        return null;
    }
}

