/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.fs;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.vault.fs.api.AccessType;
import org.apache.jackrabbit.vault.fs.api.Artifact;
import org.apache.jackrabbit.vault.fs.api.VaultFile;

public class VaultFileInputStream
extends InputStream {
    private final InputStream base;
    private File tmpFile;

    public VaultFileInputStream(VaultFile file) throws IOException {
        block9: {
            Artifact a = file.getArtifact();
            if (a == null || a.getPreferredAccess() == AccessType.NONE) {
                throw new IOException("invalid access.");
            }
            try {
                if (a.getPreferredAccess() == AccessType.STREAM) {
                    this.base = a.getInputStream();
                    break block9;
                }
                this.tmpFile = File.createTempFile("vltfs", ".spool");
                try (FileOutputStream out = new FileOutputStream(this.tmpFile);){
                    a.spool(out);
                }
                this.base = new FileInputStream(this.tmpFile);
            }
            catch (RepositoryException e) {
                throw new IOException(e.toString());
            }
        }
    }

    @Override
    public int read() throws IOException {
        return this.base.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.base.read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.base.read(b, off, len);
    }

    @Override
    public long skip(long n) throws IOException {
        return this.base.skip(n);
    }

    @Override
    public int available() throws IOException {
        return this.base.available();
    }

    @Override
    public void close() throws IOException {
        this.base.close();
        if (this.tmpFile != null) {
            this.tmpFile.delete();
            this.tmpFile.deleteOnExit();
            this.tmpFile = null;
        }
    }

    @Override
    public void mark(int readlimit) {
        this.base.mark(readlimit);
    }

    @Override
    public void reset() throws IOException {
        this.base.reset();
    }

    @Override
    public boolean markSupported() {
        return this.base.markSupported();
    }
}

