/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.cpconverter.vltpkg;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import javax.jcr.NamespaceException;
import javax.jcr.NamespaceRegistry;
import javax.jcr.RepositoryException;
import javax.jcr.ValueFactory;
import javax.jcr.nodetype.NodeTypeManager;
import javax.xml.namespace.NamespaceContext;
import org.apache.jackrabbit.commons.SimpleValueFactory;
import org.apache.jackrabbit.commons.cnd.CndImporter;
import org.apache.jackrabbit.commons.cnd.ParseException;
import org.apache.jackrabbit.spi.commons.namespace.NamespaceResolver;
import org.apache.jackrabbit.vault.validation.spi.impl.nodetype.NodeTypeManagerProvider;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JcrNamespaceRegistry
implements NamespaceRegistry,
NamespaceResolver,
NamespaceContext {
    private final Collection<String> registeredCndSystemIds = new ArrayList<String>();
    private final NodeTypeManagerProvider ntManagerProvider = new NodeTypeManagerProvider();
    private final NodeTypeManager ntManager = this.ntManagerProvider.getNodeTypeManager();
    private final Logger logger = LoggerFactory.getLogger(JcrNamespaceRegistry.class);

    public JcrNamespaceRegistry() throws RepositoryException, ParseException, IOException {
        this.ntManagerProvider.registerNamespace("xml", "http://www.w3.org/XML/1998/namespace");
        this.ntManagerProvider.registerNamespace("sling", "http://sling.apache.org/jcr/sling/1.0");
    }

    public void registerCnd(Reader reader, String systemId) throws ParseException, RepositoryException, IOException {
        SimpleValueFactory valueFactory = new SimpleValueFactory();
        CndImporter.registerNodeTypes((Reader)reader, (String)systemId, (NodeTypeManager)this.ntManager, (NamespaceRegistry)this, (ValueFactory)valueFactory, (boolean)false);
        this.registeredCndSystemIds.add(systemId);
    }

    public void registerNamespace(String prefix, String uri) throws RepositoryException {
        this.ntManagerProvider.registerNamespace(prefix, uri);
    }

    public void unregisterNamespace(String prefix) throws RepositoryException {
        this.ntManagerProvider.unregisterNamespace(prefix);
    }

    public String[] getPrefixes() throws RepositoryException {
        return this.ntManagerProvider.getRegisteredNamespaces().keySet().toArray(new String[0]);
    }

    public String[] getURIs() throws RepositoryException {
        return this.ntManagerProvider.getRegisteredNamespaces().values().toArray(new String[0]);
    }

    public String getURI(String prefix) throws NamespaceException {
        try {
            return this.ntManagerProvider.getURI(prefix);
        }
        catch (RepositoryException e) {
            throw new NamespaceException((Throwable)e);
        }
    }

    @Override
    public String getNamespaceURI(String prefix) {
        try {
            return this.ntManagerProvider.getURI(prefix);
        }
        catch (RepositoryException e) {
            this.logger.info("Could not find prefix {} in registered namespaces", (Object)prefix);
            return "";
        }
    }

    @Override
    public String getPrefix(String uri) {
        try {
            return this.ntManagerProvider.getPrefix(uri);
        }
        catch (RepositoryException e) {
            this.logger.info("Could not find uri {} in registered namespaces", (Object)uri);
            return null;
        }
    }

    @Override
    public Iterator<String> getPrefixes(String namespaceURI) {
        return Collections.singletonList(this.getPrefix(namespaceURI)).iterator();
    }

    @NotNull
    public Collection<String> getRegisteredCndSystemIds() {
        return this.registeredCndSystemIds;
    }
}

