/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.cpconverter.cli;

import java.io.File;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.Date;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.apache.sling.feature.Feature;
import org.apache.sling.feature.cpconverter.ContentPackage2FeatureModelConverter;
import org.apache.sling.feature.cpconverter.ConverterException;
import org.apache.sling.feature.cpconverter.accesscontrol.AclManager;
import org.apache.sling.feature.cpconverter.accesscontrol.DefaultAclManager;
import org.apache.sling.feature.cpconverter.artifacts.LocalMavenRepositoryArtifactsDeployer;
import org.apache.sling.feature.cpconverter.features.DefaultFeaturesManager;
import org.apache.sling.feature.cpconverter.filtering.RegexBasedResourceFilter;
import org.apache.sling.feature.cpconverter.handlers.DefaultEntryHandlersManager;
import org.apache.sling.feature.cpconverter.handlers.slinginitialcontent.BundleSlingInitialContentExtractor;
import org.apache.sling.feature.cpconverter.vltpkg.DefaultPackagesEventsEmitter;
import org.apache.sling.feature.io.json.FeatureJSONReader;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="cp2fm", description={"Apache Sling Content Package to Sling Feature converter"}, footer={"Copyright(c) 2019-2021 The Apache Software Foundation."})
public final class ContentPackage2FeatureModelConverterLauncher
implements Runnable {
    @CommandLine.Option(names={"-h", "--help"}, usageHelp=true, description={"Display the usage message."})
    private boolean helpRequested;
    @CommandLine.Option(names={"-X", "--verbose"}, description={"Produce execution debug output."})
    private boolean debug;
    @CommandLine.Option(names={"-q", "--quiet"}, description={"Log errors only."})
    private boolean quiet;
    @CommandLine.Option(names={"-v", "--version"}, description={"Display version information."})
    private boolean printVersion;
    @CommandLine.Option(names={"-s", "--strict-validation"}, description={"Flag to mark the content-package input file being strict validated."}, required=false, defaultValue="false")
    private boolean strictValidation = false;
    @CommandLine.Option(names={"-m", "--merge-configurations"}, description={"Flag to mark OSGi configurations with same PID will be merged, the tool will fail otherwise."}, required=false, defaultValue="false")
    private boolean mergeConfigurations = false;
    @CommandLine.Option(names={"-b", "--bundles-start-order"}, description={"The order to start detected bundles."}, required=false)
    private int bundlesStartOrder = 0;
    @CommandLine.Option(names={"-f", "--filtering-patterns"}, description={"Regex based pattern(s) to reject content-package archive entries."}, required=false)
    private String[] filteringPatterns;
    @CommandLine.Option(names={"-a", "--artifacts-output-directory"}, description={"The output directory where the artifacts will be deployed."}, required=true)
    private File artifactsOutputDirectory;
    @CommandLine.Option(names={"-o", "--features-output-directory"}, description={"The output directory where the Feature File will be generated."}, required=true)
    private File featureModelsOutputDirectory;
    @CommandLine.Option(names={"-i", "--artifact-id"}, description={"The optional Artifact Id the Feature File will have, once generated; it will be derived, if not specified."}, required=false)
    private String artifactIdOverride;
    @CommandLine.Option(names={"-p", "--fm-prefix"}, description={"The optional prefix of the output file"}, required=false)
    private String fmPrefix;
    @CommandLine.Option(names={"-r", "--api-region"}, description={"The API Regions assigned to the generated features"}, required=false)
    private List<String> apiRegions;
    @CommandLine.Option(names={"-e", "--exports-to-region"}, description={"Packages exported by bundles in the content packages are exported in the named region"}, required=false)
    private String exportsToRegion;
    @CommandLine.Option(names={"-D", "--define"}, description={"Define a system property"}, required=false)
    private Map<String, String> properties = new HashMap<String, String>();
    @CommandLine.Parameters(arity="1..*", paramLabel="content-packages", description={"The content-package input file(s)."})
    private File[] contentPackages;
    @CommandLine.Option(names={"-Z", "--fail-on-mixed-packages"}, description={"Fail the conversion if the resulting attached content-package is MIXED type"}, required=false)
    private boolean failOnMixedPackages = false;
    @CommandLine.Option(names={"--enforce-principal-based-supported-path"}, description={"Converts service user access control entries to principal-based setup using the given supported path."}, required=false)
    private String enforcePrincipalBasedSupportedPath = null;
    @CommandLine.Option(names={"--system-user-rel-path"}, description={"Relative path for system user as configured with Apache Jackrabbit Oak"}, required=false)
    private String systemUserRelPath = "system";
    @CommandLine.Option(names={"--enforce-servicemapping-by-principal"}, description={"Converts service user mappings with the form 'service:sub=userID' to 'service:sub=[principalname]'. Note, this may result in group membership no longer being resolved upon service login."}, required=false)
    private boolean enforceServiceMappingByPrincipal = false;
    @CommandLine.Option(names={"--entry-handler-config"}, description={"Config for entry handlers that support it (classname:<config-string>"}, required=false)
    private List<String> entryHandlerConfigs = null;
    @CommandLine.Option(names={"--remove-install-hooks"}, description={"Removes both internal and external hooks from processed packages"}, required=false)
    private boolean removeInstallHooks = false;
    @CommandLine.Option(names={"--seed-feature"}, description={"A url pointing to a feature that can be assumed to be around when the conversion result will be used"}, required=false)
    private String seedFeature = null;
    @CommandLine.Option(names={"--disable-installer-policy"}, description={"Disables enforcing that OSGi configurations are only allowed below a folder called 'config' and OSGi bundles are only allowed below a folder called 'install'. Instead both are detected below either 'install' or 'config'."}, required=false)
    private boolean disableInstallerPolicy = false;
    @CommandLine.Option(names={"--disable-package-type-recalculation"}, description={"Disables the package recalculation"}, required=false)
    private boolean disablePackageTypeRecalculation = false;
    @CommandLine.Option(names={"--content-type-package-policy"}, description={"Determines what to do with converted packages of type 'content'. Valid values: ${COMPLETION-CANDIDATES}."}, required=false, showDefaultValue=CommandLine.Help.Visibility.ALWAYS)
    private ContentPackage2FeatureModelConverter.PackagePolicy contentTypePackagePolicy = ContentPackage2FeatureModelConverter.PackagePolicy.DROP;
    @CommandLine.Option(names={"-u", "--unreferenced-artifacts-output-directory"}, description={"The output directory where unreferenced artifacts will be deployed."}, required=false)
    private File unreferencedArtifactsOutputDirectory;
    @CommandLine.Option(names={"--sling-initial-content-policy"}, description={"Determines what to do with Sling-Initial-Content found in embedded bundles. Valid values: ${COMPLETION-CANDIDATES}."}, required=false, showDefaultValue=CommandLine.Help.Visibility.ALWAYS)
    private ContentPackage2FeatureModelConverter.SlingInitialContentPolicy slingInitialContentPolicy = ContentPackage2FeatureModelConverter.SlingInitialContentPolicy.KEEP;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Formatter uptimeFormatter;
        if (this.quiet) {
            System.setProperty("org.slf4j.simpleLogger.defaultLogLevel", "error");
        } else if (this.debug) {
            System.setProperty("org.slf4j.simpleLogger.defaultLogLevel", "debug");
        } else {
            System.setProperty("org.slf4j.simpleLogger.defaultLogLevel", "info");
        }
        System.setProperty("org.slf4j.simpleLogger.showThreadName", "false");
        System.setProperty("org.slf4j.simpleLogger.levelInBrackets", "true");
        System.setProperty("org.slf4j.simpleLogger.showLogName", "false");
        String appName = this.getClass().getAnnotation(CommandLine.Command.class).description()[0];
        Logger logger = LoggerFactory.getLogger((String)appName);
        logger.debug("Using tmp directory {}", (Object)System.getProperty("java.io.tmpdir"));
        long start = System.currentTimeMillis();
        if (this.printVersion) {
            ContentPackage2FeatureModelConverterLauncher.printVersion(logger);
        }
        logger.info(appName);
        logger.info("");
        boolean exitWithError = false;
        try {
            try {
                DefaultAclManager aclManager = new DefaultAclManager(this.enforcePrincipalBasedSupportedPath, this.systemUserRelPath);
                DefaultFeaturesManager featuresManager = new DefaultFeaturesManager(this.mergeConfigurations, this.bundlesStartOrder, this.featureModelsOutputDirectory, this.artifactIdOverride, this.fmPrefix, this.properties, (AclManager)aclManager);
                featuresManager.setEnforceServiceMappingByPrincipal(this.enforceServiceMappingByPrincipal);
                if (this.seedFeature != null) {
                    InputStreamReader reader = new InputStreamReader(new URL(this.seedFeature).openStream(), "UTF-8");
                    Object object = null;
                    try {
                        Feature feature = FeatureJSONReader.read((Reader)reader, (String)this.seedFeature);
                        System.out.println(feature);
                        featuresManager.addSeed(feature);
                    }
                    catch (Throwable throwable) {
                        object = throwable;
                        throw throwable;
                    }
                    finally {
                        if (reader != null) {
                            if (object != null) {
                                try {
                                    ((Reader)reader).close();
                                }
                                catch (Throwable throwable) {
                                    ((Throwable)object).addSuppressed(throwable);
                                }
                            } else {
                                ((Reader)reader).close();
                            }
                        }
                    }
                }
                if (this.apiRegions != null) {
                    featuresManager.setAPIRegions(this.apiRegions);
                }
                if (this.exportsToRegion != null) {
                    featuresManager.setExportToAPIRegion(this.exportsToRegion);
                }
                HashMap<String, String> entryHandlerConfigsMap = new HashMap<String, String>();
                if (this.entryHandlerConfigs != null) {
                    for (String string : this.entryHandlerConfigs) {
                        int idx = string.indexOf(58);
                        if (idx == -1) continue;
                        entryHandlerConfigsMap.put(string.substring(0, idx), string.substring(idx + 1));
                    }
                }
                Throwable throwable = null;
                try (ContentPackage2FeatureModelConverter converter = new ContentPackage2FeatureModelConverter(this.strictValidation, this.slingInitialContentPolicy, this.disablePackageTypeRecalculation);){
                    BundleSlingInitialContentExtractor bundleSlingInitialContentExtractor = new BundleSlingInitialContentExtractor();
                    converter.setFeaturesManager(featuresManager).setBundlesDeployer(new LocalMavenRepositoryArtifactsDeployer(this.artifactsOutputDirectory)).setBundleSlingInitialContentExtractor(bundleSlingInitialContentExtractor).setEntryHandlersManager(new DefaultEntryHandlersManager(entryHandlerConfigsMap, !this.disableInstallerPolicy, this.slingInitialContentPolicy, bundleSlingInitialContentExtractor, this.systemUserRelPath)).setAclManager(aclManager).setEmitter(DefaultPackagesEventsEmitter.open(this.featureModelsOutputDirectory)).setFailOnMixedPackages(this.failOnMixedPackages).setContentTypePackagePolicy(this.contentTypePackagePolicy);
                    if (this.unreferencedArtifactsOutputDirectory != null) {
                        converter.setUnreferencedArtifactsDeployer(new LocalMavenRepositoryArtifactsDeployer(this.unreferencedArtifactsOutputDirectory));
                    } else if (this.contentTypePackagePolicy == ContentPackage2FeatureModelConverter.PackagePolicy.PUT_IN_DEDICATED_FOLDER) {
                        throw new IllegalStateException("Argument '--content-type-package-policy PUT_IN_DEDICATED_FOLDER' requires argument '--unreferenced-artifacts-output-directory' as well!");
                    }
                    if (this.filteringPatterns != null && this.filteringPatterns.length > 0) {
                        RegexBasedResourceFilter filter = new RegexBasedResourceFilter();
                        for (String filteringPattern : this.filteringPatterns) {
                            filter.addFilteringPattern(filteringPattern);
                        }
                        converter.setResourceFilter(filter);
                    }
                    converter.convert(this.contentPackages);
                }
                catch (Throwable bundleSlingInitialContentExtractor) {
                    Throwable throwable2 = bundleSlingInitialContentExtractor;
                    throw bundleSlingInitialContentExtractor;
                }
                logger.info("+-----------------------------------------------------+");
                logger.info("{} SUCCESS", (Object)appName);
            }
            catch (ConverterException ce) {
                logger.info("+-----------------------------------------------------+");
                logger.info("{} FAILURE", (Object)appName);
                logger.info("+-----------------------------------------------------+");
                logger.error("Unable to convert content-package {}: {}", (Object)this.contentPackages, (Object)ce.getMessage());
                logger.info("+-----------------------------------------------------+");
                exitWithError = true;
            }
            catch (Throwable t) {
                logger.info("+-----------------------------------------------------+");
                logger.info("{} FAILURE", (Object)appName);
                logger.info("+-----------------------------------------------------+");
                if (this.debug) {
                    logger.error("Unable to convert content-package {}:", (Object)this.contentPackages, (Object)t);
                } else {
                    logger.error("Unable to convert content-package {}: {}", (Object)this.contentPackages, (Object)t.getMessage());
                }
                logger.info("+-----------------------------------------------------+");
                exitWithError = true;
            }
            uptimeFormatter = new Formatter();
            uptimeFormatter.format("Total time:", new Object[0]);
        }
        catch (Throwable throwable) {
            Formatter uptimeFormatter2 = new Formatter();
            uptimeFormatter2.format("Total time:", new Object[0]);
            long uptime = System.currentTimeMillis() - start;
            if (uptime < 1000L) {
                uptimeFormatter2.format(" %s millisecond%s", uptime, uptime > 1L ? "s" : "");
            } else {
                long minutes;
                long uptimeInSeconds = uptime / 1000L;
                long hours = uptimeInSeconds / 3600L;
                if (hours > 0L) {
                    uptimeFormatter2.format(" %s hour%s", hours, hours > 1L ? "s" : "");
                }
                if ((minutes = (uptimeInSeconds -= hours * 3600L) / 60L) > 0L) {
                    uptimeFormatter2.format(" %s minute%s", minutes, minutes > 1L ? "s" : "");
                }
                if ((uptimeInSeconds -= minutes * 60L) > 0L) {
                    uptimeFormatter2.format(" %s second%s", uptimeInSeconds, uptimeInSeconds > 1L ? "s" : "");
                }
            }
            logger.info(uptimeFormatter2.toString());
            uptimeFormatter2.close();
            logger.info("Finished at: {}", (Object)new Date());
            Runtime runtime = Runtime.getRuntime();
            int megaUnit = 0x100000;
            logger.info("Final Memory: {}M/{}M", (Object)((runtime.totalMemory() - runtime.freeMemory()) / 0x100000L), (Object)(runtime.totalMemory() / 0x100000L));
            logger.info("+-----------------------------------------------------+");
            throw throwable;
        }
        long uptime = System.currentTimeMillis() - start;
        if (uptime < 1000L) {
            uptimeFormatter.format(" %s millisecond%s", uptime, uptime > 1L ? "s" : "");
        } else {
            long minutes;
            long uptimeInSeconds = uptime / 1000L;
            long hours = uptimeInSeconds / 3600L;
            if (hours > 0L) {
                uptimeFormatter.format(" %s hour%s", hours, hours > 1L ? "s" : "");
            }
            if ((minutes = (uptimeInSeconds -= hours * 3600L) / 60L) > 0L) {
                uptimeFormatter.format(" %s minute%s", minutes, minutes > 1L ? "s" : "");
            }
            if ((uptimeInSeconds -= minutes * 60L) > 0L) {
                uptimeFormatter.format(" %s second%s", uptimeInSeconds, uptimeInSeconds > 1L ? "s" : "");
            }
        }
        logger.info(uptimeFormatter.toString());
        uptimeFormatter.close();
        logger.info("Finished at: {}", (Object)new Date());
        Runtime runtime = Runtime.getRuntime();
        int n = 0x100000;
        logger.info("Final Memory: {}M/{}M", (Object)((runtime.totalMemory() - runtime.freeMemory()) / 0x100000L), (Object)(runtime.totalMemory() / 0x100000L));
        logger.info("+-----------------------------------------------------+");
        if (exitWithError) {
            System.exit(1);
        }
    }

    private static void printVersion(@NotNull Logger logger) {
        logger.info("{} v{} (built on {})", new Object[]{System.getProperty("project.artifactId"), System.getProperty("project.version"), System.getProperty("build.timestamp")});
        logger.info("Java version: {}, vendor: {}", (Object)System.getProperty("java.version"), (Object)System.getProperty("java.vendor"));
        logger.info("Java home: {}", (Object)System.getProperty("java.home"));
        logger.info("Default locale: {}_{}, platform encoding: {}", new Object[]{System.getProperty("user.language"), System.getProperty("user.country"), System.getProperty("sun.jnu.encoding")});
        logger.info("Default Time Zone: {}", (Object)TimeZone.getDefault().getDisplayName());
        logger.info("OS name: \"{}\", version: \"{}\", arch: \"{}\", family: \"{}\"", new Object[]{System.getProperty("os.name"), System.getProperty("os.version"), System.getProperty("os.arch"), ContentPackage2FeatureModelConverterLauncher.getOsFamily()});
        logger.info("+-----------------------------------------------------+");
    }

    @NotNull
    private static final String getOsFamily() {
        String osName = System.getProperty("os.name").toLowerCase();
        String pathSep = System.getProperty("path.separator");
        if (osName.indexOf("windows") != -1) {
            return "windows";
        }
        if (osName.indexOf("os/2") != -1) {
            return "os/2";
        }
        if (osName.indexOf("z/os") != -1 || osName.indexOf("os/390") != -1) {
            return "z/os";
        }
        if (osName.indexOf("os/400") != -1) {
            return "os/400";
        }
        if (pathSep.equals(";")) {
            return "dos";
        }
        if (osName.indexOf("mac") != -1) {
            if (osName.endsWith("x")) {
                return "mac";
            }
            return "unix";
        }
        if (osName.indexOf("nonstop_kernel") != -1) {
            return "tandem";
        }
        if (osName.indexOf("openvms") != -1) {
            return "openvms";
        }
        if (pathSep.equals(":")) {
            return "unix";
        }
        return "undefined";
    }

    public static void main(@NotNull String[] args) {
        CommandLine.run((Runnable)new ContentPackage2FeatureModelConverterLauncher(), (String[])args);
    }
}

