/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.validation.spi.impl.nodetype;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.JarURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.LinkedList;
import java.util.List;
import java.util.jar.Manifest;
import javax.jcr.RepositoryException;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.commons.cnd.ParseException;
import org.apache.jackrabbit.jcr2spi.nodetype.EffectiveNodeType;
import org.apache.jackrabbit.vault.validation.spi.ValidationContext;
import org.apache.jackrabbit.vault.validation.spi.ValidationMessageSeverity;
import org.apache.jackrabbit.vault.validation.spi.Validator;
import org.apache.jackrabbit.vault.validation.spi.ValidatorFactory;
import org.apache.jackrabbit.vault.validation.spi.ValidatorSettings;
import org.apache.jackrabbit.vault.validation.spi.impl.nodetype.NodeTypeManagerProvider;
import org.apache.jackrabbit.vault.validation.spi.impl.nodetype.NodeTypeValidator;
import org.apache.jackrabbit.vault.validation.spi.util.classloaderurl.URLFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeTypeValidatorFactory
implements ValidatorFactory {
    public static final String OPTION_CNDS = "cnds";
    public static final String OPTION_DEFAULT_NODE_TYPES = "defaultNodeType";
    public static final String OPTION_SEVERITY_FOR_UNKNOWN_NODETYPES = "severityForUnknownNodetypes";
    @NotNull
    static final String DEFAULT_DEFAULT_NODE_TYPE = "nt:folder";
    @NotNull
    static final ValidationMessageSeverity DEFAULT_SEVERITY_FOR_UNKNOWN_NODETYPE = ValidationMessageSeverity.WARN;
    private static final Logger LOGGER = LoggerFactory.getLogger(NodeTypeValidatorFactory.class);

    @Override
    @Nullable
    public Validator createValidator(@NotNull ValidationContext context, @NotNull ValidatorSettings settings) {
        ValidationMessageSeverity severityForUnknownNodetypes;
        String cndUrls = settings.getOptions().get(OPTION_CNDS);
        if (StringUtils.isBlank((CharSequence)cndUrls)) {
            cndUrls = this.getClass().getClassLoader().getResource("default-nodetypes.cnd").toString();
            LOGGER.warn("Using default nodetypes, consider specifying the nodetypes from the distribution you use!");
        }
        String defaultNodeType = settings.getOptions().containsKey(OPTION_DEFAULT_NODE_TYPES) ? settings.getOptions().get(OPTION_DEFAULT_NODE_TYPES) : DEFAULT_DEFAULT_NODE_TYPE;
        if (settings.getOptions().containsKey(OPTION_SEVERITY_FOR_UNKNOWN_NODETYPES)) {
            String optionValue = settings.getOptions().get(OPTION_SEVERITY_FOR_UNKNOWN_NODETYPES);
            severityForUnknownNodetypes = ValidationMessageSeverity.valueOf(optionValue.toUpperCase());
        } else {
            severityForUnknownNodetypes = DEFAULT_SEVERITY_FOR_UNKNOWN_NODETYPE;
        }
        try {
            NodeTypeManagerProvider ntManagerProvider = null;
            ntManagerProvider = new NodeTypeManagerProvider();
            for (String cndUrl : NodeTypeValidatorFactory.resolveJarUrls(cndUrls.split(","))) {
                try {
                    InputStreamReader reader = new InputStreamReader(URLFactory.createURL(cndUrl).openStream(), StandardCharsets.US_ASCII);
                    Throwable throwable = null;
                    try {
                        LOGGER.info("Register node types from {}", (Object)cndUrl);
                        ntManagerProvider.registerNodeTypes(reader);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (reader == null) continue;
                        if (throwable != null) {
                            try {
                                ((Reader)reader).close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        ((Reader)reader).close();
                    }
                }
                catch (IOException | RepositoryException | ParseException e) {
                    throw new IllegalArgumentException("Error loading node types from CND at " + cndUrl, e);
                }
            }
            EffectiveNodeType defaultEffectiveNodeType = ntManagerProvider.getEffectiveNodeTypeProvider().getEffectiveNodeType(ntManagerProvider.getNameResolver().getQName(defaultNodeType));
            return new NodeTypeValidator(context.getFilter(), ntManagerProvider, defaultEffectiveNodeType, settings.getDefaultSeverity(), severityForUnknownNodetypes);
        }
        catch (IOException | RepositoryException | ParseException e) {
            throw new IllegalArgumentException("Error loading default node type " + defaultNodeType, e);
        }
    }

    static List<String> resolveJarUrls(String ... urls) {
        LinkedList<String> resolvedUrls = new LinkedList<String>();
        for (String url : urls) {
            if (url.endsWith(".jar")) {
                try {
                    URL jarUrl = URLFactory.createURL("jar:" + url + "!/");
                    JarURLConnection jarConnection = (JarURLConnection)jarUrl.openConnection();
                    Manifest manifest = jarConnection.getManifest();
                    String slingNodetypes = manifest.getMainAttributes().getValue("Sling-Nodetypes");
                    if (slingNodetypes == null) {
                        LOGGER.warn("No 'Sling-Nodetypes' header found in manifest of '{}'", (Object)jarUrl);
                        continue;
                    }
                    for (String nodetype : slingNodetypes.split(",")) {
                        resolvedUrls.add(jarUrl.toString() + nodetype);
                    }
                    continue;
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("Could not read from JAR " + url, e);
                }
            }
            resolvedUrls.add(url);
        }
        return resolvedUrls;
    }

    @Override
    public boolean shouldValidateSubpackages() {
        return false;
    }

    @Override
    @NotNull
    public String getId() {
        return "jackrabbit-nodetypes";
    }

    @Override
    public int getServiceRanking() {
        return 0;
    }
}

