/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.packaging.impl;

import java.util.LinkedList;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.apache.jackrabbit.vault.fs.api.FilterSet;
import org.apache.jackrabbit.vault.fs.api.ImportMode;
import org.apache.jackrabbit.vault.fs.api.PathFilterSet;
import org.apache.jackrabbit.vault.fs.api.WorkspaceFilter;
import org.apache.jackrabbit.vault.fs.config.ConfigurationException;
import org.apache.jackrabbit.vault.fs.config.DefaultWorkspaceFilter;
import org.apache.jackrabbit.vault.fs.filter.DefaultPathFilter;

public class JcrWorkspaceFilter {
    public static DefaultWorkspaceFilter loadFilter(Node defNode) throws RepositoryException {
        DefaultWorkspaceFilter wsp = new DefaultWorkspaceFilter();
        if (defNode.hasNode("filter")) {
            defNode = defNode.getNode("filter");
        }
        NodeIterator filters = defNode.getNodes();
        while (filters.hasNext()) {
            Node filter = filters.nextNode();
            String root = filter.hasProperty("root") ? filter.getProperty("root").getString() : "";
            if (root.length() == 0) continue;
            String mode = filter.hasProperty("mode") ? filter.getProperty("mode").getString() : "";
            PathFilterSet set = new PathFilterSet(root);
            if (mode.length() > 0) {
                set.setImportMode(ImportMode.valueOf(mode.toUpperCase()));
            }
            if (filter.hasProperty("rules")) {
                Value[] values;
                Value[] valueArray;
                Property p = filter.getProperty("rules");
                if (p.getDefinition().isMultiple()) {
                    valueArray = p.getValues();
                } else {
                    Value[] valueArray2 = new Value[1];
                    valueArray = valueArray2;
                    valueArray2[0] = p.getValue();
                }
                for (Value value : values = valueArray) {
                    DefaultPathFilter pf;
                    String rule = value.getString();
                    int idx = rule.indexOf(58);
                    String type = idx > 0 ? rule.substring(0, idx) : "include";
                    String patt = idx > 0 ? rule.substring(idx + 1) : "";
                    try {
                        pf = new DefaultPathFilter(patt);
                    }
                    catch (ConfigurationException e) {
                        throw new RepositoryException("Can not load filter from node " + defNode.getPath(), (Throwable)e);
                    }
                    if ("include".equals(type)) {
                        set.addInclude(pf);
                        continue;
                    }
                    set.addExclude(pf);
                }
            } else {
                NodeIterator rules = filter.getNodes();
                while (rules.hasNext()) {
                    DefaultPathFilter pf;
                    Node rule = rules.nextNode();
                    String type = rule.getProperty("type").getString();
                    String pattern = rule.getProperty("pattern").getString();
                    try {
                        pf = new DefaultPathFilter(pattern);
                    }
                    catch (ConfigurationException e) {
                        throw new RepositoryException("Can not load filter from node " + defNode.getPath(), (Throwable)e);
                    }
                    if ("include".equals(type)) {
                        set.addInclude(pf);
                        continue;
                    }
                    set.addExclude(pf);
                }
            }
            wsp.add(set);
        }
        return wsp;
    }

    public static void saveLegacyFilter(WorkspaceFilter filter, Node defNode, boolean save) throws RepositoryException {
        NodeIterator iter = defNode.getNodes();
        while (iter.hasNext()) {
            iter.nextNode().remove();
        }
        int nr = 0;
        for (PathFilterSet set : filter.getFilterSets()) {
            Node setNode = defNode.addNode("f" + nr);
            setNode.setProperty("root", set.getRoot());
            int eNr = 0;
            for (FilterSet.Entry e : set.getEntries()) {
                if (!(e.getFilter() instanceof DefaultPathFilter)) {
                    throw new IllegalArgumentException("Can only handle default path filters.");
                }
                Node eNode = setNode.addNode("f" + eNr);
                eNode.setProperty("type", e.isInclude() ? "include" : "exclude");
                eNode.setProperty("pattern", ((DefaultPathFilter)e.getFilter()).getPattern());
                ++eNr;
            }
            ++nr;
        }
        if (save) {
            defNode.getSession().save();
        }
    }

    public static void saveFilter(WorkspaceFilter filter, Node defNode, boolean save) throws RepositoryException {
        if (defNode.hasNode("filter")) {
            defNode.getNode("filter").remove();
        }
        Node filterNode = defNode.addNode("filter");
        int nr = 0;
        for (PathFilterSet set : filter.getFilterSets()) {
            Node setNode = filterNode.addNode("f" + nr);
            setNode.setProperty("root", set.getRoot());
            setNode.setProperty("mode", set.getImportMode().name().toLowerCase());
            LinkedList<String> rules = new LinkedList<String>();
            for (FilterSet.Entry e : set.getEntries()) {
                if (!(e.getFilter() instanceof DefaultPathFilter)) {
                    throw new IllegalArgumentException("Can only handle default path filters.");
                }
                String type = e.isInclude() ? "include" : "exclude";
                String patt = ((DefaultPathFilter)e.getFilter()).getPattern();
                rules.add(type + ":" + patt);
            }
            setNode.setProperty("rules", rules.toArray(new String[rules.size()]));
            ++nr;
        }
        if (save) {
            defNode.getSession().save();
        }
    }
}

