/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.fs;

import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.jcr.RepositoryException;
import org.apache.commons.io.output.DeferredFileOutputStream;
import org.apache.jackrabbit.vault.fs.api.AccessType;
import org.apache.jackrabbit.vault.fs.api.Artifact;
import org.apache.jackrabbit.vault.fs.api.ArtifactType;
import org.apache.jackrabbit.vault.fs.api.ExportArtifact;
import org.apache.jackrabbit.vault.fs.api.SerializationType;
import org.apache.jackrabbit.vault.fs.api.VaultInputSource;
import org.apache.jackrabbit.vault.fs.impl.AbstractArtifact;
import org.apache.jackrabbit.vault.fs.io.Serializer;
import org.apache.jackrabbit.vault.util.TempFileInputStream;

public class SerializerArtifact
extends AbstractArtifact
implements ExportArtifact {
    private final Serializer serializer;
    private final long lastModified;

    public SerializerArtifact(Artifact parent, String name, String ext, ArtifactType type, Serializer serializer, long lastModified) {
        super(parent, name, ext, type);
        if (type == ArtifactType.DIRECTORY) {
            throw new IllegalArgumentException("Illegal type 'TYPE_DIRECTORY' for a serialized artifact.");
        }
        this.serializer = serializer;
        this.lastModified = lastModified;
    }

    @Override
    public AccessType getPreferredAccess() {
        return AccessType.SPOOL;
    }

    @Override
    public SerializationType getSerializationType() {
        return this.serializer.getType();
    }

    @Override
    public void spool(OutputStream out) throws IOException, RepositoryException {
        this.serializer.writeContent(out);
    }

    @Override
    public InputStream getInputStream() throws IOException, RepositoryException {
        try (DeferredFileOutputStream out = new DeferredFileOutputStream(8192, "vlttmp", ".tmp", null);){
            this.spool((OutputStream)out);
            if (out.isInMemory()) {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(out.getData());
                return byteArrayInputStream;
            }
            TempFileInputStream tempFileInputStream = new TempFileInputStream(out.getFile());
            return tempFileInputStream;
        }
    }

    @Override
    public VaultInputSource getInputSource() throws IOException, RepositoryException {
        try (final DeferredFileOutputStream out = new DeferredFileOutputStream(8192, "vlttmp", ".tmp", null);){
            this.spool((OutputStream)out);
            VaultInputSource vaultInputSource = new VaultInputSource(){
                private InputStream in = null;
                private long size = -1L;

                @Override
                public String getSystemId() {
                    return SerializerArtifact.this.getRelativePath();
                }

                @Override
                public InputStream getByteStream() {
                    if (this.in == null) {
                        if (out.isInMemory()) {
                            this.in = new ByteArrayInputStream(out.getData());
                            this.size = out.getData().length;
                        } else {
                            try {
                                this.in = new TempFileInputStream(out.getFile());
                            }
                            catch (FileNotFoundException e) {
                                throw new IllegalStateException("Could not find temp file", e);
                            }
                            this.size = out.getFile().length();
                        }
                    }
                    return this.in;
                }

                @Override
                public long getContentLength() {
                    return this.size;
                }

                @Override
                public long getLastModified() {
                    return SerializerArtifact.this.lastModified;
                }
            };
            return vaultInputSource;
        }
    }

    @Override
    public String getContentType() {
        String ct = super.getContentType();
        if (ct == null) {
            ct = this.serializer.getType().getContentType();
        }
        return ct;
    }

    @Override
    public long getContentLength() {
        return -1L;
    }

    @Override
    public long getLastModified() {
        return this.lastModified;
    }
}

