/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.packaging.impl;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.Properties;
import java.util.TreeMap;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.jackrabbit.util.Text;
import org.apache.jackrabbit.vault.fs.api.VaultInputSource;
import org.apache.jackrabbit.vault.fs.io.Archive;
import org.apache.jackrabbit.vault.packaging.InstallContext;
import org.apache.jackrabbit.vault.packaging.InstallHook;
import org.apache.jackrabbit.vault.packaging.InstallHookProcessor;
import org.apache.jackrabbit.vault.packaging.PackageException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstallHookProcessorImpl
implements InstallHookProcessor {
    private static final Logger log = LoggerFactory.getLogger(InstallHookProcessorImpl.class);
    private final TreeMap<String, Hook> hooks = new TreeMap();

    @Override
    public void registerHooks(Archive archive, ClassLoader classLoader) throws PackageException {
        try {
            Archive.Entry root = archive.getRoot();
            root = root.getChild("META-INF");
            if (root == null) {
                log.warn("Archive {} does not have a {} directory.", (Object)archive, (Object)"META-INF");
                return;
            }
            if ((root = root.getChild("vault")) == null) {
                log.warn("Archive {} does not have a {} directory.", (Object)archive, (Object)"vault");
                return;
            }
            if ((root = root.getChild("hooks")) == null) {
                log.debug("Archive {} does not have a {} directory.", (Object)archive, (Object)"hooks");
            } else {
                for (Archive.Entry entry : root.getChildren()) {
                    if (!entry.getName().endsWith(".jar")) continue;
                    this.registerHook(archive.getInputSource(entry), classLoader);
                }
            }
            Properties props = archive.getMetaInf().getProperties();
            if (props != null) {
                Enumeration<?> enumeration = props.propertyNames();
                while (enumeration.hasMoreElements()) {
                    String name = enumeration.nextElement().toString();
                    if (!name.startsWith("installhook.")) continue;
                    String[] segs = Text.explode((String)name.substring("installhook.".length()), (int)46);
                    if (segs.length == 0 || segs.length > 2 || !"class".equals(segs[1])) {
                        throw new PackageException("Invalid installhook property: " + name);
                    }
                    Hook hook = new Hook(segs[0], props.getProperty(name), classLoader);
                    this.initHook(hook);
                }
            }
        }
        catch (IOException e) {
            throw new PackageException("I/O Error while registering hooks", e);
        }
    }

    @Override
    public void registerHook(VaultInputSource input, ClassLoader classLoader) throws IOException, PackageException {
        File jarFile = File.createTempFile("vaulthook", ".jar");
        Hook hook = new Hook(input.getSystemId(), jarFile, classLoader);
        try (FileOutputStream out = FileUtils.openOutputStream((File)jarFile);
             InputStream in = input.getByteStream();){
            IOUtils.copy((InputStream)in, (OutputStream)out);
        }
        catch (IOException e) {
            hook.destroy();
            throw e;
        }
        this.initHook(hook);
    }

    private void initHook(Hook hook) throws IOException, PackageException {
        try {
            hook.init();
        }
        catch (IOException e) {
            log.error("Error while initializing hook: {}", (Object)e.toString());
            hook.destroy();
            throw e;
        }
        catch (PackageException e) {
            log.error("Error while initializing hook: {}", (Object)e.toString());
            hook.destroy();
            throw e;
        }
        this.hooks.put(hook.name, hook);
        log.info("Hook {} registered.", (Object)hook.name);
    }

    @Override
    public boolean hasHooks() {
        return !this.hooks.isEmpty();
    }

    @Override
    public boolean execute(InstallContext context) {
        for (Hook hook : this.hooks.values()) {
            try {
                hook.getHook().execute(context);
            }
            catch (Throwable e) {
                if (context.getPhase() == InstallContext.Phase.PREPARE || context.getPhase() == InstallContext.Phase.INSTALLED) {
                    log.warn("Hook " + hook.name + " threw exception. {} aborted.", (Object)context.getPhase(), (Object)e);
                    return false;
                }
                log.warn("Hook " + hook.name + " threw exception. Ignored", e);
            }
            if (context.getPhase() != InstallContext.Phase.END) continue;
            hook.destroy();
        }
        return true;
    }

    private class Hook {
        private final String name;
        private final File jarFile;
        private ClassLoader parentClassLoader;
        private InstallHook hook;
        private String mainClassName;

        private Hook(String name, String mainClassName, ClassLoader parentClassLoader) {
            this.name = name;
            this.mainClassName = mainClassName;
            this.parentClassLoader = parentClassLoader;
            this.jarFile = null;
        }

        private Hook(String name, File jarFile, ClassLoader parentClassLoader) {
            this.name = name;
            this.jarFile = jarFile;
            this.parentClassLoader = parentClassLoader;
        }

        private void destroy() {
            this.parentClassLoader = null;
            this.hook = null;
            if (this.jarFile != null) {
                FileUtils.deleteQuietly((File)this.jarFile);
            }
        }

        private void init() throws IOException, PackageException {
            block19: {
                try {
                    if (this.jarFile != null) {
                        try (JarFile jar = new JarFile(this.jarFile);){
                            Manifest mf = jar.getManifest();
                            if (mf == null) {
                                throw new PackageException("hook jar file does not have a manifest: " + this.name);
                            }
                            this.mainClassName = mf.getMainAttributes().getValue("Main-Class");
                            if (this.mainClassName == null) {
                                throw new PackageException("hook manifest file does not have a Main-Class entry: " + this.name);
                            }
                        }
                        if (this.parentClassLoader == null) {
                            try {
                                this.loadMainClass(URLClassLoader.newInstance(new URL[]{this.jarFile.toURI().toURL()}, this.getClass().getClassLoader()));
                            }
                            catch (ClassNotFoundException cnfe) {
                                this.loadMainClass(URLClassLoader.newInstance(new URL[]{this.jarFile.toURI().toURL()}, Thread.currentThread().getContextClassLoader()));
                            }
                        } else {
                            this.loadMainClass(URLClassLoader.newInstance(new URL[]{this.jarFile.toURI().toURL()}, this.parentClassLoader));
                        }
                        break block19;
                    }
                    if (this.parentClassLoader == null) {
                        try {
                            this.loadMainClass(this.getClass().getClassLoader());
                        }
                        catch (ClassNotFoundException cnfe) {
                            this.loadMainClass(Thread.currentThread().getContextClassLoader());
                        }
                    } else {
                        this.loadMainClass(this.parentClassLoader);
                    }
                }
                catch (ClassNotFoundException cnfe) {
                    throw new PackageException("hook's main class " + this.mainClassName + " not found: " + this.name, cnfe);
                }
            }
        }

        private void loadMainClass(ClassLoader classLoader) throws PackageException, ClassNotFoundException {
            log.info("Loading Hook {}: Main-Class = {}", (Object)this.name, (Object)this.mainClassName);
            Class<?> clazz = classLoader.loadClass(this.mainClassName);
            if (!InstallHook.class.isAssignableFrom(clazz)) {
                throw new PackageException("hook's main class " + this.mainClassName + " does not implement the InstallHook interface: " + this.name);
            }
            try {
                this.hook = (InstallHook)clazz.newInstance();
            }
            catch (Exception e) {
                throw new PackageException("hook's main class " + this.mainClassName + " could not be instantiated.", e);
            }
        }

        public InstallHook getHook() {
            return this.hook;
        }
    }
}

