/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.fs.impl;

import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.jcr.Binary;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.apache.jackrabbit.api.ReferenceBinary;
import org.apache.jackrabbit.util.Text;
import org.apache.jackrabbit.vault.fs.api.Aggregate;
import org.apache.jackrabbit.vault.fs.api.Aggregator;
import org.apache.jackrabbit.vault.fs.api.Artifact;
import org.apache.jackrabbit.vault.fs.api.ArtifactSet;
import org.apache.jackrabbit.vault.fs.api.ArtifactType;
import org.apache.jackrabbit.vault.fs.api.DumpContext;
import org.apache.jackrabbit.vault.fs.api.ImportInfo;
import org.apache.jackrabbit.vault.fs.api.PathFilterSet;
import org.apache.jackrabbit.vault.fs.api.RepositoryAddress;
import org.apache.jackrabbit.vault.fs.api.WorkspaceFilter;
import org.apache.jackrabbit.vault.fs.impl.AggregateBuilder;
import org.apache.jackrabbit.vault.fs.impl.AggregateManagerImpl;
import org.apache.jackrabbit.vault.fs.impl.ArtifactSetImpl;
import org.apache.jackrabbit.vault.fs.impl.io.AggregateWalkListener;
import org.apache.jackrabbit.vault.util.NodeNameComparator;
import org.apache.jackrabbit.vault.util.PathUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AggregateImpl
implements Aggregate {
    private static final char STATE_INITIAL = 'i';
    private static final char STATE_PREPARED = 'p';
    private static final char STATE_COLLECTED = 'c';
    protected static final Logger log = LoggerFactory.getLogger(AggregateImpl.class);
    private final AggregateImpl parent;
    private final String path;
    private String relPath;
    private final Aggregator aggregator;
    private final AggregateManagerImpl mgr;
    private final boolean useBinaryReferences;
    private ArtifactSetImpl artifacts;
    private Set<String> includes;
    private Collection<Property> binaries;
    private List<AggregateImpl> leaves;
    private String[] namespacePrefixes;
    private char state = (char)105;
    private WeakReference<Node> nodeRef;
    private boolean filterArtifacts;

    protected AggregateImpl(AggregateManagerImpl mgr, String path, Aggregator aggregator) throws RepositoryException {
        log.trace("Create Root Aggregate {}", (Object)path);
        this.mgr = mgr;
        this.parent = null;
        this.path = "/".equals(path) ? "" : path;
        this.aggregator = aggregator;
        this.useBinaryReferences = "true".equals(mgr.getConfig().getProperty("useBinaryReferences"));
    }

    protected AggregateImpl(AggregateImpl parent, String path, Aggregator aggregator) throws RepositoryException {
        log.trace("Create Aggregate {}", (Object)path);
        this.mgr = parent.mgr;
        this.parent = parent;
        this.path = path;
        this.aggregator = aggregator;
        this.useBinaryReferences = "true".equals(this.mgr.getConfig().getProperty("useBinaryReferences"));
        this.mgr.onAggregateCreated();
        if (aggregator.hasFullCoverage()) {
            this.state = (char)99;
            this.mgr.onAggregateCollected();
        }
    }

    @Override
    public Node getNode() throws RepositoryException {
        Node node;
        if (this.path.length() == 0) {
            return this.mgr.getSession().getRootNode();
        }
        Node node2 = node = this.nodeRef == null ? null : (Node)this.nodeRef.get();
        if (node == null) {
            node = this.mgr.getSession().getNode(this.path);
            this.nodeRef = new WeakReference<Node>(node);
        }
        return node;
    }

    @Override
    public boolean hasNode() throws RepositoryException {
        return this.nodeRef != null && this.nodeRef.get() != null || this.path.length() == 0 || this.mgr.getSession().nodeExists(this.path);
    }

    public void invalidate() {
        log.trace("invalidating aggregate {}", (Object)this.getPath());
        this.artifacts = null;
        this.includes = null;
        this.binaries = null;
        this.leaves = null;
        this.namespacePrefixes = null;
        this.nodeRef = null;
        this.relPath = null;
        this.state = (char)105;
    }

    @Override
    public Aggregate getParent() {
        return this.parent;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public RepositoryAddress getRepositoryAddress() throws RepositoryException {
        return this.mgr.getMountpoint().resolve(this.getPath());
    }

    @Override
    public boolean allowsChildren() {
        return this.aggregator == null || !this.aggregator.hasFullCoverage();
    }

    @Override
    public String getRelPath() {
        if (this.relPath == null) {
            this.relPath = this.parent == null ? this.path.substring(this.path.lastIndexOf(47) + 1) : this.path.substring(this.parent.getPath().length() + 1);
        }
        return this.relPath;
    }

    @Override
    public String getName() {
        return Text.getName((String)this.getRelPath());
    }

    @Override
    public List<? extends Aggregate> getLeaves() throws RepositoryException {
        this.load();
        return this.leaves;
    }

    @Override
    public Aggregate getAggregate(String relPath) throws RepositoryException {
        String[] pathElems = PathUtil.makePath((String[])null, relPath);
        if (pathElems == null) {
            return this;
        }
        return this.getAggregate(pathElems, 0);
    }

    private Aggregate getAggregate(String[] pathElems, int pos) throws RepositoryException {
        if (pos < pathElems.length) {
            String elem = pathElems[pos];
            if ("..".equals(elem)) {
                return this.parent == null ? null : this.parent.getAggregate(pathElems, pos + 1);
            }
            this.load();
            if (this.leaves != null && !this.leaves.isEmpty()) {
                for (AggregateImpl a : this.leaves) {
                    int i;
                    String[] le = Text.explode((String)a.getRelPath(), (int)47);
                    for (i = 0; i < le.length && i + pos < pathElems.length && le[i].equals(pathElems[i + pos]); ++i) {
                    }
                    if (i != le.length) continue;
                    return a.getAggregate(pathElems, i + pos);
                }
            }
            return null;
        }
        return this;
    }

    @Override
    public ArtifactSet getArtifacts() throws RepositoryException {
        if (this.artifacts == null) {
            this.assertAttached();
            this.load();
            this.artifacts = (ArtifactSetImpl)this.aggregator.createArtifacts(this);
            if (this.filterArtifacts) {
                ArtifactSetImpl na = new ArtifactSetImpl();
                na.addAll(this.artifacts);
                for (Artifact a : na.values()) {
                    if (a.getType() == ArtifactType.DIRECTORY || ".content.xml".equals(Text.getName((String)a.getPlatformPath()))) continue;
                    this.artifacts.remove(a);
                }
            }
        }
        return this.artifacts;
    }

    public AggregateBuilder getBuilder() throws RepositoryException {
        this.assertAttached();
        return new AggregateBuilder(this, this.getArtifacts());
    }

    public AggregateBuilder create(String reposName) throws RepositoryException {
        this.assertAttached();
        if (!this.allowsChildren()) {
            throw new RepositoryException("Unable to create artifact node below a non-folder.");
        }
        return new AggregateBuilder(this, reposName);
    }

    public ImportInfo remove(boolean recursive) throws RepositoryException {
        this.assertAttached();
        Node node = this.getNode();
        ImportInfo info = this.aggregator.remove(node, recursive, true);
        if (this.parent != null) {
            this.parent.invalidate();
        }
        return info;
    }

    @Override
    public AggregateManagerImpl getManager() {
        return this.mgr;
    }

    ImportInfo writeArtifacts(ArtifactSetImpl artifacts, String reposName) throws RepositoryException, IOException {
        try {
            return this.mgr.writeAggregate(this, reposName, artifacts);
        }
        catch (RepositoryException e) {
            log.error("Error while writing artifacts of {}: {}", (Object)this.getPath(), (Object)e.toString());
            throw e;
        }
        catch (IOException e) {
            log.error("Error while writing artifacts of {}: {}", (Object)this.getPath(), (Object)e.toString());
            throw e;
        }
    }

    private void assertAttached() throws RepositoryException {
        if (this.aggregator == null || !this.hasNode()) {
            throw new RepositoryException("aggregate not attached anymore");
        }
    }

    @Override
    public boolean isAttached() throws RepositoryException {
        return this.aggregator != null && this.hasNode();
    }

    @Override
    public void dump(DumpContext ctx, boolean isLast) {
        ctx.println(isLast, "Aggregate");
        ctx.indent(isLast);
        ctx.printf(false, "path: %s", this.getPath());
        ctx.printf(false, "name: %s", this.getName());
        ctx.printf(false, "relPath: %s", this.getRelPath());
        try {
            this.getArtifacts().dump(ctx, false);
        }
        catch (RepositoryException e) {
            ctx.printf(false, "no artifacts: %s", e.toString());
        }
        ctx.println(false, "Namespaces");
        ctx.indent(false);
        for (String pfx : this.getNamespacePrefixes()) {
            String uri = "invalid";
            try {
                uri = this.getNamespaceURI(pfx);
            }
            catch (RepositoryException e) {
                log.error("Error while resolving namespace uri", (Throwable)e);
            }
            ctx.printf(false, "%s = %s", pfx, uri);
        }
        ctx.outdent();
        if (this.aggregator != null) {
            this.aggregator.dump(ctx, true);
        } else {
            ctx.println(true, "no aggregator");
        }
        ctx.outdent();
    }

    @Override
    public String[] getNamespacePrefixes() {
        if (this.namespacePrefixes == null) {
            this.loadNamespaces();
        }
        return this.namespacePrefixes;
    }

    @Override
    public String getNamespaceURI(String prefix) throws RepositoryException {
        return this.mgr.getNamespaceURI(prefix);
    }

    @Override
    public Collection<Property> getBinaries() {
        return this.binaries;
    }

    public void walk(AggregateWalkListener aggregateWalkListener) throws RepositoryException {
        Node node = this.getNode();
        aggregateWalkListener.onWalkBegin(node);
        this.walk(aggregateWalkListener, "", node, 0);
        aggregateWalkListener.onWalkEnd(node);
    }

    private void walk(AggregateWalkListener aggregateWalkListener, String relPath, Node node, int depth) throws RepositoryException {
        if (node != null) {
            boolean included = this.includes(relPath);
            aggregateWalkListener.onNodeBegin(node, included, depth);
            PropertyIterator piter = node.getProperties();
            while (piter.hasNext()) {
                Property prop = piter.nextProperty();
                if (!this.includes(relPath + "/" + prop.getName())) continue;
                aggregateWalkListener.onProperty(prop, depth + 1);
            }
            aggregateWalkListener.onChildren(node, depth);
            NodeIterator niter = node.getNodes();
            long size = niter.getSize();
            ArrayList<Node> nodes = new ArrayList<Node>(size > 0L ? (int)size : 16);
            while (niter.hasNext()) {
                nodes.add(niter.nextNode());
            }
            boolean hasOrderableChildNodes = node.getPrimaryNodeType().hasOrderableChildNodes();
            if (!hasOrderableChildNodes) {
                Collections.sort(nodes, NodeNameComparator.INSTANCE);
            }
            for (Node child : nodes) {
                String p = relPath + "/" + Text.getName((String)child.getPath());
                if (this.includes(p)) {
                    this.walk(aggregateWalkListener, p, child, depth + 1);
                    continue;
                }
                if (!hasOrderableChildNodes) continue;
                aggregateWalkListener.onNodeIgnored(child, depth + 1);
            }
            aggregateWalkListener.onNodeEnd(node, included, depth);
        }
    }

    private boolean includes(String relPath) throws RepositoryException {
        return this.aggregator.hasFullCoverage() || this.includes != null && this.includes.contains(relPath);
    }

    private void include(Node node, String nodePath) throws RepositoryException {
        if (nodePath == null) {
            nodePath = node.getPath();
        }
        String relPath = nodePath.substring(this.path.length());
        if (this.includes == null || !this.includes.contains(relPath)) {
            if (log.isDebugEnabled()) {
                log.trace("including {} -> {}", (Object)this.path, (Object)nodePath);
            }
            if (this.includes == null) {
                this.includes = new HashSet<String>();
            }
            this.includes.add(this.mgr.cacheString(relPath));
            if (!node.isSame((Item)this.getNode())) {
                this.include(node.getParent(), null);
            }
        }
    }

    private void addNamespace(Set<String> prefixes, Property prop) throws RepositoryException {
        String propName = prop.getName();
        this.addNamespace(prefixes, propName);
        switch (prop.getType()) {
            case 7: {
                if ("jcr:mixinTypes".equals(propName) || prop.getDefinition().isMultiple()) {
                    Value[] values;
                    for (Value value : values = prop.getValues()) {
                        this.addNamespace(prefixes, value.getString());
                    }
                    break;
                }
                this.addNamespace(prefixes, prop.getValue().getString());
                break;
            }
            case 8: {
                if (prop.getDefinition().isMultiple()) {
                    Value[] values;
                    for (Value value : values = prop.getValues()) {
                        this.addNamespacePath(prefixes, value.getString());
                    }
                    break;
                }
                this.addNamespacePath(prefixes, prop.getValue().getString());
            }
        }
    }

    private void include(Node parent, Property prop, String propPath) throws RepositoryException {
        String relPath = propPath.substring(this.path.length());
        if (this.includes == null || !this.includes.contains(relPath)) {
            if (log.isDebugEnabled()) {
                log.trace("including {} -> {}", (Object)this.path, (Object)propPath);
            }
            this.include(parent, null);
            this.includes.add(this.mgr.cacheString(relPath));
            if (prop.getType() == 2) {
                String binaryReference;
                Binary bin;
                boolean includeBinary = true;
                if (this.useBinaryReferences && (bin = prop.getBinary()) != null && bin instanceof ReferenceBinary && (binaryReference = ((ReferenceBinary)bin).getReference()) != null) {
                    includeBinary = false;
                }
                if (includeBinary) {
                    if (this.binaries == null) {
                        this.binaries = new LinkedList<Property>();
                    }
                    this.binaries.add(prop);
                }
            }
        }
    }

    private void addNamespace(Set<String> prefixes, String name) throws RepositoryException {
        String pfx;
        int idx = name.indexOf(58);
        if (idx > 0 && !prefixes.contains(pfx = name.substring(0, idx))) {
            prefixes.add(this.mgr.cacheString(pfx));
        }
    }

    private void addNamespacePath(Set<String> prefixes, String path) throws RepositoryException {
        String[] names;
        for (String name : names = path.split("/")) {
            this.addNamespace(prefixes, name);
        }
    }

    private void loadNamespaces() {
        if (this.namespacePrefixes == null) {
            if (log.isDebugEnabled()) {
                log.trace("loading namespaces of aggregate {}", (Object)this.path);
            }
            try {
                this.load();
                HashSet<String> prefixes = new HashSet<String>();
                this.loadNamespaces(prefixes, "", this.getNode());
                this.namespacePrefixes = prefixes.toArray(new String[prefixes.size()]);
            }
            catch (RepositoryException e) {
                throw new IllegalStateException("Internal error while loading namespaces", e);
            }
        }
    }

    private void loadNamespaces(Set<String> prefixes, String parentPath, Node node) throws RepositoryException {
        String relPath;
        String name = node.getName();
        this.addNamespace(prefixes, name);
        PropertyIterator iter = node.getProperties();
        while (iter.hasNext()) {
            Property p = iter.nextProperty();
            relPath = parentPath + "/" + p.getName();
            if (!this.includes(relPath)) continue;
            this.addNamespace(prefixes, p);
        }
        iter = node.getNodes();
        while (iter.hasNext()) {
            Node c = iter.nextNode();
            relPath = parentPath + "/" + c.getName();
            if (this.includes(relPath)) {
                this.loadNamespaces(prefixes, relPath, c);
                continue;
            }
            if (!node.getPrimaryNodeType().hasOrderableChildNodes()) continue;
            this.addNamespace(prefixes, c.getName());
        }
    }

    private void load() throws RepositoryException {
        long now = System.currentTimeMillis();
        if (this.state == 'i') {
            log.trace("Collect + Preparing {}", (Object)this.getPath());
            this.prepare(this.getNode(), true);
            this.state = (char)112;
            long end = System.currentTimeMillis();
            log.trace("Collect + Preparing {} in {}ms", (Object)this.getPath(), (Object)(end - now));
            this.mgr.onAggregateCollected();
            this.mgr.onAggregatePrepared();
        } else if (this.state == 'c') {
            log.trace("Preparing {}", (Object)this.getPath());
            if (this.leaves != null && !this.leaves.isEmpty()) {
                for (AggregateImpl leaf : this.leaves) {
                    leaf.collect();
                }
            }
            this.state = (char)112;
            long end = System.currentTimeMillis();
            log.trace("Preparing {} in {}ms", (Object)this.getPath(), (Object)(end - now));
            this.mgr.onAggregatePrepared();
        }
    }

    private void collect() throws RepositoryException {
        if (this.state == 'i') {
            long now = System.currentTimeMillis();
            log.trace("Collecting {}", (Object)this.getPath());
            this.prepare(this.getNode(), false);
            this.state = (char)99;
            long end = System.currentTimeMillis();
            log.trace("Collecting  {} in {}ms", (Object)this.getPath(), (Object)(end - now));
            this.mgr.onAggregateCollected();
        }
    }

    private void prepare(Node node, boolean descend) throws RepositoryException {
        if (log.isDebugEnabled()) {
            log.trace("descending into {} (descend={})", (Object)node.getPath(), (Object)descend);
        }
        WorkspaceFilter filter = this.mgr.getWorkspaceFilter();
        PropertyIterator pIter = node.getProperties();
        while (pIter.hasNext()) {
            Property p = pIter.nextProperty();
            String path = p.getPath();
            if (!this.aggregator.includes(this.getNode(), node, p, path) || !filter.includesProperty(path)) continue;
            this.include(node, p, path);
        }
        NodeIterator nIter = node.getNodes();
        while (nIter.hasNext()) {
            boolean onlyRelativePatterns;
            Node n = nIter.nextNode();
            String path = n.getPath();
            PathFilterSet coverSet = filter.getCoveringFilterSet(path);
            boolean isAncestor = filter.isAncestor(path);
            boolean isIncluded = filter.contains(path);
            if (coverSet == null && !isAncestor) continue;
            Aggregator a = this.mgr.getAggregator(n, path);
            if (a == null || (a == this.aggregator || a.isDefault()) && this.aggregator.includes(this.getNode(), n, path)) {
                if (!isIncluded && !isAncestor) continue;
                this.include(n, path);
                this.prepare(n, true);
                continue;
            }
            boolean bl = onlyRelativePatterns = coverSet != null && coverSet.hasOnlyRelativePatterns();
            if (!isAncestor && !isIncluded && !onlyRelativePatterns) continue;
            AggregateImpl sub = new AggregateImpl(this, path, a);
            boolean bl2 = sub.filterArtifacts = !isIncluded && onlyRelativePatterns;
            if (this.leaves == null) {
                this.leaves = new LinkedList<AggregateImpl>();
            }
            if (descend) {
                try {
                    sub.collect();
                }
                catch (RepositoryException e) {
                    log.warn("Alleged node is gone: {}", (Object)path);
                    sub.invalidate();
                    sub = null;
                }
            } else {
                log.trace("adding pending leaf {}", (Object)path);
            }
            if (sub == null) continue;
            this.leaves.add(sub);
        }
    }
}

