/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.cpconverter.vltpkg;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.NamespaceException;
import javax.jcr.NamespaceRegistry;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.commons.cnd.ParseException;
import org.apache.jackrabbit.spi.commons.namespace.NamespaceResolver;
import org.jetbrains.annotations.NotNull;

public class JcrNamespaceRegistry
implements NamespaceRegistry,
NamespaceResolver {
    private final Map<String, String> prefixUriMapping = new HashMap<String, String>();
    private final Collection<String> registeredCndSystemIds;

    public JcrNamespaceRegistry() {
        this.prefixUriMapping.put("jcr", "http://www.jcp.org/jcr/1.0");
        this.prefixUriMapping.put("mix", "http://www.jcp.org/jcr/mix/1.0");
        this.prefixUriMapping.put("nt", "http://www.jcp.org/jcr/nt/1.0");
        this.prefixUriMapping.put("xml", "http://www.w3.org/XML/1998/namespace");
        this.prefixUriMapping.put("sling", "http://sling.apache.org/jcr/sling/1.0");
        this.registeredCndSystemIds = new ArrayList<String>();
    }

    public void registerCnd(Reader reader, String systemId) throws ParseException, RepositoryException, IOException {
        throw new IllegalStateException("Not implemented");
    }

    public void registerNamespace(String prefix, String uri) throws RepositoryException {
        String oldUri = this.prefixUriMapping.putIfAbsent(prefix, uri);
        if (oldUri != null && !oldUri.equals(uri)) {
            throw new RepositoryException("Prefix " + prefix + " already used for another uri!");
        }
    }

    public void unregisterNamespace(String prefix) throws RepositoryException {
        throw new UnsupportedOperationException("Unregistering namespaces is unsupported");
    }

    public String[] getPrefixes() throws RepositoryException {
        return this.prefixUriMapping.keySet().toArray(new String[0]);
    }

    public String[] getURIs() throws RepositoryException {
        return this.prefixUriMapping.values().toArray(new String[0]);
    }

    public String getURI(String prefix) throws NamespaceException {
        String uri = this.prefixUriMapping.get(prefix);
        if (uri == null) {
            throw new NamespaceException("No registered URI found for prefix " + prefix);
        }
        return uri;
    }

    public String getPrefix(String uri) throws NamespaceException {
        throw new UnsupportedOperationException("This lookup direction is unsupported");
    }

    @NotNull
    public Collection<String> getRegisteredCndSystemIds() {
        return this.registeredCndSystemIds;
    }
}

