/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.analyser.task.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.sling.feature.analyser.task.AnalyserTask;
import org.apache.sling.feature.analyser.task.AnalyserTaskContext;
import org.apache.sling.feature.scanner.BundleDescriptor;
import org.apache.sling.feature.scanner.PackageInfo;
import org.osgi.framework.Version;

public class CheckBundleExportsImports
implements AnalyserTask {
    private static final List<String> IGNORED_IMPORT_PREFIXES = Arrays.asList("java.", "javax.", "org.w3c.", "org.xml.");

    @Override
    public String getName() {
        return "Bundle Import/Export Check";
    }

    @Override
    public String getId() {
        return "bundle-packages";
    }

    private Report getReport(Map<BundleDescriptor, Report> reports, BundleDescriptor info) {
        Report report = reports.get(info);
        if (report == null) {
            report = new Report();
            reports.put(info, report);
        }
        return report;
    }

    private void checkForVersionOnExportedPackages(AnalyserTaskContext ctx, Map<BundleDescriptor, Report> reports) {
        for (BundleDescriptor info : ctx.getFeatureDescriptor().getBundleDescriptors()) {
            if (info.getExportedPackages() == null) continue;
            for (PackageInfo i : info.getExportedPackages()) {
                if (i.getPackageVersion().compareTo(Version.emptyVersion) != 0) continue;
                this.getReport(reports, (BundleDescriptor)info).exportWithoutVersion.add(i);
            }
        }
    }

    private boolean ignoreImportPackage(String name) {
        for (String prefix : IGNORED_IMPORT_PREFIXES) {
            if (!name.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    private void checkForVersionOnImportingPackages(AnalyserTaskContext ctx, Map<BundleDescriptor, Report> reports) {
        for (BundleDescriptor info : ctx.getFeatureDescriptor().getBundleDescriptors()) {
            if (info.getImportedPackages() == null) continue;
            for (PackageInfo i : info.getImportedPackages()) {
                if (i.getVersion() != null || this.ignoreImportPackage(i.getName())) continue;
                this.getReport(reports, (BundleDescriptor)info).importWithoutVersion.add(i);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void execute(AnalyserTaskContext ctx) throws IOException {
        boolean bl;
        HashMap<BundleDescriptor, Report> reports = new HashMap<BundleDescriptor, Report>();
        this.checkForVersionOnExportedPackages(ctx, reports);
        this.checkForVersionOnImportingPackages(ctx, reports);
        TreeMap bundlesMap = new TreeMap();
        for (BundleDescriptor bundleDescriptor : ctx.getFeatureDescriptor().getBundleDescriptors()) {
            void var6_9;
            List list = (List)bundlesMap.get(bundleDescriptor.getArtifact().getStartOrder());
            if (list == null) {
                ArrayList arrayList = new ArrayList();
                bundlesMap.put(bundleDescriptor.getArtifact().getStartOrder(), arrayList);
            }
            var6_9.add(bundleDescriptor);
        }
        ArrayList<BundleDescriptor> exportingBundles = new ArrayList<BundleDescriptor>();
        if (ctx.getFrameworkDescriptor() != null) {
            exportingBundles.add(ctx.getFrameworkDescriptor());
        }
        for (Map.Entry entry : bundlesMap.entrySet()) {
            for (BundleDescriptor info : (List)entry.getValue()) {
                if (info.getExportedPackages() == null) continue;
                exportingBundles.add(info);
            }
            for (BundleDescriptor info : (List)entry.getValue()) {
                if (info.getImportedPackages() == null) continue;
                for (PackageInfo pck : info.getImportedPackages()) {
                    List<BundleDescriptor> candidates = this.getCandidates(exportingBundles, pck);
                    if (candidates.isEmpty()) {
                        if (pck.isOptional()) {
                            this.getReport(reports, (BundleDescriptor)info).missingExportsForOptional.add(pck);
                            continue;
                        }
                        this.getReport(reports, (BundleDescriptor)info).missingExports.add(pck);
                        continue;
                    }
                    ArrayList<BundleDescriptor> matchingCandidates = new ArrayList<BundleDescriptor>();
                    for (BundleDescriptor i : candidates) {
                        if (!i.isExportingPackage(pck)) continue;
                        matchingCandidates.add(i);
                    }
                    if (matchingCandidates.isEmpty()) {
                        if (pck.isOptional()) {
                            this.getReport(reports, (BundleDescriptor)info).missingExportsForOptional.add(pck);
                            continue;
                        }
                        this.getReport(reports, (BundleDescriptor)info).missingExportsWithVersion.add(pck);
                        continue;
                    }
                    if (matchingCandidates.size() <= 1) continue;
                    this.getReport(reports, (BundleDescriptor)info).exportMatchingSeveral.add(pck);
                }
            }
        }
        boolean bl2 = false;
        for (Map.Entry entry : reports.entrySet()) {
            if (!((Report)entry.getValue()).importWithoutVersion.isEmpty()) {
                ctx.reportArtifactWarning(((BundleDescriptor)entry.getKey()).getArtifact().getId(), " is importing package(s) " + this.getPackageInfo(((Report)entry.getValue()).importWithoutVersion, false) + " without specifying a version range.");
            }
            if (!((Report)entry.getValue()).exportWithoutVersion.isEmpty()) {
                ctx.reportArtifactWarning(((BundleDescriptor)entry.getKey()).getArtifact().getId(), " is exporting package(s) " + this.getPackageInfo(((Report)entry.getValue()).importWithoutVersion, false) + " without a version.");
            }
            if (!((Report)entry.getValue()).missingExports.isEmpty()) {
                ctx.reportArtifactError(((BundleDescriptor)entry.getKey()).getArtifact().getId(), " is importing package(s) " + this.getPackageInfo(((Report)entry.getValue()).missingExports, false) + " in start level " + String.valueOf(((BundleDescriptor)entry.getKey()).getArtifact().getStartOrder()) + " but no bundle is exporting these for that start level.");
                bl = true;
            }
            if (((Report)entry.getValue()).missingExportsWithVersion.isEmpty()) continue;
            ctx.reportArtifactError(((BundleDescriptor)entry.getKey()).getArtifact().getId(), " is importing package(s) " + this.getPackageInfo(((Report)entry.getValue()).missingExportsWithVersion, true) + " in start level " + String.valueOf(((BundleDescriptor)entry.getKey()).getArtifact().getStartOrder()) + " but no bundle is exporting these for that start level in the required version range.");
            bl = true;
        }
        if (bl && ctx.getFeature().isComplete()) {
            ctx.reportError(ctx.getFeature().getId().toMvnId() + " is marked as 'complete' but has missing imports.");
        }
    }

    private String getPackageInfo(List<PackageInfo> pcks, boolean includeVersion) {
        if (pcks.size() == 1) {
            if (includeVersion) {
                return pcks.get(0).toString();
            }
            return pcks.get(0).getName();
        }
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        sb.append('[');
        for (PackageInfo info : pcks) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            if (includeVersion) {
                sb.append(info.toString());
                continue;
            }
            sb.append(info.getName());
        }
        sb.append(']');
        return sb.toString();
    }

    private List<BundleDescriptor> getCandidates(List<BundleDescriptor> exportingBundles, PackageInfo pck) {
        ArrayList<BundleDescriptor> candidates = new ArrayList<BundleDescriptor>();
        for (BundleDescriptor info : exportingBundles) {
            if (!info.isExportingPackage(pck.getName())) continue;
            candidates.add(info);
        }
        return candidates;
    }

    public static final class Report {
        public List<PackageInfo> exportWithoutVersion = new ArrayList<PackageInfo>();
        public List<PackageInfo> exportMatchingSeveral = new ArrayList<PackageInfo>();
        public List<PackageInfo> importWithoutVersion = new ArrayList<PackageInfo>();
        public List<PackageInfo> missingExports = new ArrayList<PackageInfo>();
        public List<PackageInfo> missingExportsWithVersion = new ArrayList<PackageInfo>();
        public List<PackageInfo> missingExportsForOptional = new ArrayList<PackageInfo>();
    }
}

