/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.event.dea.impl;

import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.event.dea.impl.DistributedEventReceiver;
import org.apache.sling.event.dea.impl.DistributedEventSender;
import org.apache.sling.serviceusermapping.ServiceUserMapped;
import org.apache.sling.settings.SlingSettingsService;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.event.EventAdmin;

@Component(name="org.apache.sling.event.impl.DistributingEventHandler")
public class DistributedEventAdminImpl {
    public static final String RESOURCE_TYPE_FOLDER = "sling:Folder";
    public static final String RESOURCE_TYPE_EVENT = "sling/distributed/event";
    @Reference
    private SlingSettingsService settings;
    @Reference
    private ResourceResolverFactory resourceResolverFactory;
    @Reference
    private EventAdmin eventAdmin;
    @Reference
    private ServiceUserMapped serviceUserMapped;
    public static final String DEFAULT_REPOSITORY_PATH = "/var/eventing/distribution";
    private static final int DEFAULT_CLEANUP_PERIOD = 15;
    private DistributedEventReceiver receiver;
    private DistributedEventSender sender;

    @Activate
    protected void activate(BundleContext bundleContext, Config props) {
        String ownRootPath = props.repository_path().concat("/").concat(this.settings.getSlingId());
        this.receiver = new DistributedEventReceiver(bundleContext, props.repository_path(), ownRootPath, props.cleanup_period(), this.resourceResolverFactory, this.settings);
        this.sender = new DistributedEventSender(bundleContext, props.repository_path(), ownRootPath, this.resourceResolverFactory, this.eventAdmin);
    }

    @Deactivate
    protected void deactivate() {
        if (this.receiver != null) {
            this.receiver.stop();
            this.receiver = null;
        }
        if (this.sender != null) {
            this.sender.stop();
            this.sender = null;
        }
    }

    public static @interface Config {
        public String repository_path() default "/var/eventing/distribution";

        public int cleanup_period() default 15;
    }
}

