/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.event.impl.jobs.tasks;

import java.util.Arrays;
import java.util.Calendar;
import java.util.Iterator;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.event.impl.jobs.config.JobManagerConfiguration;
import org.apache.sling.event.impl.jobs.config.TopologyCapabilities;
import org.apache.sling.event.impl.jobs.queues.ResultBuilderImpl;
import org.apache.sling.event.impl.jobs.scheduling.JobSchedulerImpl;
import org.apache.sling.event.impl.jobs.tasks.HistoryCleanUpTask;
import org.apache.sling.event.jobs.Job;
import org.apache.sling.event.jobs.consumer.JobExecutionContext;
import org.apache.sling.event.jobs.consumer.JobExecutionResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CleanUpTask {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final JobManagerConfiguration configuration;
    private final JobSchedulerImpl jobScheduler;
    private volatile long schedulerRuns;

    public CleanUpTask(JobManagerConfiguration config, JobSchedulerImpl jobScheduler) {
        this.configuration = config;
        this.jobScheduler = jobScheduler;
    }

    public void run() {
        ++this.schedulerRuns;
        this.logger.debug("Job manager maintenance: Starting #{}", (Object)this.schedulerRuns);
        TopologyCapabilities topologyCapabilities = this.configuration.getTopologyCapabilities();
        if (topologyCapabilities != null) {
            String cleanUpUnassignedPath = topologyCapabilities.isLeader() ? this.configuration.getUnassignedJobsPath() : null;
            if (this.schedulerRuns % 3L == 1L) {
                this.jobScheduler.maintenance();
            }
            if (this.schedulerRuns % 60L == 0L) {
                this.fullEmptyFolderCleanup(topologyCapabilities, this.configuration.getLocalJobsPath());
                if (cleanUpUnassignedPath != null) {
                    this.fullEmptyFolderCleanup(topologyCapabilities, cleanUpUnassignedPath);
                }
            } else if (this.schedulerRuns % 5L == 0L) {
                this.simpleEmptyFolderCleanup(topologyCapabilities, this.configuration.getLocalJobsPath());
                if (cleanUpUnassignedPath != null) {
                    this.simpleEmptyFolderCleanup(topologyCapabilities, cleanUpUnassignedPath);
                }
            }
        }
        if (this.configuration.getHistoryCleanUpRemovedJobs() > 0 && this.schedulerRuns % 60L == 1L) {
            Calendar removeDate = Calendar.getInstance();
            removeDate.add(12, -this.configuration.getHistoryCleanUpRemovedJobs());
            this.historyCleanUpRemovedJobs(removeDate);
        }
        this.logger.debug("Job manager maintenance: Finished #{}", (Object)this.schedulerRuns);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void historyCleanUpRemovedJobs(Calendar since) {
        try (ResourceResolver resolver = this.configuration.createResourceResolver();){
            HistoryCleanUpTask.cleanup(since, resolver, new JobExecutionContext(){

                @Override
                public void asyncProcessingFinished(JobExecutionResult result) {
                }

                @Override
                public boolean isStopped() {
                    return false;
                }

                @Override
                public void initProgress(int steps, long eta) {
                }

                @Override
                public void incrementProgressCount(int steps) {
                }

                @Override
                public void updateProgress(long eta) {
                }

                @Override
                public void log(String message, Object ... args) {
                }

                @Override
                public JobExecutionContext.ResultBuilder result() {
                    return new ResultBuilderImpl();
                }
            }, this.configuration.getStoredCancelledJobsPath(), null, Arrays.asList(Job.JobState.DROPPED.name(), Job.JobState.ERROR.name()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void simpleEmptyFolderCleanup(TopologyCapabilities caps, String basePath) {
        this.logger.debug("Cleaning up job resource tree: looking for empty folders");
        try (ResourceResolver resolver = this.configuration.createResourceResolver();){
            Calendar cleanUpDate = Calendar.getInstance();
            cleanUpDate.add(12, -5);
            Resource baseResource = resolver.getResource(basePath);
            if (baseResource != null) {
                Iterator topicIter = baseResource.listChildren();
                while (caps.isActive() && topicIter.hasNext()) {
                    Resource topicResource = (Resource)topicIter.next();
                    for (int i = 0; i < 10; ++i) {
                        String hourPath;
                        Resource hourResource;
                        if (!caps.isActive()) continue;
                        StringBuilder sb = new StringBuilder(topicResource.getPath());
                        sb.append('/');
                        sb.append(cleanUpDate.get(1));
                        sb.append('/');
                        sb.append(cleanUpDate.get(2) + 1);
                        sb.append('/');
                        sb.append(cleanUpDate.get(5));
                        sb.append('/');
                        sb.append(cleanUpDate.get(11));
                        sb.append('/');
                        sb.append(cleanUpDate.get(12));
                        String path = sb.toString();
                        Resource dateResource = resolver.getResource(path);
                        if (dateResource != null && !dateResource.listChildren().hasNext()) {
                            resolver.delete(dateResource);
                            resolver.commit();
                        }
                        if (path.endsWith("59") && (hourResource = resolver.getResource(hourPath = path.substring(0, path.length() - 3))) != null && !hourResource.listChildren().hasNext()) {
                            resolver.delete(hourResource);
                            resolver.commit();
                        }
                        cleanUpDate.add(12, -1);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fullEmptyFolderCleanup(TopologyCapabilities caps, String basePath) {
        this.logger.debug("Cleaning up job resource tree: removing ALL empty folders");
        ResourceResolver resolver = this.configuration.createResourceResolver();
        if (resolver == null) {
            return;
        }
        try {
            Resource baseResource = resolver.getResource(basePath);
            if (baseResource != null) {
                Calendar now = Calendar.getInstance();
                int removeYear = now.get(1);
                int removeMonth = now.get(2) + 1;
                int removeDay = now.get(5);
                int removeHour = now.get(11);
                Iterator topicIter = baseResource.listChildren();
                while (caps.isActive() && topicIter.hasNext()) {
                    Resource topicResource = (Resource)topicIter.next();
                    Iterator yearIter = topicResource.listChildren();
                    while (caps.isActive() && yearIter.hasNext()) {
                        Resource yearResource = (Resource)yearIter.next();
                        int year = Integer.valueOf(yearResource.getName());
                        if (year > removeYear) continue;
                        boolean oldYear = year < removeYear;
                        Iterator monthIter = yearResource.listChildren();
                        while (caps.isActive() && monthIter.hasNext()) {
                            Resource monthResource = (Resource)monthIter.next();
                            int month = Integer.valueOf(monthResource.getName());
                            if (!oldYear && month > removeMonth) continue;
                            boolean oldMonth = oldYear || month < removeMonth;
                            Iterator dayIter = monthResource.listChildren();
                            while (caps.isActive() && dayIter.hasNext()) {
                                Resource dayResource = (Resource)dayIter.next();
                                int day = Integer.valueOf(dayResource.getName());
                                if (!oldMonth && day > removeDay) continue;
                                boolean oldDay = oldMonth || day < removeDay;
                                Iterator hourIter = dayResource.listChildren();
                                while (caps.isActive() && hourIter.hasNext()) {
                                    boolean oldHour;
                                    Resource hourResource = (Resource)hourIter.next();
                                    int hour = Integer.valueOf(hourResource.getName());
                                    if (!oldDay && hour > removeHour) continue;
                                    boolean bl = oldHour = oldDay && (oldMonth || removeHour > 0) || hour < removeHour - 1;
                                    if (oldHour) {
                                        Iterator minuteIter = hourResource.listChildren();
                                        while (caps.isActive() && minuteIter.hasNext()) {
                                            Resource minuteResource = (Resource)minuteIter.next();
                                            if (minuteResource.listChildren().hasNext()) continue;
                                            resolver.delete(minuteResource);
                                            resolver.commit();
                                        }
                                    }
                                    if (!caps.isActive() || !oldHour || hourResource.listChildren().hasNext()) continue;
                                    resolver.delete(hourResource);
                                    resolver.commit();
                                }
                                if (!caps.isActive() || !oldDay || dayResource.listChildren().hasNext()) continue;
                                resolver.delete(dayResource);
                                resolver.commit();
                            }
                            if (!caps.isActive() || !oldMonth || monthResource.listChildren().hasNext()) continue;
                            resolver.delete(monthResource);
                            resolver.commit();
                        }
                        if (!caps.isActive() || !oldYear || yearResource.listChildren().hasNext()) continue;
                        resolver.delete(yearResource);
                        resolver.commit();
                    }
                }
            }
        }
        catch (PersistenceException pe) {
            this.logger.warn("Exception during job resource tree cleanup.", (Throwable)pe);
        }
        finally {
            resolver.close();
        }
    }
}

