/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.event.impl.jobs.stats;

import org.apache.sling.event.jobs.TopicStatistics;

public class TopicStatisticsImpl
implements TopicStatistics {
    private final String topic;
    private volatile long lastActivated = -1L;
    private volatile long lastFinished = -1L;
    private volatile long averageWaitingTime;
    private volatile long averageProcessingTime;
    private volatile long waitingTime;
    private volatile long processingTime;
    private volatile long waitingCount;
    private volatile long processingCount;
    private volatile long finishedJobs;
    private volatile long failedJobs;
    private volatile long cancelledJobs;

    public TopicStatisticsImpl(String topic) {
        this.topic = topic;
    }

    @Override
    public String getTopic() {
        return this.topic;
    }

    @Override
    public synchronized long getNumberOfProcessedJobs() {
        return this.getNumberOfCancelledJobs() + this.getNumberOfFailedJobs() + this.getNumberOfFinishedJobs();
    }

    @Override
    public synchronized long getAverageWaitingTime() {
        return this.averageWaitingTime;
    }

    @Override
    public synchronized long getAverageProcessingTime() {
        return this.averageProcessingTime;
    }

    @Override
    public synchronized long getNumberOfFinishedJobs() {
        return this.finishedJobs;
    }

    @Override
    public synchronized long getNumberOfCancelledJobs() {
        return this.cancelledJobs;
    }

    @Override
    public synchronized long getNumberOfFailedJobs() {
        return this.failedJobs;
    }

    @Override
    public synchronized long getLastActivatedJobTime() {
        return this.lastActivated;
    }

    @Override
    public synchronized long getLastFinishedJobTime() {
        return this.lastFinished;
    }

    public synchronized void addFinished(long jobTime) {
        ++this.finishedJobs;
        this.lastFinished = System.currentTimeMillis();
        if (jobTime > 0L) {
            this.processingTime += jobTime;
            ++this.processingCount;
            this.averageProcessingTime = this.processingTime / this.processingCount;
        }
    }

    public synchronized void addActivated(long queueTime) {
        this.lastActivated = System.currentTimeMillis();
        if (queueTime > 0L) {
            this.waitingTime += queueTime;
            ++this.waitingCount;
            this.averageWaitingTime = this.waitingTime / this.waitingCount;
        }
    }

    public synchronized void addFailed() {
        ++this.failedJobs;
    }

    public synchronized void addCancelled() {
        ++this.cancelledJobs;
    }
}

