/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.event.impl.jobs.stats;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.MetricRegistry;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.sling.event.jobs.Statistics;

class GaugeSupport {
    static final String GAUGE_NAME_PREFIX = "event.jobs";
    static final String QUEUE_PREFIX = "queue";
    static final String CANCELLED_METRIC_SUFFIX = ".cancelled.count";
    static final String FINISHED_METRIC_SUFFIX = ".finished.count";
    static final String FAILED__METRIC_SUFFIX = ".failed.count";
    static final String QUEUED_METRIC_SUFFIX = ".queued.count";
    static final String PROCESSED_METRIC_SUFFIX = ".processed.count";
    static final String ACTIVE_METRIC_SUFFIX = ".active.count";
    static final String AVG_WAITING_TIME_METRIC_SUFFIX = ".averageWaitingTime";
    static final String AVG_PROCESSING_TIME_METRIC_SUFFIX = ".averageProcessingTime";
    private final MetricRegistry metricRegistry;
    private final Map<String, Gauge<Long>> gaugeList = new HashMap<String, Gauge<Long>>();
    private final Set<String> gaugeMetricNames = new HashSet<String>();
    private final String queueName;

    GaugeSupport(Statistics globalQueueStats, MetricRegistry metricRegistry) {
        this(null, globalQueueStats, metricRegistry);
    }

    GaugeSupport(String queueName, final Statistics queueStats, MetricRegistry metricRegistry) {
        this.metricRegistry = metricRegistry;
        this.queueName = this.getSanitizedQueueName(queueName);
        if (metricRegistry != null && queueStats != null) {
            this.gaugeList.put(FINISHED_METRIC_SUFFIX, new Gauge<Long>(){

                public Long getValue() {
                    return queueStats.getNumberOfFinishedJobs();
                }
            });
            this.gaugeList.put(CANCELLED_METRIC_SUFFIX, new Gauge<Long>(){

                public Long getValue() {
                    return queueStats.getNumberOfCancelledJobs();
                }
            });
            this.gaugeList.put(FAILED__METRIC_SUFFIX, new Gauge<Long>(){

                public Long getValue() {
                    return queueStats.getNumberOfFailedJobs();
                }
            });
            this.gaugeList.put(QUEUED_METRIC_SUFFIX, new Gauge<Long>(){

                public Long getValue() {
                    return queueStats.getNumberOfQueuedJobs();
                }
            });
            this.gaugeList.put(PROCESSED_METRIC_SUFFIX, new Gauge<Long>(){

                public Long getValue() {
                    return queueStats.getNumberOfProcessedJobs();
                }
            });
            this.gaugeList.put(ACTIVE_METRIC_SUFFIX, new Gauge<Long>(){

                public Long getValue() {
                    return queueStats.getNumberOfActiveJobs();
                }
            });
            this.gaugeList.put(AVG_WAITING_TIME_METRIC_SUFFIX, new Gauge<Long>(){

                public Long getValue() {
                    return queueStats.getAverageWaitingTime();
                }
            });
            this.gaugeList.put(AVG_PROCESSING_TIME_METRIC_SUFFIX, new Gauge<Long>(){

                public Long getValue() {
                    return queueStats.getAverageProcessingTime();
                }
            });
        }
    }

    void shutdown() {
        if (this.metricRegistry != null) {
            for (String metricName : this.gaugeMetricNames) {
                try {
                    this.metricRegistry.remove(metricName);
                }
                catch (RuntimeException runtimeException) {}
            }
        }
    }

    void initialize() {
        for (Map.Entry<String, Gauge<Long>> entry : this.gaugeList.entrySet()) {
            this.registerWithSuffix(entry.getKey(), 0, entry.getValue());
        }
    }

    private void registerWithSuffix(String suffix, int count, Gauge<Long> value) {
        block2: {
            try {
                String metricName = this.getMetricName(this.queueName, count, suffix);
                this.metricRegistry.register(metricName, value);
                this.gaugeMetricNames.add(metricName);
            }
            catch (IllegalArgumentException e) {
                if (this.queueName == null) break block2;
                this.registerWithSuffix(suffix, count + 1, value);
            }
        }
    }

    private String getMetricName(String queueName, int count, String metricSuffix) {
        String metricName;
        String string = metricName = queueName != null ? ".queue." + queueName : "";
        if (count > 0) {
            metricName = metricName + "_" + count;
        }
        return GAUGE_NAME_PREFIX + metricName + metricSuffix;
    }

    private String getSanitizedQueueName(String queueName) {
        if (queueName == null) {
            return null;
        }
        return queueName.replaceAll("[^a-zA-Z\\d]", "_").toLowerCase();
    }
}

