/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.event.impl.jobs.config;

import java.util.Arrays;
import java.util.Map;
import org.apache.sling.event.impl.jobs.config.ConfigurationConstants;
import org.apache.sling.event.impl.support.TopicMatcher;
import org.apache.sling.event.impl.support.TopicMatcherHelper;
import org.apache.sling.event.jobs.QueueConfiguration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.osgi.service.metatype.annotations.Option;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={InternalQueueConfiguration.class}, name="org.apache.sling.event.jobs.QueueConfiguration", configurationPolicy=ConfigurationPolicy.REQUIRE, property={"service.vendor=The Apache Software Foundation"})
@Designate(ocd=Config.class, factory=true)
public class InternalQueueConfiguration
implements QueueConfiguration,
Comparable<InternalQueueConfiguration> {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private String name;
    private QueueConfiguration.Type type;
    private int retries;
    private long retryDelay;
    private QueueConfiguration.ThreadPriority priority;
    private int maxParallelProcesses;
    private int serviceRanking;
    private TopicMatcher[] matchers;
    private String[] topics;
    private boolean keepJobs;
    private boolean valid = false;
    private int ownThreadPoolSize;
    private boolean preferCreationInstance;
    private String pid;

    public static InternalQueueConfiguration fromConfiguration(Map<String, Object> props, Config config) {
        InternalQueueConfiguration c = new InternalQueueConfiguration();
        c.activate(props, config);
        return c;
    }

    @Activate
    protected void activate(Map<String, Object> props, Config config) {
        this.name = config.queue_name();
        try {
            this.priority = QueueConfiguration.ThreadPriority.valueOf(config.queue_priority());
        }
        catch (IllegalArgumentException iae) {
            this.logger.warn("Invalid value for queue priority. Using default instead of : {}", (Object)config.queue_priority());
            this.priority = QueueConfiguration.ThreadPriority.valueOf("NORM");
        }
        try {
            this.type = QueueConfiguration.Type.valueOf(config.queue_type());
        }
        catch (IllegalArgumentException iae) {
            this.logger.error("Invalid value for queue type configuration: {}", (Object)config.queue_type());
            this.type = null;
        }
        this.retries = config.queue_retries();
        this.retryDelay = config.queue_retrydelay();
        int cores = ConfigurationConstants.NUMBER_OF_PROCESSORS;
        double inMaxParallel = config.queue_maxparallel();
        this.logger.debug("Max parallel for queue {} is {}", (Object)this.name, (Object)inMaxParallel);
        if (inMaxParallel == Math.floor(inMaxParallel) && !Double.isInfinite(inMaxParallel)) {
            if ((int)inMaxParallel == 0) {
                this.logger.warn("Max threads property for {} set to zero.", (Object)this.name);
            }
            this.maxParallelProcesses = inMaxParallel <= -1.0 ? cores : (int)inMaxParallel;
        } else if (inMaxParallel > 0.0 && inMaxParallel < 1.0) {
            this.maxParallelProcesses = (int)Math.round((double)cores * inMaxParallel);
        } else {
            this.logger.warn("Invalid queue max parallel value for queue {}. Using {}", (Object)this.name, (Object)cores);
            this.maxParallelProcesses = cores;
        }
        this.logger.debug("Thread pool size for {} was set to {}", (Object)this.name, (Object)this.maxParallelProcesses);
        if (this.type == QueueConfiguration.Type.ORDERED) {
            this.maxParallelProcesses = 1;
        }
        String[] topicsParam = config.queue_topics();
        this.matchers = TopicMatcherHelper.buildMatchers(topicsParam);
        this.topics = this.matchers == null ? null : topicsParam;
        this.keepJobs = config.queue_keepJobs();
        this.serviceRanking = config.service_ranking();
        this.ownThreadPoolSize = config.queue_threadPoolSize();
        this.preferCreationInstance = config.queue_preferRunOnCreationInstance();
        this.pid = (String)props.get("service.pid");
        this.valid = this.checkIsValid();
    }

    private boolean checkIsValid() {
        if (this.type == null) {
            return false;
        }
        boolean hasMatchers = false;
        if (this.matchers != null) {
            for (TopicMatcher m : this.matchers) {
                if (m == null) continue;
                hasMatchers = true;
                break;
            }
        }
        if (!hasMatchers) {
            return false;
        }
        if (this.name == null || this.name.length() == 0) {
            return false;
        }
        if (this.retries < -1) {
            return false;
        }
        return this.maxParallelProcesses >= 1;
    }

    public boolean isValid() {
        return this.valid;
    }

    public String match(String topic) {
        if (this.matchers != null) {
            for (TopicMatcher m : this.matchers) {
                String rep;
                if (m == null || (rep = m.match(topic)) == null) continue;
                return this.name.replace("{0}", rep);
            }
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public long getRetryDelayInMs() {
        return this.retryDelay;
    }

    @Override
    public int getMaxRetries() {
        return this.retries;
    }

    @Override
    public QueueConfiguration.Type getType() {
        return this.type;
    }

    @Override
    public int getMaxParallel() {
        return this.maxParallelProcesses;
    }

    @Override
    public String[] getTopics() {
        return this.topics;
    }

    @Override
    public int getRanking() {
        return this.serviceRanking;
    }

    public String getPid() {
        return this.pid;
    }

    @Override
    public boolean isKeepJobs() {
        return this.keepJobs;
    }

    @Override
    public int getOwnThreadPoolSize() {
        return this.ownThreadPoolSize;
    }

    @Override
    public boolean isPreferRunOnCreationInstance() {
        return this.preferCreationInstance;
    }

    public String toString() {
        return "Queue-Configuration(" + this.hashCode() + ") : {" + "name=" + this.name + ", type=" + (Object)((Object)this.type) + ", topics=" + (this.matchers == null ? "[]" : Arrays.toString(this.matchers)) + ", maxParallelProcesses=" + this.maxParallelProcesses + ", retries=" + this.retries + ", retryDelayInMs=" + this.retryDelay + ", keepJobs=" + this.keepJobs + ", preferRunOnCreationInstance=" + this.preferCreationInstance + ", ownThreadPoolSize=" + this.ownThreadPoolSize + ", serviceRanking=" + this.serviceRanking + ", pid=" + this.pid + ", isValid=" + this.isValid() + "}";
    }

    @Override
    public int compareTo(InternalQueueConfiguration other) {
        if (this.serviceRanking < other.serviceRanking) {
            return 1;
        }
        if (this.serviceRanking > other.serviceRanking) {
            return -1;
        }
        return 0;
    }

    @Override
    public QueueConfiguration.ThreadPriority getThreadPriority() {
        return this.priority;
    }

    @ObjectClassDefinition(name="Apache Sling Job Queue Configuration", description="The configuration of a job processing queue.")
    public static @interface Config {
        @AttributeDefinition(name="Name", description="The name of the queue. If matching is used the token {0} can be used to substitute the real value.")
        public String queue_name();

        @AttributeDefinition(name="Topics", description="This value is required and lists the topics processed by this queue. The value is a list of strings. If a string ends with a dot, all topics in exactly this package match. If the string ends with a star, all topics in this package and all subpackages match. If the string neither ends with a dot nor with a star, this is assumed to define an exact topic.")
        public String[] queue_topics();

        @AttributeDefinition(name="Type", description="The queue type.", options={@Option(label="Parallel", value="UNORDERED"), @Option(label="Ordered", value="ORDERED"), @Option(label="Topic Round Robin", value="TOPIC_ROUND_ROBIN")})
        public String queue_type() default "UNORDERED";

        @AttributeDefinition(name="Priority", description="The priority for the threads used by this queue. Default is norm.", options={@Option(label="Norm", value="NORM"), @Option(label="Min", value="MIN"), @Option(label="Max", value="MAX")})
        public String queue_priority() default "NORM";

        @AttributeDefinition(name="Maximum Retries", description="The maximum number of times a failed job slated for retries is actually retried. If a job has been retried this number of times and still fails, it is not rescheduled and assumed to have failed. The default value is 10.")
        public int queue_retries() default 10;

        @AttributeDefinition(name="Retry Delay", description="The number of milliseconds to sleep between two consecutive retries of a job which failed and was set to be retried. The default value is 2 seconds. This value is only relevant if there is a single failed job in the queue. If there are multiple failed jobs, each job is retried in turn without an intervening delay.")
        public long queue_retrydelay() default 2000L;

        @AttributeDefinition(name="Maximum Parallel Jobs", description="The maximum number of parallel jobs started for this queue. A value of -1 is substituted with the number of available processors. Positive integer values specify number of processors to use.  Can be greater than number of processors. A decimal number between 0.0 and 1.0 is treated as a fraction of available processors. For example 0.5 means half of the available processors. For ordered queue types this value is ignored (always enforced to be 1).")
        public double queue_maxparallel() default 15.0;

        @AttributeDefinition(name="Keep History", description="If this option is enabled, successful finished jobs are kept to provide a complete history.")
        public boolean queue_keepJobs() default false;

        @AttributeDefinition(name="Prefer Creation Instance", description="If this option is enabled, the jobs are tried to be run on the instance where the job was created.")
        public boolean queue_preferRunOnCreationInstance() default false;

        @AttributeDefinition(name="Thread Pool Size", description="Optional configuration value for a thread pool to be used by this queue. If this is value has a positive number of threads configuration, this queue uses an own thread pool with the configured number of threads.")
        public int queue_threadPoolSize() default 0;

        @AttributeDefinition(name="Ranking", description="Integer value defining the ranking of this queue configuration. If more than one queue matches a job topic, the one with the highest ranking is used.")
        public int service_ranking() default 0;

        public String webconsole_configurationFactory_nameHint() default "Queue: {queue.name}";
    }
}

