/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.engine.impl.filter;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import org.apache.sling.commons.osgi.OsgiUtil;
import org.apache.sling.engine.impl.console.WebConsoleConfigPrinter;
import org.apache.sling.engine.impl.filter.FilterHandle;
import org.apache.sling.engine.impl.filter.FilterPredicate;
import org.apache.sling.engine.impl.filter.FilterProcessorMBeanImpl;
import org.apache.sling.engine.impl.filter.SlingFilterChainHelper;
import org.apache.sling.engine.impl.helper.SlingFilterConfig;
import org.apache.sling.engine.impl.helper.SlingServletContext;
import org.apache.sling.engine.jmx.FilterProcessorMBean;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServletFilterManager
extends ServiceTracker<javax.servlet.Filter, javax.servlet.Filter> {
    private static final String JMX_OBJECTNAME = "jmx.objectname";
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final SlingServletContext servletContext;
    private final SlingFilterChainHelper[] filterChains;
    private final Map<Long, MBeanReg> mbeanMap = new ConcurrentHashMap<Long, MBeanReg>();
    private volatile ServiceRegistration printerRegistration;
    private static final Filter SERVICE_FILTER;

    public ServletFilterManager(BundleContext context, SlingServletContext servletContext) {
        super(context, SERVICE_FILTER, null);
        this.servletContext = servletContext;
        this.filterChains = new SlingFilterChainHelper[FilterChainType.values().length];
        for (FilterChainType type : FilterChainType.values()) {
            this.filterChains[type.ordinal()] = new SlingFilterChainHelper();
        }
    }

    public void open() {
        super.open();
        this.printerRegistration = WebConsoleConfigPrinter.register(this.context, this);
    }

    public void close() {
        if (this.printerRegistration != null) {
            WebConsoleConfigPrinter.unregister(this.printerRegistration);
            this.printerRegistration = null;
        }
        super.close();
    }

    public SlingFilterChainHelper getFilterChain(FilterChainType chain) {
        return this.filterChains[chain.ordinal()];
    }

    public FilterHandle[] getFilters(FilterChainType chain) {
        return this.getFilterChain(chain).getFilters();
    }

    public javax.servlet.Filter addingService(ServiceReference<javax.servlet.Filter> reference) {
        javax.servlet.Filter service = (javax.servlet.Filter)super.addingService(reference);
        if (service != null) {
            this.initFilter(reference, service);
        }
        return service;
    }

    public void modifiedService(ServiceReference<javax.servlet.Filter> reference, javax.servlet.Filter service) {
        String newFilterName = SlingFilterConfig.getName(reference);
        if (newFilterName.equals(this.getUsedFilterName(reference))) {
            this.removeFilterFromChains((Long)reference.getProperty("service.id"));
            this.addFilterToChains(service, reference);
        } else {
            this.destroyFilter(reference, service);
            this.initFilter(reference, service);
        }
    }

    public void removedService(ServiceReference<javax.servlet.Filter> reference, javax.servlet.Filter service) {
        if (service != null) {
            this.destroyFilter(reference, service);
            super.removedService(reference, (Object)service);
        }
    }

    private void initFilter(ServiceReference<javax.servlet.Filter> reference, javax.servlet.Filter filter) {
        String filterName = SlingFilterConfig.getName(reference);
        Long serviceId = (Long)reference.getProperty("service.id");
        try {
            try {
                Hashtable<String, String> mbeanProps = new Hashtable<String, String>();
                ((Dictionary)mbeanProps).put(JMX_OBJECTNAME, "org.apache.sling:type=engine-filter,service=" + filterName);
                MBeanReg reg = new MBeanReg();
                reg.mbean = new FilterProcessorMBeanImpl();
                reg.registration = reference.getBundle().getBundleContext().registerService(FilterProcessorMBean.class, (Object)reg.mbean, mbeanProps);
                this.mbeanMap.put(serviceId, reg);
            }
            catch (Throwable t) {
                this.log.debug("Unable to register mbean", t);
                Object reg = null;
            }
            SlingFilterConfig config = new SlingFilterConfig(this.servletContext, reference, filterName);
            filter.init((FilterConfig)config);
            this.addFilterToChains(filter, reference);
        }
        catch (ServletException ce) {
            this.log.error("Filter " + filterName + " failed to initialize", (Throwable)ce);
        }
        catch (Throwable t) {
            this.log.error("Unexpected problem initializing filter " + filterName, t);
        }
    }

    private String getUsedFilterName(ServiceReference<javax.servlet.Filter> reference) {
        int pos;
        String objectName;
        MBeanReg reg = this.mbeanMap.get(reference.getProperty("service.id"));
        if (reg != null && (objectName = (String)reg.registration.getReference().getProperty(JMX_OBJECTNAME)) != null && (pos = objectName.indexOf(",service=")) != -1) {
            return objectName.substring(pos + 9);
        }
        return null;
    }

    private void destroyFilter(ServiceReference<javax.servlet.Filter> reference, javax.servlet.Filter filter) {
        Long serviceId = (Long)reference.getProperty("service.id");
        MBeanReg reg = this.mbeanMap.remove(serviceId);
        if (reg != null) {
            reg.registration.unregister();
        }
        if (this.removeFilterFromChains(serviceId)) {
            try {
                filter.destroy();
            }
            catch (Throwable t) {
                this.log.error("Unexpected problem destroying Filter {}", (Object)filter, (Object)t);
            }
        }
    }

    private void addFilterToChains(javax.servlet.Filter filter, ServiceReference<javax.servlet.Filter> reference) {
        String orderSource;
        Long serviceId = (Long)reference.getProperty("service.id");
        MBeanReg mbeanReg = this.mbeanMap.get(serviceId);
        FilterProcessorMBeanImpl mbean = mbeanReg == null ? null : mbeanReg.mbean;
        Object orderObj = reference.getProperty("service.ranking");
        if (orderObj == null) {
            orderObj = reference.getProperty("filter.order");
            if (orderObj != null) {
                this.log.warn("Filter service {} is using deprecated property {}. Use {} instead.", new Object[]{reference, "filter.order", "service.ranking"});
                orderSource = "filter.order=" + orderObj;
                orderObj = -1 * OsgiUtil.toInteger((Object)orderObj, (int)0);
            } else {
                orderSource = "none";
            }
        } else {
            orderSource = "service.ranking=" + orderObj;
        }
        int order = orderObj instanceof Integer ? (Integer)orderObj : 0;
        String[] scopes = OsgiUtil.toStringArray((Object)reference.getProperty("sling.filter.scope"), null);
        FilterPredicate predicate = new FilterPredicate(reference);
        if (scopes == null) {
            scopes = OsgiUtil.toStringArray((Object)reference.getProperty("filter.scope"), null);
            this.log.warn("Filter service {} is using deprecated property {}. Use {} instead.", new Object[]{reference, "filter.scope", "sling.filter.scope"});
        }
        if (scopes != null && scopes.length > 0) {
            for (String scope : scopes) {
                scope = scope.toUpperCase();
                try {
                    FilterChainType type = FilterChainType.valueOf(scope.toString());
                    this.getFilterChain(type).addFilter(filter, predicate, serviceId, order, orderSource, mbean);
                    if (type != FilterChainType.COMPONENT) continue;
                    this.getFilterChain(FilterChainType.INCLUDE).addFilter(filter, predicate, serviceId, order, orderSource, mbean);
                    this.getFilterChain(FilterChainType.FORWARD).addFilter(filter, predicate, serviceId, order, orderSource, mbean);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        } else {
            this.log.warn(String.format("A Filter (Service ID %s) has been registered without a %s property.", serviceId, "sling.filter.scope"));
            this.getFilterChain(FilterChainType.REQUEST).addFilter(filter, predicate, serviceId, order, orderSource, mbean);
        }
    }

    private boolean removeFilterFromChains(Long serviceId) {
        boolean removed = false;
        for (SlingFilterChainHelper filterChain : this.filterChains) {
            removed |= filterChain.removeFilterById(serviceId);
        }
        return removed;
    }

    static {
        Filter f = null;
        try {
            f = FrameworkUtil.createFilter((String)("(&(objectClass=" + javax.servlet.Filter.class.getName() + ")(|(" + "sling.filter.scope" + "=*)(" + "filter.scope" + "=*)))"));
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            // empty catch block
        }
        SERVICE_FILTER = f;
    }

    private static final class MBeanReg {
        FilterProcessorMBeanImpl mbean;
        ServiceRegistration<FilterProcessorMBean> registration;

        private MBeanReg() {
        }
    }

    public static enum FilterChainType {
        REQUEST("Request"),
        ERROR("Error"),
        INCLUDE("Include"),
        FORWARD("Forward"),
        COMPONENT("Component");

        private final String message;

        private FilterChainType(String message) {
            this.message = message;
        }

        public String toString() {
            return this.message;
        }
    }
}

