/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.engine.impl;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Locale;
import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.engine.impl.SlingRequestProcessorImpl;
import org.apache.sling.engine.impl.StaticResponseHeader;
import org.apache.sling.engine.impl.request.RequestData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlingHttpServletResponseImpl
extends HttpServletResponseWrapper
implements SlingHttpServletResponse {
    private static final Logger LOG = LoggerFactory.getLogger(SlingHttpServletResponseImpl.class);
    private static final Exception FLUSHER_STACK_DUMMY = new Exception();
    private Exception flusherStacktrace;
    private final RequestData requestData;
    private final boolean firstSlingResponse;

    public SlingHttpServletResponseImpl(RequestData requestData, HttpServletResponse response) {
        super(response);
        this.requestData = requestData;
        boolean bl = this.firstSlingResponse = !(response instanceof SlingHttpServletResponse);
        if (this.firstSlingResponse && RequestData.getAdditionalResponseHeaders() != null) {
            for (StaticResponseHeader mapping : RequestData.getAdditionalResponseHeaders()) {
                response.addHeader(mapping.getResponseHeaderName(), mapping.getResponseHeaderValue());
            }
        }
    }

    protected final RequestData getRequestData() {
        return this.requestData;
    }

    public <AdapterType> AdapterType adaptTo(Class<AdapterType> type) {
        return this.getRequestData().adaptTo((Object)this, type);
    }

    public String encodeURL(String url) {
        String path = this.removeContextPath(url);
        path = this.makeAbsolutePath(path);
        path = this.map(path);
        return super.encodeURL(path);
    }

    public String encodeRedirectURL(String url) {
        String path = this.removeContextPath(url);
        path = this.makeAbsolutePath(path);
        path = this.map(path);
        return super.encodeRedirectURL(path);
    }

    @Deprecated
    public String encodeUrl(String url) {
        return this.encodeURL(url);
    }

    @Deprecated
    public String encodeRedirectUrl(String url) {
        return this.encodeRedirectURL(url);
    }

    public void flushBuffer() throws IOException {
        this.initFlusherStacktrace();
        super.flushBuffer();
    }

    private void initFlusherStacktrace() {
        if (this.flusherStacktrace == null) {
            this.flusherStacktrace = LOG.isDebugEnabled() ? new Exception("stacktrace where response was flushed") : FLUSHER_STACK_DUMMY;
        }
    }

    public void setStatus(int sc) {
        this.setStatus(sc, null);
    }

    public void setStatus(int sc, String msg) {
        if (this.isCommitted()) {
            if (this.flusherStacktrace != null && this.flusherStacktrace != FLUSHER_STACK_DUMMY) {
                LOG.warn("Response already committed. Failed to set status code from {} to {}.", new Object[]{this.getStatus(), sc, this.flusherStacktrace});
            } else {
                String explanation = this.flusherStacktrace != null ? "Enable debug logging to find out where the response was committed." : "The response was auto-committed due to the number of bytes written.";
                LOG.warn("Response already committed. Failed to set status code from {} to {}. {}", new Object[]{this.getStatus(), sc, explanation});
            }
        } else if (msg == null) {
            super.setStatus(sc);
        } else {
            super.setStatus(sc, msg);
        }
    }

    public void sendError(int status) throws IOException {
        this.sendError(status, null);
    }

    public void sendError(int status, String message) throws IOException {
        this.checkCommitted();
        SlingRequestProcessorImpl eh = this.getRequestData().getSlingRequestProcessor();
        eh.handleError(status, message, this.requestData.getSlingRequest(), this);
    }

    public PrintWriter getWriter() throws IOException {
        PrintWriter result = super.getWriter();
        if (this.firstSlingResponse) {
            final PrintWriter delegatee = result;
            result = new PrintWriter(result){
                private boolean isClosed;
                {
                    super(arg0);
                    this.isClosed = false;
                }

                private void checkClosed() {
                    if (this.isClosed) {
                        throw new WriterAlreadyClosedException();
                    }
                }

                @Override
                public PrintWriter append(char arg0) {
                    this.checkClosed();
                    return delegatee.append(arg0);
                }

                @Override
                public PrintWriter append(CharSequence arg0, int arg1, int arg2) {
                    this.checkClosed();
                    return delegatee.append(arg0, arg1, arg2);
                }

                @Override
                public PrintWriter append(CharSequence arg0) {
                    this.checkClosed();
                    return delegatee.append(arg0);
                }

                @Override
                public boolean checkError() {
                    this.checkClosed();
                    return delegatee.checkError();
                }

                @Override
                public void close() {
                    this.checkClosed();
                    this.isClosed = true;
                    delegatee.close();
                }

                @Override
                public void flush() {
                    this.checkClosed();
                    SlingHttpServletResponseImpl.this.initFlusherStacktrace();
                    delegatee.flush();
                }

                @Override
                public PrintWriter format(Locale arg0, String arg1, Object ... arg2) {
                    this.checkClosed();
                    return delegatee.format(arg0, arg1, arg2);
                }

                @Override
                public PrintWriter format(String arg0, Object ... arg1) {
                    this.checkClosed();
                    return delegatee.format(arg0, arg1);
                }

                @Override
                public void print(boolean arg0) {
                    this.checkClosed();
                    delegatee.print(arg0);
                }

                @Override
                public void print(char arg0) {
                    this.checkClosed();
                    delegatee.print(arg0);
                }

                @Override
                public void print(char[] arg0) {
                    this.checkClosed();
                    delegatee.print(arg0);
                }

                @Override
                public void print(double arg0) {
                    this.checkClosed();
                    delegatee.print(arg0);
                }

                @Override
                public void print(float arg0) {
                    this.checkClosed();
                    delegatee.print(arg0);
                }

                @Override
                public void print(int arg0) {
                    this.checkClosed();
                    delegatee.print(arg0);
                }

                @Override
                public void print(long arg0) {
                    this.checkClosed();
                    delegatee.print(arg0);
                }

                @Override
                public void print(Object arg0) {
                    this.checkClosed();
                    delegatee.print(arg0);
                }

                @Override
                public void print(String arg0) {
                    this.checkClosed();
                    delegatee.print(arg0);
                }

                @Override
                public PrintWriter printf(Locale arg0, String arg1, Object ... arg2) {
                    this.checkClosed();
                    return delegatee.printf(arg0, arg1, arg2);
                }

                @Override
                public PrintWriter printf(String arg0, Object ... arg1) {
                    this.checkClosed();
                    return delegatee.printf(arg0, arg1);
                }

                @Override
                public void println() {
                    this.checkClosed();
                    delegatee.println();
                }

                @Override
                public void println(boolean arg0) {
                    this.checkClosed();
                    delegatee.println(arg0);
                }

                @Override
                public void println(char arg0) {
                    this.checkClosed();
                    delegatee.println(arg0);
                }

                @Override
                public void println(char[] arg0) {
                    this.checkClosed();
                    delegatee.println(arg0);
                }

                @Override
                public void println(double arg0) {
                    this.checkClosed();
                    delegatee.println(arg0);
                }

                @Override
                public void println(float arg0) {
                    this.checkClosed();
                    delegatee.println(arg0);
                }

                @Override
                public void println(int arg0) {
                    this.checkClosed();
                    delegatee.println(arg0);
                }

                @Override
                public void println(long arg0) {
                    this.checkClosed();
                    delegatee.println(arg0);
                }

                @Override
                public void println(Object arg0) {
                    this.checkClosed();
                    delegatee.println(arg0);
                }

                @Override
                public void println(String arg0) {
                    this.checkClosed();
                    delegatee.println(arg0);
                }

                @Override
                public void write(char[] arg0, int arg1, int arg2) {
                    this.checkClosed();
                    delegatee.write(arg0, arg1, arg2);
                }

                @Override
                public void write(char[] arg0) {
                    this.checkClosed();
                    delegatee.write(arg0);
                }

                @Override
                public void write(int arg0) {
                    this.checkClosed();
                    delegatee.write(arg0);
                }

                @Override
                public void write(String arg0, int arg1, int arg2) {
                    this.checkClosed();
                    delegatee.write(arg0, arg1, arg2);
                }

                @Override
                public void write(String arg0) {
                    this.checkClosed();
                    delegatee.write(arg0);
                }
            };
        }
        return result;
    }

    public ServletOutputStream getOutputStream() throws IOException {
        ServletOutputStream outputStream = super.getOutputStream();
        if (this.firstSlingResponse) {
            return new DelegatingServletOutputStream(outputStream){

                @Override
                public void flush() throws IOException {
                    SlingHttpServletResponseImpl.this.initFlusherStacktrace();
                    super.flush();
                }
            };
        }
        return outputStream;
    }

    private void checkCommitted() {
        if (this.isCommitted()) {
            throw new IllegalStateException("Response has already been committed");
        }
    }

    private String makeAbsolutePath(String path) {
        if (path.startsWith("/")) {
            return path;
        }
        String base = this.getRequestData().getContentData().getResource().getPath();
        int lastSlash = base.lastIndexOf(47);
        path = lastSlash >= 0 ? base.substring(0, lastSlash + 1) + path : "/" + path;
        return path;
    }

    private String map(String url) {
        return this.getRequestData().getResourceResolver().map(this.getRequestData().getServletRequest(), url);
    }

    private String removeContextPath(String path) {
        String contextPath = this.getRequestData().getSlingRequest().getContextPath().concat("/");
        if (contextPath.length() > 1 && path.startsWith(contextPath)) {
            return path.substring(contextPath.length() - 1);
        }
        return path;
    }

    private abstract class DelegatingServletOutputStream
    extends ServletOutputStream {
        final ServletOutputStream delegate;

        DelegatingServletOutputStream(ServletOutputStream delegate) {
            this.delegate = delegate;
        }

        public void print(String s) throws IOException {
            this.delegate.print(s);
        }

        public void print(boolean b) throws IOException {
            this.delegate.print(b);
        }

        public void print(char c) throws IOException {
            this.delegate.print(c);
        }

        public void print(int i) throws IOException {
            this.delegate.print(i);
        }

        public void print(long l) throws IOException {
            this.delegate.print(l);
        }

        public void print(float f) throws IOException {
            this.delegate.print(f);
        }

        public void print(double d) throws IOException {
            this.delegate.print(d);
        }

        public void println() throws IOException {
            this.delegate.println();
        }

        public void println(String s) throws IOException {
            this.delegate.println(s);
        }

        public void println(boolean b) throws IOException {
            this.delegate.println(b);
        }

        public void println(char c) throws IOException {
            this.delegate.println(c);
        }

        public void println(int i) throws IOException {
            this.delegate.println(i);
        }

        public void println(long l) throws IOException {
            this.delegate.println(l);
        }

        public void println(float f) throws IOException {
            this.delegate.println(f);
        }

        public void println(double d) throws IOException {
            this.delegate.println(d);
        }

        public boolean isReady() {
            return this.delegate.isReady();
        }

        public void setWriteListener(WriteListener writeListener) {
            this.delegate.setWriteListener(writeListener);
        }

        public void write(int b) throws IOException {
            this.delegate.write(b);
        }

        public void write(byte[] b) throws IOException {
            this.delegate.write(b);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.delegate.write(b, off, len);
        }

        public void flush() throws IOException {
            this.delegate.flush();
        }

        public void close() throws IOException {
            this.delegate.close();
        }
    }

    public static class WriterAlreadyClosedException
    extends IllegalStateException {
    }
}

