/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.engine.impl;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.management.NotCompliantMBeanException;
import javax.servlet.GenericServlet;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.sling.api.adapter.AdapterManager;
import org.apache.sling.api.request.SlingRequestEvent;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.servlets.ServletResolver;
import org.apache.sling.auth.core.AuthenticationSupport;
import org.apache.sling.commons.mime.MimeTypeService;
import org.apache.sling.engine.SlingRequestProcessor;
import org.apache.sling.engine.impl.RequestProcessorMBeanImpl;
import org.apache.sling.engine.impl.SlingHttpContext;
import org.apache.sling.engine.impl.SlingRequestProcessorImpl;
import org.apache.sling.engine.impl.StaticResponseHeader;
import org.apache.sling.engine.impl.filter.ServletFilterManager;
import org.apache.sling.engine.impl.helper.ClientAbortException;
import org.apache.sling.engine.impl.helper.RequestListenerManager;
import org.apache.sling.engine.impl.helper.SlingServletContext;
import org.apache.sling.engine.impl.request.RequestData;
import org.apache.sling.engine.jmx.RequestProcessorMBean;
import org.apache.sling.engine.servlets.ErrorHandler;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.Version;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.osgi.service.component.propertytypes.ServiceDescription;
import org.osgi.service.component.propertytypes.ServiceVendor;
import org.osgi.service.http.context.ServletContextHelper;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(configurationPid={"org.apache.sling.engine.impl.SlingMainServlet"}, service={})
@ServiceDescription(value="Sling Servlet")
@ServiceVendor(value="The Apache Software Foundation")
@Designate(ocd=Config.class)
public class SlingMainServlet
extends GenericServlet {
    public static final String PID = "org.apache.sling.engine.impl.SlingMainServlet";
    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    private volatile AdapterManager adapterManager;
    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    private volatile RequestListenerManager requestListenerManager;
    private BundleContext bundleContext;
    private final Logger log = LoggerFactory.getLogger(SlingMainServlet.class);
    private static final String SLING_ROOT = "/";
    public static final String SERVLET_CONTEXT_NAME = "org.apache.sling";
    static String PRODUCT_NAME = "ApacheSling";
    private volatile SlingServletContext slingServletContext;
    private volatile String productInfo = PRODUCT_NAME;
    private volatile String serverInfo = PRODUCT_NAME;
    private volatile boolean allowTrace;
    private final SlingHttpContext slingHttpContext = new SlingHttpContext();
    private volatile ServletFilterManager filterManager;
    private final SlingRequestProcessorImpl requestProcessor = new SlingRequestProcessorImpl();
    private volatile ServiceRegistration<SlingRequestProcessor> requestProcessorRegistration;
    private volatile ServiceRegistration<RequestProcessorMBean> requestProcessorMBeanRegistration;
    private volatile ServiceRegistration<ServletContextHelper> contextRegistration;
    private volatile ServiceRegistration<Servlet> servletRegistration;
    private volatile String configuredServerInfo;
    private final CountDownLatch asyncActivation = new CountDownLatch(1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(ServletRequest req, ServletResponse res) throws ServletException {
        if (!SlingMainServlet.awaitQuietly(this.asyncActivation, 30)) {
            throw new ServletException("Servlet not initialized after 30 seconds");
        }
        if (req instanceof HttpServletRequest && res instanceof HttpServletResponse) {
            HttpServletRequest request = (HttpServletRequest)req;
            String threadName = this.setThreadName(request);
            RequestListenerManager localRLM = this.requestListenerManager;
            if (localRLM != null) {
                localRLM.sendEvent(request, SlingRequestEvent.EventType.EVENT_INIT);
            }
            ResourceResolver resolver = null;
            try {
                if (!this.allowTrace && "TRACE".equals(request.getMethod())) {
                    HttpServletResponse response = (HttpServletResponse)res;
                    response.setStatus(405);
                    response.setHeader("Allow", "GET, HEAD, POST, PUT, DELETE, OPTIONS");
                    return;
                }
                Object resolverObject = request.getAttribute("org.apache.sling.auth.core.ResourceResolver");
                resolver = resolverObject instanceof ResourceResolver ? (ResourceResolver)resolverObject : null;
                this.requestProcessor.doProcessRequest(request, (HttpServletResponse)res, resolver);
            }
            catch (ClientAbortException cae) {
                this.log.debug("service: ClientAbortException, probable cause is client aborted request or network problem", (Throwable)cae);
            }
            catch (Throwable t) {
                this.log.error("service: Uncaught Problem handling the request", t);
            }
            finally {
                if (resolver != null) {
                    resolver.close();
                }
                if (localRLM != null) {
                    localRLM.sendEvent(request, SlingRequestEvent.EventType.EVENT_DESTROY);
                }
                if (threadName != null) {
                    Thread.currentThread().setName(threadName);
                }
            }
        } else {
            throw new ServletException("Apache Sling must be run in an HTTP servlet environment.");
        }
    }

    private static boolean awaitQuietly(CountDownLatch latch, int seconds) {
        try {
            return latch.await(seconds, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
    }

    private void setProductInfo() {
        Dictionary props = this.bundleContext.getBundle().getHeaders();
        Version bundleVersion = Version.parseVersion((String)((String)props.get("Bundle-Version")));
        String productVersion = bundleVersion.getMajor() + "." + bundleVersion.getMinor();
        this.productInfo = PRODUCT_NAME + SLING_ROOT + productVersion;
        this.setServerInfo();
    }

    public String getServerInfo() {
        return this.serverInfo;
    }

    private void setServerInfo() {
        if (this.configuredServerInfo != null) {
            this.serverInfo = this.configuredServerInfo;
        } else {
            String containerProductInfo;
            if (this.getServletConfig() == null || this.getServletContext() == null) {
                containerProductInfo = "unregistered";
            } else {
                String containerInfo = this.getServletContext().getServerInfo();
                if (containerInfo != null && containerInfo.length() > 0) {
                    int lbrace = containerInfo.indexOf(40);
                    if (lbrace < 0) {
                        lbrace = containerInfo.length();
                    }
                    containerProductInfo = containerInfo.substring(0, lbrace).trim();
                } else {
                    containerProductInfo = "unknown";
                }
            }
            this.serverInfo = String.format("%s (%s, %s %s, %s %s %s)", this.productInfo, containerProductInfo, System.getProperty("java.vm.name"), System.getProperty("java.version"), System.getProperty("os.name"), System.getProperty("os.version"), System.getProperty("os.arch"));
        }
        this.requestProcessor.setServerInfo(this.serverInfo);
    }

    @Modified
    protected void modified(Config config) {
        this.setup(config);
    }

    private Dictionary<String, Object> getServletContextRegistrationProps(String servletName) {
        Hashtable<String, Object> servletConfig = new Hashtable<String, Object>();
        ((Dictionary)servletConfig).put("osgi.http.whiteboard.context.select", "(osgi.http.whiteboard.context.name=org.apache.sling)");
        ((Dictionary)servletConfig).put("osgi.http.whiteboard.servlet.pattern", SLING_ROOT);
        ((Dictionary)servletConfig).put("osgi.http.whiteboard.servlet.name", servletName);
        ((Dictionary)servletConfig).put("service.description", "Apache Sling Engine Main Servlet");
        ((Dictionary)servletConfig).put("service.vendor", "The Apache Software Foundation");
        return servletConfig;
    }

    protected void setup(Config config) {
        String servletName;
        String[] props = config.sling_additional_response_headers();
        if (props != null) {
            ArrayList<StaticResponseHeader> mappings = new ArrayList<StaticResponseHeader>(props.length);
            for (String prop : props) {
                if (prop == null || prop.trim().length() <= 0) continue;
                try {
                    StaticResponseHeader mapping = new StaticResponseHeader(prop.trim());
                    mappings.add(mapping);
                }
                catch (IllegalArgumentException iae) {
                    this.log.info("configure: Ignoring '{}': {}", (Object)prop, (Object)iae.getMessage());
                }
            }
            RequestData.setAdditionalResponseHeaders(mappings);
        }
        this.configuredServerInfo = config.sling_serverinfo() != null && !config.sling_serverinfo().isEmpty() ? config.sling_serverinfo() : null;
        this.setProductInfo();
        this.allowTrace = config.sling_trace_allow();
        RequestData.setMaxIncludeCounter(config.sling_max_inclusions());
        RequestData.setMaxCallCounter(config.sling_max_calls());
        RequestData.setSlingMainServlet(this);
        if (this.contextRegistration == null) {
            Hashtable<String, String> contextProperties = new Hashtable<String, String>();
            ((Dictionary)contextProperties).put("osgi.http.whiteboard.context.name", SERVLET_CONTEXT_NAME);
            ((Dictionary)contextProperties).put("osgi.http.whiteboard.context.path", SLING_ROOT);
            ((Dictionary)contextProperties).put("service.description", "Apache Sling Engine Servlet Context Helper");
            ((Dictionary)contextProperties).put("service.vendor", "The Apache Software Foundation");
            this.contextRegistration = this.bundleContext.registerService(ServletContextHelper.class, (Object)this.slingHttpContext, contextProperties);
        }
        if ((servletName = config.servlet_name()) == null || servletName.isEmpty()) {
            servletName = this.productInfo;
        }
        if (this.servletRegistration == null) {
            this.servletRegistration = this.bundleContext.registerService(Servlet.class, (Object)this, this.getServletContextRegistrationProps(servletName));
        } else if (!servletName.equals(this.servletRegistration.getReference().getProperty("osgi.http.whiteboard.servlet.name"))) {
            this.servletRegistration.setProperties(this.getServletContextRegistrationProps(servletName));
        }
    }

    @Activate
    protected void activate(BundleContext bundleContext, Config config) {
        this.bundleContext = bundleContext;
        this.setup(config);
    }

    public void init() throws ServletException {
        this.setServerInfo();
        this.log.info("{} ready to serve requests", (Object)this.getServerInfo());
        if (this.slingServletContext == null) {
            this.asyncSlingServletContextRegistration();
        }
    }

    private void asyncSlingServletContextRegistration() {
        Thread thread = new Thread("SlingServletContext registration"){

            @Override
            public void run() {
                try {
                    SlingMainServlet.this.slingServletContext = new SlingServletContext(SlingMainServlet.this.bundleContext, SlingMainServlet.this);
                    SlingMainServlet.this.slingServletContext.register(SlingMainServlet.this.bundleContext);
                    SlingMainServlet.this.filterManager = new ServletFilterManager(SlingMainServlet.this.bundleContext, SlingMainServlet.this.slingServletContext);
                    SlingMainServlet.this.filterManager.open();
                    SlingMainServlet.this.requestProcessor.setFilterManager(SlingMainServlet.this.filterManager);
                    try {
                        Hashtable<String, String> mbeanProps = new Hashtable<String, String>();
                        ((Dictionary)mbeanProps).put("jmx.objectname", "org.apache.sling:type=engine,service=RequestProcessor");
                        RequestProcessorMBeanImpl mbean = new RequestProcessorMBeanImpl();
                        SlingMainServlet.this.requestProcessorMBeanRegistration = SlingMainServlet.this.bundleContext.registerService(RequestProcessorMBean.class, (Object)mbean, mbeanProps);
                        SlingMainServlet.this.requestProcessor.setMBean(mbean);
                    }
                    catch (NotCompliantMBeanException t) {
                        SlingMainServlet.this.log.debug("Unable to register mbean");
                    }
                    Hashtable<String, String> srpProps = new Hashtable<String, String>();
                    srpProps.put("service.vendor", "The Apache Software Foundation");
                    srpProps.put("service.description", "Sling Request Processor");
                    SlingMainServlet.this.requestProcessorRegistration = SlingMainServlet.this.bundleContext.registerService(SlingRequestProcessor.class, (Object)SlingMainServlet.this.requestProcessor, srpProps);
                }
                finally {
                    SlingMainServlet.this.asyncActivation.countDown();
                }
            }
        };
        thread.setDaemon(true);
        thread.start();
    }

    @Deactivate
    protected void deactivate() {
        if (!SlingMainServlet.awaitQuietly(this.asyncActivation, 30)) {
            this.log.warn("Async activation did not complete within 30 seconds of 'deactivate' being called. There is a risk that objects are not properly destroyed.");
        }
        this.unregisterSlingServletContext();
        if (this.contextRegistration != null) {
            this.contextRegistration.unregister();
            this.contextRegistration = null;
        }
        if (this.servletRegistration != null) {
            this.servletRegistration.unregister();
            this.servletRegistration = null;
        }
        RequestData.setSlingMainServlet(null);
        this.bundleContext = null;
        this.log.info(this.getServerInfo() + " shut down");
    }

    private void unregisterSlingServletContext() {
        if (this.requestProcessorRegistration != null) {
            this.requestProcessorRegistration.unregister();
            this.requestProcessorRegistration = null;
        }
        if (this.requestProcessorMBeanRegistration != null) {
            this.requestProcessorMBeanRegistration.unregister();
            this.requestProcessorMBeanRegistration = null;
        }
        if (this.filterManager != null) {
            this.requestProcessor.setFilterManager(null);
            this.filterManager.close();
            this.filterManager = null;
        }
        if (this.slingServletContext != null) {
            this.slingServletContext.dispose();
            this.slingServletContext = null;
        }
    }

    @Reference(name="ErrorHandler", cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, unbind="unsetErrorHandler")
    void setErrorHandler(ErrorHandler errorHandler) {
        this.requestProcessor.setErrorHandler(errorHandler);
    }

    void unsetErrorHandler(ErrorHandler errorHandler) {
        this.requestProcessor.unsetErrorHandler(errorHandler);
    }

    @Reference(name="ServletResolver", cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, unbind="unsetServletResolver")
    public void setServletResolver(ServletResolver servletResolver) {
        this.requestProcessor.setServletResolver(servletResolver);
    }

    public void unsetServletResolver(ServletResolver servletResolver) {
        this.requestProcessor.unsetServletResolver(servletResolver);
    }

    @Reference(name="MimeTypeService", cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, unbind="unsetMimeTypeService")
    public void setMimeTypeService(MimeTypeService mimeTypeService) {
        this.slingHttpContext.setMimeTypeService(mimeTypeService);
    }

    public void unsetMimeTypeService(MimeTypeService mimeTypeService) {
        this.slingHttpContext.unsetMimeTypeService(mimeTypeService);
    }

    @Reference(name="AuthenticationSupport", cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, unbind="unsetAuthenticationSupport")
    public void setAuthenticationSupport(AuthenticationSupport authenticationSupport) {
        this.slingHttpContext.setAuthenticationSupport(authenticationSupport);
    }

    public void unsetAuthenticationSupport(AuthenticationSupport authenticationSupport) {
        this.slingHttpContext.unsetAuthenticationSupport(authenticationSupport);
    }

    public String getMimeType(String name) {
        return this.slingHttpContext.getMimeType(name);
    }

    public <Type> Type adaptTo(Object object, Class<Type> type) {
        AdapterManager adapterManager = this.adapterManager;
        if (adapterManager != null) {
            return (Type)adapterManager.getAdapter(object, type);
        }
        return null;
    }

    private String setThreadName(HttpServletRequest request) {
        Thread thread = Thread.currentThread();
        String oldThreadName = thread.getName();
        StringBuilder buf = new StringBuilder();
        buf.append(request.getRemoteAddr());
        buf.append(" [").append(System.currentTimeMillis()).append("] ");
        buf.append(request.getMethod()).append(' ');
        buf.append(request.getRequestURI()).append(' ');
        buf.append(request.getProtocol());
        thread.setName(buf.toString());
        return oldThreadName;
    }

    @ObjectClassDefinition(name="Apache Sling Main Servlet", description="Main processor of the Sling framework controlling all aspects of processing requests inside of Sling, namely authentication, resource resolution, servlet/script resolution and execution of servlets and scripts.")
    public static @interface Config {
        @AttributeDefinition(name="Number of Calls per Request", description="Defines the maximum number of Servlet and Script calls while processing a single client request. This number should be high enough to not limit request processing artificially. On the other hand it should not be too high to allow the mechanism to limit the resources required to process a request in case of errors. The default value is 1000.")
        public int sling_max_calls() default 1000;

        @AttributeDefinition(name="Recursion Depth", description="The maximum number of recursive Servlet and Script calls while processing a single client request. This number should not be too high, otherwise StackOverflowErrors may occurr in case of erroneous scripts and servlets. The default value is 50. ")
        public int sling_max_inclusions() default 50;

        @AttributeDefinition(name="Allow the HTTP TRACE method", description="If set to true, the HTTP TRACE method will be enabled. By default the HTTP TRACE methods is disabled as it can be used in Cross Site Scripting attacks on HTTP servers.")
        public boolean sling_trace_allow() default false;

        @AttributeDefinition(name="Number of Requests to Record", description="Defines the number of requests that internally recorded for display on the \"Recent Requests\" Web Console page. If this value is less than or equal to zero, no requests are internally kept. The default value is 20. ")
        public int sling_max_record_requests() default 20;

        @AttributeDefinition(name="Recorded Request Path Patterns", description="One or more regular expressions which limit the requests which are stored by the \"Recent Requests\" Web Console page.")
        public String[] sling_store_pattern_requests();

        @AttributeDefinition(name="Server Info", description="The server info returned by Sling. If this field is left empty, Sling generates a default into.")
        public String sling_serverinfo();

        @AttributeDefinition(name="Additional response headers", description="Provides mappings for additional response headers Each entry is of the form 'bundleId [ \":\" responseHeaderName ] \"=\" responseHeaderValue'")
        public String[] sling_additional_response_headers() default {"X-Content-Type-Options=nosniff", "X-Frame-Options=SAMEORIGIN"};

        @AttributeDefinition(name="Servlet Name", description="Optional name for the Sling main servlet registered by this component")
        public String servlet_name();
    }
}

