/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.engine.impl;

import java.io.IOException;
import java.net.URL;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.sling.api.request.RequestProgressTracker;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.auth.core.AuthenticationSupport;
import org.apache.sling.commons.mime.MimeTypeService;
import org.apache.sling.engine.impl.parameters.ParameterSupport;
import org.apache.sling.engine.impl.request.SlingRequestProgressTracker;
import org.osgi.service.http.context.ServletContextHelper;
import org.osgi.service.http.whiteboard.annotations.RequireHttpWhiteboard;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequireHttpWhiteboard
class SlingHttpContext
extends ServletContextHelper {
    private final Logger log = LoggerFactory.getLogger(SlingHttpContext.class);
    private MimeTypeService mimeTypeService;
    private AuthenticationSupport authenticationSupport;

    SlingHttpContext() {
    }

    public void setMimeTypeService(MimeTypeService mimeTypeService) {
        this.mimeTypeService = mimeTypeService;
    }

    public void unsetMimeTypeService(MimeTypeService mimeTypeService) {
        if (this.mimeTypeService == mimeTypeService) {
            this.mimeTypeService = null;
        }
    }

    public void setAuthenticationSupport(AuthenticationSupport authenticationSupport) {
        this.authenticationSupport = authenticationSupport;
    }

    public void unsetAuthenticationSupport(AuthenticationSupport authenticationSupport) {
        if (this.authenticationSupport == authenticationSupport) {
            this.authenticationSupport = null;
        }
    }

    public String getMimeType(String name) {
        MimeTypeService mtservice = this.mimeTypeService;
        if (mtservice != null) {
            return mtservice.getMimeType(name);
        }
        this.log.debug("getMimeType: MimeTypeService not available, cannot resolve mime type for {}", (Object)name);
        return null;
    }

    public URL getResource(String name) {
        return null;
    }

    public boolean handleSecurity(HttpServletRequest request, HttpServletResponse response) throws IOException {
        SlingRequestProgressTracker t = new SlingRequestProgressTracker(request);
        request.setAttribute(RequestProgressTracker.class.getName(), (Object)t);
        String timerName = "handleSecurity";
        t.startTimer("handleSecurity");
        AuthenticationSupport authenticator = this.authenticationSupport;
        if (authenticator != null) {
            request = ParameterSupport.getParameterSupportRequestWrapper(request);
            boolean result = authenticator.handleSecurity(request, response);
            t.logTimer("handleSecurity", "authenticator {0} returns {1}", authenticator, result);
            return result;
        }
        this.log.error("handleSecurity: AuthenticationSupport service missing. Cannot authenticate request.");
        this.log.error("handleSecurity: Possible reason is missing Repository service. Check AuthenticationSupport dependencies.");
        response.sendError(503, "AuthenticationSupport service missing. Cannot authenticate request.");
        response.flushBuffer();
        return false;
    }

    public void finishSecurity(HttpServletRequest request, HttpServletResponse response) {
        ResourceResolver resolver;
        super.finishSecurity(request, response);
        Object resolverObject = request.getAttribute("org.apache.sling.auth.core.ResourceResolver");
        ResourceResolver resourceResolver = resolver = resolverObject instanceof ResourceResolver ? (ResourceResolver)resolverObject : null;
        if (resolver != null) {
            resolver.close();
        }
    }
}

