/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.engine.impl;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.servlet.DispatcherType;
import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.apache.sling.api.SlingException;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.engine.impl.ContentTypeHeaderState;
import org.apache.sling.engine.impl.SlingRequestProcessorImpl;
import org.apache.sling.engine.impl.StaticResponseHeader;
import org.apache.sling.engine.impl.request.RequestData;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlingHttpServletResponseImpl
extends HttpServletResponseWrapper
implements SlingHttpServletResponse {
    private static final String CALL_STACK_MESSAGE = "Call stack causing the content type override violation: ";
    private static final Logger LOG = LoggerFactory.getLogger(SlingHttpServletResponseImpl.class);
    private static final String REGEX_TIMER_START = "TIMER_START\\{([^}]+)\\}";
    private static final String REGEX_TIMER_END = "TIMER_END\\{\\d+,([^}]+)\\}";
    private static final String TIMER_SEPARATOR = " -> ";
    private static final Exception FLUSHER_STACK_DUMMY = new Exception();
    private static final int MAX_NR_OF_MESSAGES = 500;
    private Exception flusherStacktrace;
    private final RequestData requestData;
    private final boolean firstSlingResponse;

    public SlingHttpServletResponseImpl(RequestData requestData, HttpServletResponse response) {
        super(response);
        this.requestData = requestData;
        boolean bl = this.firstSlingResponse = !(response instanceof SlingHttpServletResponse);
        if (this.firstSlingResponse) {
            for (StaticResponseHeader mapping : requestData.getSlingRequestProcessor().getAdditionalResponseHeaders()) {
                response.addHeader(mapping.getResponseHeaderName(), mapping.getResponseHeaderValue());
            }
        }
    }

    protected final RequestData getRequestData() {
        return this.requestData;
    }

    public <AdapterType> AdapterType adaptTo(Class<AdapterType> type) {
        return this.getRequestData().getSlingRequestProcessor().adaptTo((Object)this, type);
    }

    public String encodeURL(String url) {
        String path = this.removeContextPath(url);
        path = this.makeAbsolutePath(path);
        path = this.map(path);
        return super.encodeURL(path);
    }

    public String encodeRedirectURL(String url) {
        String path = this.removeContextPath(url);
        path = this.makeAbsolutePath(path);
        path = this.map(path);
        return super.encodeRedirectURL(path);
    }

    @Deprecated
    public String encodeUrl(String url) {
        return this.encodeURL(url);
    }

    @Deprecated
    public String encodeRedirectUrl(String url) {
        return this.encodeRedirectURL(url);
    }

    public void flushBuffer() throws IOException {
        this.initFlusherStacktrace();
        super.flushBuffer();
    }

    private void initFlusherStacktrace() {
        if (this.flusherStacktrace == null) {
            this.flusherStacktrace = LOG.isDebugEnabled() ? new Exception("stacktrace where response was flushed") : FLUSHER_STACK_DUMMY;
        }
    }

    private boolean isInclude() {
        return this.requestData.getDispatchingInfo() != null && this.requestData.getDispatchingInfo().getType() == DispatcherType.INCLUDE;
    }

    private boolean isProtectHeadersOnInclude() {
        return this.requestData.getDispatchingInfo() != null && this.requestData.getDispatchingInfo().isProtectHeadersOnInclude();
    }

    private boolean isCheckContentTypeOnInclude() {
        return this.requestData.getDispatchingInfo() != null && this.requestData.getDispatchingInfo().isCheckContentTypeOnInclude();
    }

    public void setStatus(int sc) {
        if (this.isProtectHeadersOnInclude()) {
            return;
        }
        this.setStatus(sc, null);
    }

    public void setStatus(int sc, String msg) {
        if (this.isProtectHeadersOnInclude()) {
            return;
        }
        if (this.isCommitted()) {
            if (this.flusherStacktrace != null && this.flusherStacktrace != FLUSHER_STACK_DUMMY) {
                LOG.warn("Response already committed. Failed to set status code from {} to {}.", new Object[]{this.getStatus(), sc, this.flusherStacktrace});
            } else {
                String explanation = this.flusherStacktrace != null ? "Enable debug logging to find out where the response was committed." : "The response was auto-committed due to the number of bytes written.";
                LOG.warn("Response already committed. Failed to set status code from {} to {}. {}", new Object[]{this.getStatus(), sc, explanation});
            }
        } else if (msg == null) {
            super.setStatus(sc);
        } else {
            super.setStatus(sc, msg);
        }
    }

    public void reset() {
        if (!this.isProtectHeadersOnInclude()) {
            super.reset();
        } else if (this.getResponse().isCommitted()) {
            this.getResponse().reset();
        }
    }

    public void setContentLength(int len) {
        if (!this.isProtectHeadersOnInclude()) {
            super.setContentLength(len);
        }
    }

    public void setContentLengthLong(long len) {
        if (!this.isProtectHeadersOnInclude()) {
            super.setContentLengthLong(len);
        }
    }

    public void setLocale(Locale loc) {
        if (!this.isProtectHeadersOnInclude()) {
            super.setLocale(loc);
        }
    }

    public void setBufferSize(int size) {
        if (!this.isProtectHeadersOnInclude()) {
            super.setBufferSize(size);
        }
    }

    public void addCookie(Cookie cookie) {
        if (!this.isProtectHeadersOnInclude()) {
            super.addCookie(cookie);
        }
    }

    public void addDateHeader(String name, long value) {
        if (!this.isProtectHeadersOnInclude()) {
            super.addDateHeader(name, value);
        }
    }

    public void addHeader(String name, String value) {
        if (!this.isProtectHeadersOnInclude()) {
            super.addHeader(name, value);
        }
    }

    public void addIntHeader(String name, int value) {
        if (!this.isProtectHeadersOnInclude()) {
            super.addIntHeader(name, value);
        }
    }

    public void sendRedirect(String location) throws IOException {
        if (!this.isProtectHeadersOnInclude()) {
            super.sendRedirect(location);
        }
    }

    public void setDateHeader(String name, long value) {
        if (!this.isProtectHeadersOnInclude()) {
            super.setDateHeader(name, value);
        }
    }

    public void setHeader(String name, String value) {
        if (!this.isProtectHeadersOnInclude()) {
            super.setHeader(name, value);
        }
    }

    public void setIntHeader(String name, int value) {
        if (!this.isProtectHeadersOnInclude()) {
            super.setIntHeader(name, value);
        }
    }

    private String getCurrentStackTrace() {
        StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
        StringBuilder stackTraceBuilder = new StringBuilder();
        for (StackTraceElement element : stackTraceElements) {
            stackTraceBuilder.append(element.toString()).append(System.lineSeparator());
        }
        return stackTraceBuilder.toString();
    }

    public void setContentType(String type) {
        if (super.getResponse().isCommitted() || !this.isInclude()) {
            super.setContentType(type);
        } else {
            Optional<String> message = this.checkContentTypeOverride(type);
            if (message.isPresent()) {
                if (this.isCheckContentTypeOnInclude()) {
                    this.requestData.getRequestProgressTracker().log("ERROR: " + message.get());
                    LOG.error(CALL_STACK_MESSAGE + this.getCurrentStackTrace());
                    throw new ContentTypeChangeException(message.get());
                }
                if (this.isProtectHeadersOnInclude()) {
                    LOG.error(message.get());
                    LOG.error(CALL_STACK_MESSAGE + this.getCurrentStackTrace());
                    this.requestData.getRequestProgressTracker().log("ERROR: " + message.get());
                    return;
                }
                LOG.warn(message.get());
                LOG.warn(CALL_STACK_MESSAGE + this.getCurrentStackTrace());
                this.requestData.getRequestProgressTracker().log("WARN: " + message.get());
                super.setContentType(type);
            } else {
                super.setContentType(type);
            }
        }
    }

    protected Optional<String> checkContentTypeOverride(@Nullable String contentType) {
        if (this.requestData.getSlingRequestProcessor().getContentTypeHeaderState() == ContentTypeHeaderState.VIOLATED) {
            return Optional.empty();
        }
        String currentContentType = this.getContentType();
        if (contentType == null) {
            this.requestData.getSlingRequestProcessor().setContentTypeHeaderState(ContentTypeHeaderState.VIOLATED);
            return Optional.of(this.getMessage(currentContentType, null));
        }
        Optional<String> currentMime = currentContentType == null ? Optional.of("null") : Arrays.stream(currentContentType.split(";")).findFirst();
        Optional<String> setMime = Arrays.stream(contentType.split(";")).findFirst();
        if (currentMime.isPresent() && setMime.isPresent() && !currentMime.get().equals(setMime.get())) {
            this.requestData.getSlingRequestProcessor().setContentTypeHeaderState(ContentTypeHeaderState.VIOLATED);
            return Optional.of(this.getMessage(currentContentType, contentType));
        }
        return Optional.empty();
    }

    private List<String> getLastMessagesOfProgressTracker() {
        int nrOfOriginalMessages = 0;
        boolean gotCut = false;
        Iterator messagesIterator = this.requestData.getRequestProgressTracker().getMessages();
        LinkedList<String> lastMessages = new LinkedList<String>();
        while (messagesIterator.hasNext()) {
            ++nrOfOriginalMessages;
            if (gotCut || lastMessages.size() >= 500) {
                lastMessages.removeFirst();
                gotCut = true;
            }
            lastMessages.add((String)messagesIterator.next());
        }
        if (gotCut) {
            lastMessages.addFirst("... cut " + (nrOfOriginalMessages - 500) + " messages ...");
        }
        return lastMessages;
    }

    private String findUnmatchedTimerStarts() {
        Iterator<String> messages = this.getLastMessagesOfProgressTracker().iterator();
        ArrayList<String> unmatchedStarts = new ArrayList<String>();
        ArrayDeque<String> timerDeque = new ArrayDeque<String>();
        Pattern startPattern = Pattern.compile(REGEX_TIMER_START);
        Pattern endPattern = Pattern.compile(REGEX_TIMER_END);
        while (messages.hasNext()) {
            String message = messages.next();
            Matcher startMatcher = startPattern.matcher(message);
            Matcher endMatcher = endPattern.matcher(message);
            if (startMatcher.find()) {
                timerDeque.push(startMatcher.group(1));
                continue;
            }
            if (!endMatcher.find()) continue;
            String endTimer = endMatcher.group(1);
            if (!timerDeque.isEmpty() && ((String)timerDeque.peek()).equals(endTimer)) {
                timerDeque.pop();
                continue;
            }
            unmatchedStarts.add(endTimer);
        }
        while (timerDeque.size() > 1) {
            unmatchedStarts.add((String)timerDeque.pop());
        }
        StringBuilder sb = new StringBuilder();
        for (String script : unmatchedStarts) {
            sb.append(script).append(TIMER_SEPARATOR);
        }
        String ret = sb.toString();
        if (ret.endsWith(TIMER_SEPARATOR)) {
            ret = ret.substring(0, ret.length() - TIMER_SEPARATOR.length());
        }
        return ret;
    }

    private String getMessage(@Nullable String currentContentType, @Nullable String setContentType) {
        String unmatchedStartTimers = this.findUnmatchedTimerStarts();
        String allMessages = this.getLastMessagesOfProgressTracker().stream().collect(Collectors.joining(System.lineSeparator()));
        if (!this.isCheckContentTypeOnInclude()) {
            return String.format("Servlet %s tried to override the 'Content-Type' header from '%s' to '%s'. This is a violation of the RequestDispatcher.include() contract - https://jakarta.ee/specifications/servlet/4.0/apidocs/javax/servlet/requestdispatcher#include-javax.servlet.ServletRequest-javax.servlet.ServletResponse-. , Include stack: %s. All RequestProgressTracker messages: %s", this.requestData.getActiveServletName(), currentContentType, setContentType, unmatchedStartTimers, allMessages);
        }
        return String.format("Servlet %s tried to override the 'Content-Type' header from '%s' to '%s', however the %s forbids this via the %s configuration property. This is a violation of the RequestDispatcher.include() contract - https://jakarta.ee/specifications/servlet/4.0/apidocs/javax/servlet/requestdispatcher#include-javax.servlet.ServletRequest-javax.servlet.ServletResponse-. , Include stack: %s. All RequestProgressTracker messages: %s", this.requestData.getActiveServletName(), currentContentType, setContentType, "org.apache.sling.engine.impl.SlingMainServlet", "sling.includes.checkcontenttype", unmatchedStartTimers, allMessages);
    }

    public void sendError(int status) throws IOException {
        if (!this.isProtectHeadersOnInclude()) {
            this.sendError(status, null);
        }
    }

    public void sendError(int status, String message) throws IOException {
        if (!this.isProtectHeadersOnInclude()) {
            this.checkCommitted();
            SlingRequestProcessorImpl eh = this.getRequestData().getSlingRequestProcessor();
            eh.handleError(status, message, this.requestData.getSlingRequest(), this);
        }
    }

    public PrintWriter getWriter() throws IOException {
        PrintWriter result = super.getWriter();
        if (this.firstSlingResponse) {
            final PrintWriter delegatee = result;
            result = new PrintWriter(result){
                private boolean isClosed;
                {
                    super(arg0);
                    this.isClosed = false;
                }

                private void checkClosed() {
                    if (this.isClosed) {
                        throw new WriterAlreadyClosedException();
                    }
                }

                @Override
                public PrintWriter append(char arg0) {
                    this.checkClosed();
                    return delegatee.append(arg0);
                }

                @Override
                public PrintWriter append(CharSequence arg0, int arg1, int arg2) {
                    this.checkClosed();
                    return delegatee.append(arg0, arg1, arg2);
                }

                @Override
                public PrintWriter append(CharSequence arg0) {
                    this.checkClosed();
                    return delegatee.append(arg0);
                }

                @Override
                public boolean checkError() {
                    this.checkClosed();
                    return delegatee.checkError();
                }

                @Override
                public void close() {
                    this.checkClosed();
                    this.isClosed = true;
                    delegatee.close();
                }

                @Override
                public void flush() {
                    this.checkClosed();
                    SlingHttpServletResponseImpl.this.initFlusherStacktrace();
                    delegatee.flush();
                }

                @Override
                public PrintWriter format(Locale arg0, String arg1, Object ... arg2) {
                    this.checkClosed();
                    return delegatee.format(arg0, arg1, arg2);
                }

                @Override
                public PrintWriter format(String arg0, Object ... arg1) {
                    this.checkClosed();
                    return delegatee.format(arg0, arg1);
                }

                @Override
                public void print(boolean arg0) {
                    this.checkClosed();
                    delegatee.print(arg0);
                }

                @Override
                public void print(char arg0) {
                    this.checkClosed();
                    delegatee.print(arg0);
                }

                @Override
                public void print(char[] arg0) {
                    this.checkClosed();
                    delegatee.print(arg0);
                }

                @Override
                public void print(double arg0) {
                    this.checkClosed();
                    delegatee.print(arg0);
                }

                @Override
                public void print(float arg0) {
                    this.checkClosed();
                    delegatee.print(arg0);
                }

                @Override
                public void print(int arg0) {
                    this.checkClosed();
                    delegatee.print(arg0);
                }

                @Override
                public void print(long arg0) {
                    this.checkClosed();
                    delegatee.print(arg0);
                }

                @Override
                public void print(Object arg0) {
                    this.checkClosed();
                    delegatee.print(arg0);
                }

                @Override
                public void print(String arg0) {
                    this.checkClosed();
                    delegatee.print(arg0);
                }

                @Override
                public PrintWriter printf(Locale arg0, String arg1, Object ... arg2) {
                    this.checkClosed();
                    return delegatee.printf(arg0, arg1, arg2);
                }

                @Override
                public PrintWriter printf(String arg0, Object ... arg1) {
                    this.checkClosed();
                    return delegatee.printf(arg0, arg1);
                }

                @Override
                public void println() {
                    this.checkClosed();
                    delegatee.println();
                }

                @Override
                public void println(boolean arg0) {
                    this.checkClosed();
                    delegatee.println(arg0);
                }

                @Override
                public void println(char arg0) {
                    this.checkClosed();
                    delegatee.println(arg0);
                }

                @Override
                public void println(char[] arg0) {
                    this.checkClosed();
                    delegatee.println(arg0);
                }

                @Override
                public void println(double arg0) {
                    this.checkClosed();
                    delegatee.println(arg0);
                }

                @Override
                public void println(float arg0) {
                    this.checkClosed();
                    delegatee.println(arg0);
                }

                @Override
                public void println(int arg0) {
                    this.checkClosed();
                    delegatee.println(arg0);
                }

                @Override
                public void println(long arg0) {
                    this.checkClosed();
                    delegatee.println(arg0);
                }

                @Override
                public void println(Object arg0) {
                    this.checkClosed();
                    delegatee.println(arg0);
                }

                @Override
                public void println(String arg0) {
                    this.checkClosed();
                    delegatee.println(arg0);
                }

                @Override
                public void write(char[] arg0, int arg1, int arg2) {
                    this.checkClosed();
                    delegatee.write(arg0, arg1, arg2);
                }

                @Override
                public void write(char[] arg0) {
                    this.checkClosed();
                    delegatee.write(arg0);
                }

                @Override
                public void write(int arg0) {
                    this.checkClosed();
                    delegatee.write(arg0);
                }

                @Override
                public void write(String arg0, int arg1, int arg2) {
                    this.checkClosed();
                    delegatee.write(arg0, arg1, arg2);
                }

                @Override
                public void write(String arg0) {
                    this.checkClosed();
                    delegatee.write(arg0);
                }
            };
        }
        return result;
    }

    public ServletOutputStream getOutputStream() throws IOException {
        ServletOutputStream outputStream = super.getOutputStream();
        if (this.firstSlingResponse) {
            return new DelegatingServletOutputStream(outputStream){

                @Override
                public void flush() throws IOException {
                    SlingHttpServletResponseImpl.this.initFlusherStacktrace();
                    super.flush();
                }
            };
        }
        return outputStream;
    }

    private void checkCommitted() {
        if (this.isCommitted()) {
            throw new IllegalStateException("Response has already been committed");
        }
    }

    private String makeAbsolutePath(String path) {
        if (path.startsWith("/")) {
            return path;
        }
        String base = this.getRequestData().getContentData().getResource().getPath();
        int lastSlash = base.lastIndexOf(47);
        path = lastSlash >= 0 ? base.substring(0, lastSlash + 1) + path : "/" + path;
        return path;
    }

    private String map(String url) {
        return this.getRequestData().getResourceResolver().map(this.getRequestData().getServletRequest(), url);
    }

    private String removeContextPath(String path) {
        String contextPath = this.getRequestData().getSlingRequest().getContextPath().concat("/");
        if (contextPath.length() > 1 && path.startsWith(contextPath)) {
            return path.substring(contextPath.length() - 1);
        }
        return path;
    }

    private static class ContentTypeChangeException
    extends SlingException {
        protected ContentTypeChangeException(String text) {
            super(text);
        }
    }

    private abstract class DelegatingServletOutputStream
    extends ServletOutputStream {
        final ServletOutputStream delegate;

        DelegatingServletOutputStream(ServletOutputStream delegate) {
            this.delegate = delegate;
        }

        public void print(String s) throws IOException {
            this.delegate.print(s);
        }

        public void print(boolean b) throws IOException {
            this.delegate.print(b);
        }

        public void print(char c) throws IOException {
            this.delegate.print(c);
        }

        public void print(int i) throws IOException {
            this.delegate.print(i);
        }

        public void print(long l) throws IOException {
            this.delegate.print(l);
        }

        public void print(float f) throws IOException {
            this.delegate.print(f);
        }

        public void print(double d) throws IOException {
            this.delegate.print(d);
        }

        public void println() throws IOException {
            this.delegate.println();
        }

        public void println(String s) throws IOException {
            this.delegate.println(s);
        }

        public void println(boolean b) throws IOException {
            this.delegate.println(b);
        }

        public void println(char c) throws IOException {
            this.delegate.println(c);
        }

        public void println(int i) throws IOException {
            this.delegate.println(i);
        }

        public void println(long l) throws IOException {
            this.delegate.println(l);
        }

        public void println(float f) throws IOException {
            this.delegate.println(f);
        }

        public void println(double d) throws IOException {
            this.delegate.println(d);
        }

        public boolean isReady() {
            return this.delegate.isReady();
        }

        public void setWriteListener(WriteListener writeListener) {
            this.delegate.setWriteListener(writeListener);
        }

        public void write(int b) throws IOException {
            this.delegate.write(b);
        }

        public void write(byte[] b) throws IOException {
            this.delegate.write(b);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.delegate.write(b, off, len);
        }

        public void flush() throws IOException {
            this.delegate.flush();
        }

        public void close() throws IOException {
            this.delegate.close();
        }
    }

    public static class WriterAlreadyClosedException
    extends IllegalStateException {
    }
}

