/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.engine.impl.parameters;

import java.io.File;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.engine.impl.parameters.ParameterMap;
import org.apache.sling.engine.impl.parameters.ParameterSupport;
import org.apache.sling.engine.impl.parameters.ParameterSupportHttpServletRequestWrapper;
import org.apache.sling.engine.impl.parameters.Util;
import org.apache.sling.settings.SlingSettingsService;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.propertytypes.ServiceDescription;
import org.osgi.service.component.propertytypes.ServiceRanking;
import org.osgi.service.component.propertytypes.ServiceVendor;
import org.osgi.service.http.whiteboard.propertytypes.HttpWhiteboardContextSelect;
import org.osgi.service.http.whiteboard.propertytypes.HttpWhiteboardFilterPattern;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(name="org.apache.sling.engine.parameters", service={Filter.class})
@HttpWhiteboardContextSelect(value="(osgi.http.whiteboard.context.name=org.apache.sling)")
@HttpWhiteboardFilterPattern(value={"/"})
@ServiceDescription(value="Filter for request parameter support")
@ServiceVendor(value="The Apache Software Foundation")
@ServiceRanking(value=0x7FFFFFFF)
@Designate(ocd=Config.class)
public class RequestParameterSupportConfigurer
implements Filter {
    static final String PID = "org.apache.sling.engine.parameters";
    private final Logger log = LoggerFactory.getLogger((String)"org.apache.sling.engine.parameters");
    @Reference
    private SlingSettingsService settignsService;

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (request instanceof HttpServletRequest && !(request instanceof ParameterSupportHttpServletRequestWrapper) && !(request instanceof SlingHttpServletRequest)) {
            chain.doFilter((ServletRequest)ParameterSupport.getParameterSupportRequestWrapper((HttpServletRequest)request), response);
        } else {
            chain.doFilter(request, response);
        }
    }

    public void destroy() {
    }

    @Activate
    private void configure(Config config) {
        String fixEncoding = config.sling_default_parameter_encoding();
        int maxParams = config.sling_default_max_parameters();
        long maxRequestSize = config.request_max();
        String fileLocation = this.getFileLocation(config.file_location());
        long maxFileSize = config.file_max();
        int fileSizeThreshold = config.file_threshold();
        boolean checkAddParameters = config.sling_default_parameter_checkForAdditionalContainerParameters();
        if (this.log.isInfoEnabled()) {
            this.log.info("Default Character Encoding: {}", (Object)fixEncoding);
            this.log.info("Parameter Number Limit: {}", maxParams < 0 ? "unlimited" : Integer.valueOf(maxParams));
            this.log.info("Maximum Request Size: {}", maxParams < 0 ? "unlimited" : Long.valueOf(maxRequestSize));
            this.log.info("Temporary File Location: {}", (Object)fileLocation);
            this.log.info("Maximum File Size: {}", (Object)maxFileSize);
            this.log.info("Tempory File Creation Threshold: {}", (Object)fileSizeThreshold);
            this.log.info("Check for additional container parameters: {}", (Object)checkAddParameters);
        }
        Util.setDefaultFixEncoding(fixEncoding);
        ParameterMap.setMaxParameters(maxParams);
        ParameterSupport.configure(maxRequestSize, fileLocation, maxFileSize, fileSizeThreshold, checkAddParameters);
    }

    private String getFileLocation(String fileLocation) {
        if (fileLocation != null) {
            File file = new File(fileLocation);
            if (!file.isAbsolute()) {
                file = new File(this.settignsService.getSlingHomePath(), fileLocation);
                fileLocation = file.getAbsolutePath();
            }
            if (file.exists()) {
                if (!file.isDirectory()) {
                    this.log.error("Configured temporary file location {} exists but is not a directory; using java.io.tmpdir instead", (Object)fileLocation);
                    fileLocation = null;
                }
            } else if (!file.mkdirs()) {
                this.log.error("Cannot create temporary file directory {}; using java.io.tmpdir instead", (Object)fileLocation);
                fileLocation = null;
            }
        }
        return fileLocation;
    }

    @ObjectClassDefinition(name="Apache Sling Request Parameter Handling", description="Configures Sling's request parameter handling.")
    public static @interface Config {
        @AttributeDefinition(name="Default Parameter Encoding", description="The default request parameter encoding used to decode request parameters into strings. If this property is not set the default encoding is 'ISO-8859-1' as mandated by the Servlet API spec. This default encoding is used if the '_charset_' request parameter is not set to another (supported) character encoding. Applications being sure to always use the same encoding (e.g. UTF-8) can set this default here and may omit the '_charset_' request parameter")
        public String sling_default_parameter_encoding() default "ISO-8859-1";

        @AttributeDefinition(name="Maximum POST Parameters", description="The maximum number of parameters supported. To prevent a DOS-style attack with an overrunning number of parameters the number of parameters supported can be limited. This includes all of the query string as well as application/x-www-form-urlencoded and multipart/form-data parameters. The default value is 10000.")
        public int sling_default_max_parameters() default 10000;

        @AttributeDefinition(name="Temporary File Location", description="The temporary directory where uploaded files are written to disk. The default is null, which means the directory given by the 'java.io.tmpdir' system property.")
        public String file_location();

        @AttributeDefinition(name="File Save Threshold", description="The size threshold after which the file will be written to disk. The default is 256KB.")
        public int file_threshold() default 256000;

        @AttributeDefinition(name="Maximum File Size", description="The maximum size allowed for uploaded files. The default is -1, which means unlimited.")
        public long file_max() default -1L;

        @AttributeDefinition(name="Maximum Request Size", description="The maximum size allowed for multipart/form-data requests. The default is -1, which means unlimited.")
        public long request_max() default -1L;

        @AttributeDefinition(name="Check Additional Parameters", description="Enable this if you want to include request parameters added through the container, e.g through a valve.")
        public boolean sling_default_parameter_checkForAdditionalContainerParameters() default false;
    }
}

