/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.engine.impl.filter;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.request.RequestProgressTracker;
import org.apache.sling.engine.impl.filter.FilterHandle;
import org.apache.sling.engine.impl.request.RequestData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSlingFilterChain
implements FilterChain {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractSlingFilterChain.class);
    private FilterHandle[] filters;
    private int current;
    private long[] times;

    protected AbstractSlingFilterChain(FilterHandle[] filters) {
        this.filters = filters;
        this.current = -1;
        this.times = new long[filters.length + 1];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        int filterIdx = ++this.current;
        long start = System.nanoTime();
        if (filterIdx > this.filters.length) {
            throw new IllegalStateException("doFilter should not be called more than once");
        }
        SlingHttpServletRequest slingRequest = this.toSlingRequest(request);
        SlingHttpServletResponse slingResponse = this.toSlingResponse(response);
        try {
            if (this.current < this.filters.length) {
                FilterHandle filter = this.filters[this.current];
                if (filter.select(slingRequest)) {
                    LOG.debug("{} got selected for this request", (Object)filter);
                    this.trackFilter((ServletRequest)slingRequest, filter);
                    filter.getFilter().doFilter((ServletRequest)slingRequest, (ServletResponse)slingResponse, (FilterChain)this);
                } else {
                    LOG.debug("{} was not selected for this request", (Object)filter);
                    if (this.current == this.filters.length - 1) {
                        this.render(slingRequest, slingResponse);
                    } else {
                        this.doFilter((ServletRequest)slingRequest, (ServletResponse)slingResponse);
                    }
                }
            } else {
                this.render(slingRequest, slingResponse);
            }
        }
        finally {
            if (filterIdx < this.times.length) {
                this.times[filterIdx] = (System.nanoTime() - start) / 1000L;
                if (filterIdx == 0) {
                    this.consolidateFilterTimings((ServletRequest)slingRequest);
                }
            }
        }
    }

    protected abstract void render(SlingHttpServletRequest var1, SlingHttpServletResponse var2) throws IOException, ServletException;

    private void trackFilter(ServletRequest request, FilterHandle filter) {
        RequestData data = RequestData.getRequestData(request);
        if (data != null) {
            RequestProgressTracker tracker = data.getRequestProgressTracker();
            tracker.log("Calling filter: {0}", new Object[]{filter.getFilter().getClass().getName()});
        }
        filter.track();
    }

    private void consolidateFilterTimings(ServletRequest request) {
        if (this.filters != null) {
            RequestData data = RequestData.getRequestData(request);
            RequestProgressTracker tracker = data != null ? data.getRequestProgressTracker() : null;
            for (int i = this.filters.length - 1; i > 0; --i) {
                this.filters[i].trackTime(this.times[i] - this.times[i + 1]);
                if (tracker == null) continue;
                tracker.log("Filter timing: filter={0}, inner={1,number,#}, total={2,number,#}, outer={3,number,#}", new Object[]{this.filters[i].getFilter().getClass().getName(), this.times[i + 1], this.times[i], this.times[i] - this.times[i + 1]});
            }
        }
    }

    private SlingHttpServletRequest toSlingRequest(ServletRequest request) {
        if (request instanceof SlingHttpServletRequest) {
            return (SlingHttpServletRequest)request;
        }
        return RequestData.toSlingHttpServletRequest(request);
    }

    private SlingHttpServletResponse toSlingResponse(ServletResponse response) {
        if (response instanceof SlingHttpServletResponse) {
            return (SlingHttpServletResponse)response;
        }
        return RequestData.toSlingHttpServletResponse(response);
    }
}

