/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.engine.impl;

import java.util.Dictionary;
import java.util.Hashtable;
import javax.servlet.GenericServlet;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.sling.api.request.SlingRequestEvent;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.engine.impl.Config;
import org.apache.sling.engine.impl.ProductInfoProvider;
import org.apache.sling.engine.impl.SlingRequestProcessorImpl;
import org.apache.sling.engine.impl.helper.ClientAbortException;
import org.apache.sling.engine.impl.helper.RequestListenerManager;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.osgi.service.component.propertytypes.ServiceDescription;
import org.osgi.service.component.propertytypes.ServiceVendor;
import org.osgi.service.metatype.annotations.Designate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(configurationPid={"org.apache.sling.engine.impl.SlingMainServlet"})
@ServiceDescription(value="Apache Sling Main Servlet")
@ServiceVendor(value="The Apache Software Foundation")
@Designate(ocd=Config.class)
public class SlingMainServlet
extends GenericServlet {
    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    private volatile RequestListenerManager requestListenerManager;
    private BundleContext bundleContext;
    private final Logger log = LoggerFactory.getLogger(SlingMainServlet.class);
    @Reference
    private ProductInfoProvider productInfoProvider;
    @Reference(target="(name=org.apache.sling)")
    private ServletContext slingServletContext;
    @Reference
    private SlingRequestProcessorImpl requestProcessorImpl;
    private volatile boolean allowTrace;
    private volatile ServiceRegistration<Servlet> servletRegistration;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(ServletRequest req, ServletResponse res) throws ServletException {
        if (req instanceof HttpServletRequest && res instanceof HttpServletResponse) {
            HttpServletRequest request = (HttpServletRequest)req;
            String threadName = this.setThreadName(request);
            RequestListenerManager localRLM = this.requestListenerManager;
            if (localRLM != null) {
                localRLM.sendEvent(request, SlingRequestEvent.EventType.EVENT_INIT);
            }
            ResourceResolver resolver = null;
            try {
                if (!this.allowTrace && "TRACE".equals(request.getMethod())) {
                    HttpServletResponse response = (HttpServletResponse)res;
                    response.setStatus(405);
                    response.setHeader("Allow", "GET, HEAD, POST, PUT, DELETE, OPTIONS");
                    return;
                }
                Object resolverObject = request.getAttribute("org.apache.sling.auth.core.ResourceResolver");
                resolver = resolverObject instanceof ResourceResolver ? (ResourceResolver)resolverObject : null;
                this.requestProcessorImpl.doProcessRequest(request, (HttpServletResponse)res, resolver);
            }
            catch (ClientAbortException cae) {
                this.log.debug("service: ClientAbortException, probable cause is client aborted request or network problem", (Throwable)cae);
            }
            catch (Throwable t) {
                this.log.error("service: Uncaught Problem handling the request", t);
            }
            finally {
                if (resolver != null) {
                    resolver.close();
                }
                if (localRLM != null) {
                    localRLM.sendEvent(request, SlingRequestEvent.EventType.EVENT_DESTROY);
                }
                if (threadName != null) {
                    Thread.currentThread().setName(threadName);
                }
            }
        } else {
            throw new ServletException("Apache Sling must be run in an HTTP servlet environment.");
        }
    }

    @Modified
    protected void modified(Config config) {
        this.setup(config);
    }

    private Dictionary<String, Object> getServletContextRegistrationProps(String servletName) {
        Hashtable<String, Object> servletConfig = new Hashtable<String, Object>();
        ((Dictionary)servletConfig).put("osgi.http.whiteboard.context.select", "(osgi.http.whiteboard.context.name=org.apache.sling)");
        ((Dictionary)servletConfig).put("osgi.http.whiteboard.servlet.pattern", "/");
        ((Dictionary)servletConfig).put("osgi.http.whiteboard.servlet.name", servletName);
        ((Dictionary)servletConfig).put("service.description", "Apache Sling Engine Main Servlet");
        ((Dictionary)servletConfig).put("service.vendor", "The Apache Software Foundation");
        return servletConfig;
    }

    protected void setup(Config config) {
        this.allowTrace = config.sling_trace_allow();
        String servletName = config.servlet_name();
        if (servletName == null || servletName.isEmpty()) {
            servletName = this.productInfoProvider.getProductInfo();
        }
        if (this.servletRegistration == null) {
            this.servletRegistration = this.bundleContext.registerService(Servlet.class, (Object)this, this.getServletContextRegistrationProps(servletName));
        } else if (!servletName.equals(this.servletRegistration.getReference().getProperty("osgi.http.whiteboard.servlet.name"))) {
            this.servletRegistration.setProperties(this.getServletContextRegistrationProps(servletName));
        }
    }

    @Activate
    protected void activate(BundleContext bundleContext, Config config) {
        this.bundleContext = bundleContext;
        this.setup(config);
    }

    public void init() throws ServletException {
        this.log.info("{} ready to serve requests", (Object)this.slingServletContext.getServerInfo());
    }

    @Deactivate
    protected void deactivate() {
        if (this.servletRegistration != null) {
            this.servletRegistration.unregister();
            this.servletRegistration = null;
        }
        this.bundleContext = null;
        this.log.info("{} shut down", (Object)this.slingServletContext.getServerInfo());
    }

    private String setThreadName(HttpServletRequest request) {
        Thread thread = Thread.currentThread();
        String oldThreadName = thread.getName();
        StringBuilder buf = new StringBuilder();
        buf.append(request.getRemoteAddr());
        buf.append(" [").append(System.currentTimeMillis()).append("] ");
        buf.append(request.getMethod()).append(' ');
        buf.append(request.getRequestURI()).append(' ');
        buf.append(request.getProtocol());
        thread.setName(buf.toString());
        return oldThreadName;
    }
}

