/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.engine.impl.debug;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.engine.RequestInfo;
import org.apache.sling.engine.RequestInfoProvider;
import org.apache.sling.engine.impl.SlingMainServlet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;

@Component(service={RequestInfoProvider.class}, immediate=true, configurationPid={"org.apache.sling.engine.impl.SlingMainServlet"})
public class RequestInfoProviderImpl
implements RequestInfoProvider {
    public static final int STORED_REQUESTS_COUNT = 20;
    private volatile ConcurrentNavigableMap<String, RequestInfo> requests;
    private volatile List<Pattern> patterns;
    private volatile int maxSize;
    private static volatile RequestInfoProviderImpl INSTANCE;

    @Activate
    public RequestInfoProviderImpl(SlingMainServlet.Config config) {
        this.update(config);
        INSTANCE = this;
    }

    @Modified
    protected void update(SlingMainServlet.Config config) {
        this.maxSize = config.sling_max_record_requests();
        if (this.maxSize < 0) {
            this.maxSize = 0;
        }
        this.requests = this.maxSize > 0 ? new ConcurrentSkipListMap() : null;
        ArrayList<Pattern> compiledPatterns = new ArrayList<Pattern>();
        if (config.sling_store_pattern_requests() != null) {
            for (String pattern : config.sling_store_pattern_requests()) {
                if (pattern == null || pattern.trim().length() <= 0) continue;
                compiledPatterns.add(Pattern.compile(pattern.trim()));
            }
        }
        this.patterns = compiledPatterns;
    }

    @Deactivate
    protected void deactivate() {
        INSTANCE = null;
        this.requests = null;
        this.patterns = Collections.emptyList();
    }

    public static void recordRequest(SlingHttpServletRequest r) {
        RequestInfoProviderImpl local = INSTANCE;
        if (local != null) {
            local.addRequest(r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRequest(SlingHttpServletRequest r) {
        ConcurrentNavigableMap<String, RequestInfo> local = this.requests;
        if (local != null && this.isEnabledFor(r.getPathInfo())) {
            RequestInfoImpl info = new RequestInfoImpl(r);
            ConcurrentNavigableMap<String, RequestInfo> concurrentNavigableMap = local;
            synchronized (concurrentNavigableMap) {
                if (local.size() == this.maxSize) {
                    local.remove(local.firstKey());
                }
                local.put(info.getId(), info);
            }
        }
    }

    @Override
    public boolean isEnabled() {
        return this.requests != null;
    }

    @Override
    public boolean isEnabledFor(String path) {
        if (this.requests != null) {
            boolean accept = this.patterns.isEmpty();
            for (Pattern pattern : this.patterns) {
                if (!pattern.matcher(path).matches()) continue;
                accept = true;
                break;
            }
            return accept;
        }
        return false;
    }

    @Override
    public int getMayNumberOfInfos() {
        return this.getMaxNumberOfInfos();
    }

    @Override
    public int getMaxNumberOfInfos() {
        return this.maxSize;
    }

    @Override
    public void clear() {
        ConcurrentNavigableMap<String, RequestInfo> local = this.requests;
        if (local != null) {
            local.clear();
        }
    }

    @Override
    public RequestInfo getRequestInfo(String id) {
        ConcurrentNavigableMap<String, RequestInfo> local = this.requests;
        if (local != null) {
            return (RequestInfo)local.get(id);
        }
        return null;
    }

    @Override
    public Iterable<RequestInfo> getRequestInfos() {
        ConcurrentNavigableMap<String, RequestInfo> local = this.requests;
        if (local != null) {
            return local.values();
        }
        return Collections.emptyList();
    }

    private static class RequestInfoImpl
    implements RequestInfo {
        private static AtomicLong requestCounter = new AtomicLong(0L);
        private final String id = String.valueOf(System.currentTimeMillis()).concat("-").concat(String.valueOf(requestCounter.incrementAndGet()));
        private final String method;
        private final String path;
        private final String userId;
        private final String log;

        RequestInfoImpl(SlingHttpServletRequest request) {
            String text;
            this.method = request.getMethod();
            this.path = request.getPathInfo() == null ? "" : request.getPathInfo();
            this.userId = request.getRemoteUser();
            try (StringWriter writer = new StringWriter();){
                PrintWriter pw = new PrintWriter(writer);
                request.getRequestProgressTracker().dump(pw);
                pw.flush();
                text = writer.toString();
            }
            catch (IOException ioe) {
                text = "";
            }
            this.log = text;
        }

        @Override
        @NotNull
        public String getId() {
            return this.id;
        }

        @Override
        @NotNull
        public String getMethod() {
            return this.method;
        }

        @Override
        @NotNull
        public String getPath() {
            return this.path;
        }

        @Override
        @Nullable
        public String getUserId() {
            return this.userId;
        }

        @Override
        @NotNull
        public String getLog() {
            return this.log;
        }
    }
}

