/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.engine.impl.filter;

import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.servlet.Filter;
import org.apache.sling.engine.impl.filter.FilterHandle;
import org.apache.sling.engine.impl.filter.FilterPredicate;
import org.apache.sling.engine.impl.filter.FilterProcessorMBeanImpl;

public class SlingFilterChainHelper {
    private static final FilterHandle[] EMPTY_FILTER_ARRAY = new FilterHandle[0];
    private SortedSet<FilterHandle> filterList;
    private FilterHandle[] filters = EMPTY_FILTER_ARRAY;

    SlingFilterChainHelper() {
    }

    public synchronized Filter addFilter(Filter filter, FilterPredicate pattern, long filterId, int order, String orderSource, FilterProcessorMBeanImpl mbean) {
        if (this.filterList == null) {
            this.filterList = new TreeSet<FilterHandle>();
        }
        this.filterList.add(new FilterHandle(filter, pattern, filterId, order, orderSource, mbean));
        this.filters = this.getFiltersInternal();
        return filter;
    }

    public synchronized boolean removeFilterById(long filterId) {
        if (this.filterList != null) {
            Iterator fi = this.filterList.iterator();
            while (fi.hasNext()) {
                FilterHandle test = (FilterHandle)fi.next();
                if (test.getFilterId() != filterId) continue;
                fi.remove();
                this.filters = this.getFiltersInternal();
                return true;
            }
        }
        return false;
    }

    public FilterHandle[] getFilters() {
        return this.filters;
    }

    private FilterHandle[] getFiltersInternal() {
        if (this.filterList == null || this.filterList.isEmpty()) {
            return EMPTY_FILTER_ARRAY;
        }
        return this.filterList.toArray(new FilterHandle[this.filterList.size()]);
    }
}

