/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.engine.impl.console;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.sling.api.request.ResponseUtil;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.engine.RequestInfo;
import org.apache.sling.engine.RequestInfoProvider;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.propertytypes.ServiceDescription;
import org.osgi.service.component.propertytypes.ServiceVendor;

@Component(service={Servlet.class}, property={"felix.webconsole.label=requests", "felix.webconsole.title=Recent requests", "felix.webconsole.category=Sling"})
@ServiceDescription(value="Web Console Plugin to display information about recent Sling requests")
@ServiceVendor(value="The Apache Software Foundation")
public class RequestHistoryConsolePlugin
extends HttpServlet {
    private static final long serialVersionUID = -5738101314957623511L;
    public static final String LABEL = "requests";
    public static final String INDEX = "index";
    public static final String CLEAR = "clear";
    private final RequestInfoProvider infoProvider;

    @Activate
    public RequestHistoryConsolePlugin(@Reference RequestInfoProvider provider) {
        this.infoProvider = provider;
    }

    private void printLinksTable(PrintWriter pw, List<RequestInfo> values, String currentRequestIndex) {
        ArrayList<String> links = new ArrayList<String>();
        for (RequestInfo info : values) {
            String key = ResponseUtil.escapeXml((String)info.getId());
            boolean isCurrent = info.getId().equals(currentRequestIndex);
            StringBuilder sb = new StringBuilder();
            sb.append("<span style='white-space: pre; text-align:right; font-size:80%'>");
            sb.append(String.format("%1$8s", key));
            sb.append("</span> ");
            sb.append("<a href='requests?index=" + key + "'>");
            if (isCurrent) {
                sb.append("<b>");
            }
            sb.append(ResponseUtil.escapeXml((String)this.getLabel(info)));
            if (isCurrent) {
                sb.append("</b>");
            }
            sb.append("</a> ");
            links.add(sb.toString());
        }
        int nCols = 5;
        while (links.size() % 5 != 0) {
            links.add("&nbsp;");
        }
        pw.println("<table class='nicetable ui-widget'>");
        pw.println("<tr>\n");
        if (values.isEmpty()) {
            pw.print("No Requests recorded");
        } else {
            int i = 0;
            for (String str : links) {
                if (i++ % 5 == 0) {
                    pw.println("</tr>");
                    pw.println("<tr>");
                }
                pw.print("<td>");
                pw.print(str);
                pw.println("</td>");
            }
        }
        pw.println("</tr>");
        pw.println("</table>");
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String key = req.getParameter(INDEX);
        RequestInfo info = key == null ? null : this.infoProvider.getRequestInfo(key);
        ArrayList<RequestInfo> values = new ArrayList<RequestInfo>();
        for (RequestInfo i : this.infoProvider.getRequestInfos()) {
            values.add(i);
        }
        PrintWriter pw = resp.getWriter();
        if (this.infoProvider.getMayNumberOfInfos() > 0) {
            pw.println("<p class='statline ui-state-highlight'>Recorded " + values.size() + " requests (max: " + this.infoProvider.getMayNumberOfInfos() + ")</p>");
        } else {
            pw.println("<p class='statline ui-state-highlight'>Request Recording disabled</p>");
        }
        pw.println("<div class='ui-widget-header ui-corner-top buttonGroup'>");
        pw.println("<span style='float: left; margin-left: 1em'>Recent Requests</span>");
        pw.println("<form method='POST'><input type='hidden' name='clear' value='clear'><input type='submit' value='Clear' class='ui-state-default ui-corner-all'></form>");
        pw.println("</div>");
        this.printLinksTable(pw, values, key);
        pw.println("<br/>");
        if (info != null) {
            pw.println("<table class='nicetable ui-widget'>");
            pw.println("<thead>");
            pw.println("<tr>");
            pw.printf("<th class='ui-widget-header'>Request %s (%s %s) by %s - RequestProgressTracker Info</th>%n", key, ResponseUtil.escapeXml((String)info.getMethod()), ResponseUtil.escapeXml((String)info.getPath()), ResponseUtil.escapeXml((String)info.getUserId()));
            pw.println("</tr>");
            pw.println("</thead>");
            pw.println("<tbody>");
            pw.println("<tr><td><pre>");
            pw.print(ResponseUtil.escapeXml((String)info.getLog()));
            pw.println("</pre></td></tr>");
            pw.println("</tbody></table>");
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        if (req.getParameter(CLEAR) != null) {
            this.infoProvider.clear();
            resp.sendRedirect(req.getRequestURI());
        }
    }

    public String getLabel(RequestInfo info) {
        StringBuilder sb = new StringBuilder();
        sb.append(info.getMethod());
        sb.append(' ');
        String path = info.getPath();
        if (path.length() > 0) {
            sb.append(ResourceUtil.getName((String)path));
        } else {
            sb.append('/');
        }
        return sb.toString();
    }
}

