/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.dynamicinclude.generator.types;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.sling.dynamicinclude.generator.IncludeGenerator;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
public class JsiGenerator
implements IncludeGenerator {
    private static final String TEMPLATE_FILENAME = "generators/jquery.html";
    private static final String UUID_FIELD = "${uniqueId}";
    private static final String URL_FIELD = "${url}";
    private static final Logger LOG = LoggerFactory.getLogger(JsiGenerator.class);
    private static final String GENERATOR_NAME = "JSI";
    private volatile int divId = 1000;
    private String template;

    @Activate
    public void activate(ComponentContext ctx) {
        URL url = ctx.getBundleContext().getBundle().getResource(TEMPLATE_FILENAME);
        if (url == null) {
            LOG.error("File generators/jquery.html not found in bundle.");
            return;
        }
        this.readTemplateFromUrl(url);
    }

    @Override
    public String getType() {
        return GENERATOR_NAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getInclude(String url) {
        String divName;
        if (this.template == null) {
            throw new IllegalStateException("JSI generator hasn't be initialized");
        }
        JsiGenerator jsiGenerator = this;
        synchronized (jsiGenerator) {
            divName = "dynamic_include_filter_div_" + this.divId++;
        }
        return this.template.replace(UUID_FIELD, divName).replace(URL_FIELD, StringEscapeUtils.escapeEcmaScript((String)url));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readTemplateFromUrl(URL url) {
        BufferedReader br = null;
        try {
            String line;
            InputStream in = url.openStream();
            br = new BufferedReader(new InputStreamReader(in, "UTF-8"));
            StringBuilder builder = new StringBuilder();
            while ((line = br.readLine()) != null) {
                builder.append(line).append('\n');
            }
            this.template = builder.toString();
        }
        catch (UnsupportedEncodingException e) {
            LOG.error("Error while reading template", (Throwable)e);
        }
        catch (IOException e) {
            LOG.error("Error while reading template", (Throwable)e);
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (Exception e) {
                LOG.error("Error while closing reader", (Throwable)e);
            }
        }
    }
}

