/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.journal.queue.impl;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.sling.distribution.journal.messages.LogMessage;
import org.apache.sling.distribution.journal.shared.AgentId;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

@Component(service={QueueErrors.class, EventHandler.class}, property={"event.topics=org/apache/sling/distribution/journal/log"})
public class QueueErrors
implements EventHandler {
    private final Map<String, Map<String, Throwable>> errors = new ConcurrentHashMap<String, Map<String, Throwable>>();

    public Throwable getError(String pubAgentName, String subAgentId) {
        return (Throwable)this.errors.computeIfAbsent(pubAgentName, this::newPubAgent).get(subAgentId);
    }

    public void handleEvent(Event event) {
        LogMessage msg = (LogMessage)event.getProperty("message");
        if (msg != null) {
            String subAgentId = new AgentId(msg.getSubSlingId(), msg.getSubAgentName()).getAgentId();
            this.errors.computeIfAbsent(msg.getPubAgentName(), this::newPubAgent).put(subAgentId, this.toThrowable(msg));
        }
    }

    private Throwable toThrowable(LogMessage msg) {
        return new Throwable(msg.getMessage(), new Throwable(msg.getStacktrace()));
    }

    private Map<String, Throwable> newPubAgent(String pubAgentName) {
        return new ConcurrentHashMap<String, Throwable>();
    }
}

