/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.journal.queue;

import java.util.HashMap;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.sling.distribution.DistributionRequestType;
import org.apache.sling.distribution.journal.FullMessage;
import org.apache.sling.distribution.journal.MessageInfo;
import org.apache.sling.distribution.journal.messages.PackageMessage;
import org.apache.sling.distribution.queue.DistributionQueueItem;

@ParametersAreNonnullByDefault
public final class QueueItemFactory {
    public static final String RECORD_TOPIC = "recordTopic";
    public static final String RECORD_PARTITION = "recordPartition";
    public static final String RECORD_OFFSET = "recordOffset";
    public static final String RECORD_TIMESTAMP = "recordTimestamp";
    public static final String PACKAGE_MSG = "packageMessage";
    private static final String REQUEST_USER_ID = "internal.request.user";

    private QueueItemFactory() {
    }

    public static DistributionQueueItem fromPackage(FullMessage<PackageMessage> fMessage) {
        return QueueItemFactory.fromPackage(fMessage.getInfo(), (PackageMessage)fMessage.getMessage(), false);
    }

    public static DistributionQueueItem fromPackage(MessageInfo info, PackageMessage message, boolean addMessage) {
        String packageId = message.getPkgId();
        long pkgLength = message.getPkgLength();
        HashMap<String, Object> properties = new HashMap<String, Object>(10);
        properties.put(RECORD_TOPIC, info.getTopic());
        properties.put(RECORD_PARTITION, info.getPartition());
        properties.put(RECORD_OFFSET, info.getOffset());
        properties.put(RECORD_TIMESTAMP, info.getCreateTime());
        properties.put("package.type", message.getPkgType());
        properties.put("request.type", QueueItemFactory.toDistReqType(message.getReqType()));
        String[] paths = QueueItemFactory.toArray(message.getPaths());
        properties.put("request.paths", paths);
        String[] deepPaths = QueueItemFactory.toArray(message.getDeepPaths());
        properties.put("request.deepPaths", deepPaths);
        if (addMessage) {
            properties.put(PACKAGE_MSG, message);
        }
        if (message.getUserId() != null) {
            properties.put(REQUEST_USER_ID, message.getUserId());
        }
        return new DistributionQueueItem(packageId, pkgLength, properties);
    }

    private static DistributionRequestType toDistReqType(PackageMessage.ReqType reqType) {
        switch (reqType) {
            case ADD: {
                return DistributionRequestType.ADD;
            }
            case DELETE: {
                return DistributionRequestType.DELETE;
            }
            case TEST: {
                return DistributionRequestType.TEST;
            }
        }
        throw new IllegalArgumentException("Unhandled DistributionRequestType: " + reqType.name());
    }

    @Nonnull
    private static String[] toArray(List<String> paths) {
        return paths.isEmpty() ? new String[]{} : paths.toArray(new String[0]);
    }
}

