/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.journal.binary.jcr;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.jcr.Binary;
import javax.jcr.Node;
import javax.jcr.Session;
import javax.jcr.ValueFactory;
import org.apache.jackrabbit.api.ReferenceBinary;
import org.apache.jackrabbit.commons.JcrUtils;
import org.apache.jackrabbit.commons.jackrabbit.SimpleReferenceBinary;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.commons.metrics.Timer;
import org.apache.sling.distribution.common.DistributionException;
import org.apache.sling.distribution.journal.BinaryStore;
import org.apache.sling.distribution.journal.binary.jcr.PackageCleaner;
import org.apache.sling.distribution.journal.shared.DistributionMetricsService;
import org.apache.sling.serviceusermapping.ServiceUserMapped;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(property={"type=jcr"})
public class JcrBinaryStore
implements BinaryStore {
    private static final long MAX_INLINE_PKG_BINARY_SIZE = 819200L;
    private static final String SLING_FOLDER = "sling:Folder";
    static final String PACKAGES_ROOT_PATH = "/var/sling/distribution/journal/packagebinaries";
    private static final Logger LOG = LoggerFactory.getLogger(JcrBinaryStore.class);
    @Reference
    private ServiceUserMapped mapped;
    @Reference
    private DistributionMetricsService distributionMetricsService;
    @Reference
    private ResourceResolverFactory resolverFactory;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public InputStream get(String reference) throws IOException {
        try (ResourceResolver resolver = this.createResourceResolver();){
            Session session = (Session)resolver.adaptTo(Session.class);
            if (session == null) {
                throw new IOException("Unable to get Oak session");
            }
            ValueFactory factory = session.getValueFactory();
            Binary binary = factory.createValue((Binary)new SimpleReferenceBinary(reference)).getBinary();
            InputStream inputStream = binary.getStream();
            return inputStream;
        }
        catch (Exception e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    public String put(String id, InputStream stream, long length) throws IOException {
        if (length > 819200L) {
            LOG.info("Package {} too large ({}B) to be sent inline", (Object)id, (Object)length);
            try {
                return this.store(id, stream);
            }
            catch (DistributionException e) {
                throw new IOException(e.getMessage(), e);
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nonnull
    public String store(String id, InputStream binaryStream) throws DistributionException {
        try (ResourceResolver resolver = this.createResourceResolver();){
            String pkgPath = "/var/sling/distribution/journal/packagebinaries/" + id;
            Resource pkgResource = ResourceUtil.getOrCreateResource((ResourceResolver)resolver, (String)pkgPath, (String)SLING_FOLDER, (String)SLING_FOLDER, (boolean)false);
            Node pkgNode = (Node)Objects.requireNonNull(pkgResource.adaptTo(Node.class));
            Node binNode = JcrUtils.getOrAddNode((Node)pkgNode, (String)"bin", (String)"{http://www.jcp.org/jcr/nt/1.0}file");
            Node cntNode = JcrUtils.getOrAddNode((Node)binNode, (String)"{http://www.jcp.org/jcr/1.0}content", (String)"{http://www.jcp.org/jcr/nt/1.0}resource");
            Binary binary = pkgNode.getSession().getValueFactory().createBinary(binaryStream);
            cntNode.setProperty("{http://www.jcp.org/jcr/1.0}data", binary);
            resolver.commit();
            String blobRef = ((ReferenceBinary)binary).getReference();
            LOG.info("Stored content package {} under path {} with blobRef {}", new Object[]{id, pkgPath, blobRef});
            String string = blobRef;
            return string;
        }
        catch (Exception e) {
            throw new DistributionException(e.getMessage(), (Throwable)e);
        }
    }

    public void cleanup(long deleteOlderThanTime) {
        Timer.Context context = this.distributionMetricsService.getCleanupPackageDuration().time();
        try (ResourceResolver resolver = this.createResourceResolver();){
            PackageCleaner packageCleaner = new PackageCleaner(resolver, deleteOlderThanTime);
            Resource root = this.getRoot(resolver);
            int removedCount = packageCleaner.cleanup(root);
            this.distributionMetricsService.getCleanupPackageRemovedCount().increment((long)removedCount);
        }
        catch (LoginException | PersistenceException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        finally {
            context.stop();
        }
    }

    @Nonnull
    private Resource getRoot(ResourceResolver resolver) throws PersistenceException {
        return ResourceUtil.getOrCreateResource((ResourceResolver)resolver, (String)PACKAGES_ROOT_PATH, (String)SLING_FOLDER, (String)SLING_FOLDER, (boolean)true);
    }

    private ResourceResolver createResourceResolver() throws LoginException {
        return this.resolverFactory.getServiceResourceResolver(Collections.singletonMap("sling.service.subservice", "bookkeeper"));
    }
}

