/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.trigger.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventListener;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.commons.scheduler.Scheduler;
import org.apache.sling.distribution.DistributionRequest;
import org.apache.sling.distribution.DistributionRequestType;
import org.apache.sling.distribution.SimpleDistributionRequest;
import org.apache.sling.distribution.common.DistributionException;
import org.apache.sling.distribution.trigger.DistributionRequestHandler;
import org.apache.sling.distribution.trigger.DistributionTrigger;
import org.apache.sling.distribution.util.DistributionJcrUtils;
import org.apache.sling.distribution.util.impl.DistributionUtils;
import org.apache.sling.jcr.api.SlingRepository;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJcrEventTrigger
implements DistributionTrigger {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Map<String, JcrEventDistributionTriggerListener> registeredListeners = new ConcurrentHashMap<String, JcrEventDistributionTriggerListener>();
    private final String path;
    private final String serviceUser;
    private final SlingRepository repository;
    private final ResourceResolverFactory resolverFactory;
    private Session cachedSession;
    private final Scheduler scheduler;

    AbstractJcrEventTrigger(SlingRepository repository, Scheduler scheduler, ResourceResolverFactory resolverFactory, String path, String serviceUser) {
        this.resolverFactory = resolverFactory;
        if (path == null || serviceUser == null) {
            throw new IllegalArgumentException("path and service are required");
        }
        this.repository = repository;
        this.path = path;
        this.serviceUser = serviceUser;
        this.scheduler = scheduler;
    }

    @Override
    public void register(@NotNull DistributionRequestHandler requestHandler) throws DistributionException {
        try {
            Session session = this.getSession();
            JcrEventDistributionTriggerListener listener = new JcrEventDistributionTriggerListener(requestHandler);
            this.registeredListeners.put(requestHandler.toString(), listener);
            session.getWorkspace().getObservationManager().addEventListener((EventListener)listener, this.getEventTypes(), this.path, true, null, null, false);
        }
        catch (RepositoryException e) {
            throw new DistributionException("unable to register handler " + requestHandler, e);
        }
    }

    @Override
    public void unregister(@NotNull DistributionRequestHandler requestHandler) throws DistributionException {
        JcrEventDistributionTriggerListener listener = this.registeredListeners.get(requestHandler.toString());
        if (listener != null) {
            try {
                Session session = this.getSession();
                session.getWorkspace().getObservationManager().removeEventListener((EventListener)listener);
            }
            catch (RepositoryException e) {
                throw new DistributionException("unable to unregister handler " + requestHandler, e);
            }
        }
    }

    void addToList(DistributionRequest request, List<DistributionRequest> requestList) {
        DistributionRequest lastRequest = requestList.isEmpty() ? null : requestList.get(requestList.size() - 1);
        this.log.debug("adding request {} to {}", (Object)request, requestList);
        if (lastRequest == null || !lastRequest.getRequestType().equals((Object)request.getRequestType())) {
            requestList.add(request);
        } else if (AbstractJcrEventTrigger.hasDeepPaths(request) || AbstractJcrEventTrigger.hasDeepPaths(lastRequest)) {
            requestList.add(request);
        } else {
            TreeSet<String> allPaths = new TreeSet<String>();
            allPaths.addAll(Arrays.asList(lastRequest.getPaths()));
            allPaths.addAll(Arrays.asList(request.getPaths()));
            this.addMissingPaths(allPaths);
            lastRequest = new SimpleDistributionRequest(lastRequest.getRequestType(), allPaths.toArray(new String[allPaths.size()]));
            requestList.set(requestList.size() - 1, lastRequest);
        }
        this.log.debug("current requests {}", requestList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addMissingPaths(Set<String> allPaths) {
        HashSet<String> newPaths = new HashSet<String>();
        for (String path : allPaths) {
            for (String existingPath : allPaths) {
                ResourceResolver resourceResolver;
                block9: {
                    if (path.length() <= existingPath.length() || !path.startsWith(existingPath)) continue;
                    resourceResolver = null;
                    try {
                        resourceResolver = DistributionUtils.loginService(this.resolverFactory, this.serviceUser);
                        Resource resource = resourceResolver.getResource(path);
                        if (resource != null) {
                            for (Resource child : resource.getParent().getChildren()) {
                                String childPath = child.getPath();
                                if (childPath.equals(path)) continue;
                                newPaths.add(childPath);
                            }
                            break block9;
                        }
                        throw new RuntimeException("resource at path " + path + " is null");
                    }
                    catch (LoginException le) {
                        try {
                            this.log.error("cannot obtain resource resolver for {}", (Object)this.serviceUser);
                        }
                        catch (Throwable throwable) {
                            DistributionUtils.safelyLogout(resourceResolver);
                            throw throwable;
                        }
                        DistributionUtils.safelyLogout(resourceResolver);
                        continue;
                    }
                }
                DistributionUtils.safelyLogout(resourceResolver);
            }
        }
        if (!newPaths.isEmpty()) {
            allPaths.addAll(newPaths);
        }
    }

    public void enable() {
    }

    public void disable() {
        for (JcrEventDistributionTriggerListener listener : this.registeredListeners.values()) {
            try {
                Session session = this.getSession();
                session.getWorkspace().getObservationManager().removeEventListener((EventListener)listener);
            }
            catch (RepositoryException e) {
                this.log.error("unable to unregister handler {}", (Object)listener, (Object)e);
            }
        }
        this.registeredListeners.clear();
        if (this.cachedSession != null) {
            this.cachedSession.logout();
            this.cachedSession = null;
        }
    }

    protected abstract DistributionRequest processEvent(Event var1) throws RepositoryException;

    private int getEventTypes() {
        return 31;
    }

    Session getSession() throws RepositoryException {
        return this.cachedSession != null ? this.cachedSession : (this.cachedSession = this.repository.loginService(this.serviceUser, null));
    }

    String getNodePathFromEvent(Event event) throws RepositoryException {
        String eventPath = event.getPath();
        int type = event.getType();
        if (eventPath == null) {
            return null;
        }
        if (8 == type || 16 == type || 4 == type) {
            eventPath = eventPath.substring(0, eventPath.lastIndexOf(47));
        }
        return eventPath;
    }

    private static boolean hasDeepPaths(DistributionRequest distributionRequest) {
        if (!DistributionRequestType.ADD.equals((Object)distributionRequest.getRequestType())) {
            return false;
        }
        for (String path : distributionRequest.getPaths()) {
            if (!distributionRequest.isDeep(path)) continue;
            return true;
        }
        return false;
    }

    class JcrEventDistributionTriggerListener
    implements EventListener {
        private final DistributionRequestHandler requestHandler;

        public JcrEventDistributionTriggerListener(DistributionRequestHandler requestHandler) {
            this.requestHandler = requestHandler;
        }

        public void onEvent(EventIterator eventIterator) {
            AbstractJcrEventTrigger.this.log.debug("jcr trigger on event");
            ArrayList<DistributionRequest> requestList = new ArrayList<DistributionRequest>();
            while (eventIterator.hasNext()) {
                Event event = eventIterator.nextEvent();
                AbstractJcrEventTrigger.this.log.info("handling event {}", (Object)event);
                try {
                    if (DistributionJcrUtils.isSafe(event)) {
                        DistributionRequest request = AbstractJcrEventTrigger.this.processEvent(event);
                        if (request == null) continue;
                        AbstractJcrEventTrigger.this.addToList(request, requestList);
                        continue;
                    }
                    AbstractJcrEventTrigger.this.log.debug("skip unsafe event {}", (Object)event);
                }
                catch (RepositoryException e) {
                    AbstractJcrEventTrigger.this.log.error("Error while handling event {}", (Object)event, (Object)e);
                }
            }
            if (requestList.size() > 0) {
                boolean scheduled = AbstractJcrEventTrigger.this.scheduler.schedule((Object)new DistributionExecutor(requestList, this.requestHandler), AbstractJcrEventTrigger.this.scheduler.NOW());
                AbstractJcrEventTrigger.this.log.info("scheduled {} distributions {}", (Object)scheduled, (Object)requestList.size());
            }
        }
    }

    class DistributionExecutor
    implements Runnable {
        private final List<DistributionRequest> requestList;
        private final DistributionRequestHandler requestHandler;

        public DistributionExecutor(List<DistributionRequest> requestList, DistributionRequestHandler requestHandler) {
            this.requestList = requestList;
            this.requestHandler = requestHandler;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            for (DistributionRequest request : this.requestList) {
                if (AbstractJcrEventTrigger.this.serviceUser == null) {
                    this.requestHandler.handle(null, request);
                    continue;
                }
                ResourceResolver resourceResolver = null;
                try {
                    resourceResolver = DistributionUtils.loginService(AbstractJcrEventTrigger.this.resolverFactory, AbstractJcrEventTrigger.this.serviceUser);
                    this.requestHandler.handle(resourceResolver, request);
                }
                catch (LoginException le) {
                    try {
                        AbstractJcrEventTrigger.this.log.error("cannot obtain resource resolver for {}", (Object)AbstractJcrEventTrigger.this.serviceUser);
                    }
                    catch (Throwable throwable) {
                        DistributionUtils.safelyLogout(resourceResolver);
                        throw throwable;
                    }
                    DistributionUtils.safelyLogout(resourceResolver);
                    continue;
                }
                DistributionUtils.safelyLogout(resourceResolver);
            }
        }
    }
}

