/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.trigger.impl;

import java.util.Map;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.apache.sling.distribution.common.DistributionException;
import org.apache.sling.distribution.trigger.DistributionRequestHandler;
import org.apache.sling.distribution.trigger.DistributionTrigger;
import org.apache.sling.distribution.trigger.impl.ResourceEventDistributionTrigger;
import org.apache.sling.jcr.api.SlingRepository;
import org.jetbrains.annotations.NotNull;
import org.osgi.framework.BundleContext;

@Component(metatype=true, label="Apache Sling Distribution Trigger - Resource Event Triggers Factory", configurationFactory=true, specVersion="1.1", policy=ConfigurationPolicy.REQUIRE, description="Triggers a distribution request ('ADD', 'DELETE') for the given path (path) whenever the resource at the given path is modified (added, resp. removed).")
@Service(value={DistributionTrigger.class})
@Property(name="webconsole.configurationFactory.nameHint", value={"Trigger name: {name}"})
public class ResourceEventDistributionTriggerFactory
implements DistributionTrigger {
    @Property(label="Name", description="The name of the trigger.")
    public static final String NAME = "name";
    @Property(label="Path", description="The resource path for which changes are distributed")
    private static final String PATH = "path";
    private ResourceEventDistributionTrigger trigger;
    @Reference
    private SlingRepository repository;

    @Activate
    public void activate(BundleContext bundleContext, Map<String, Object> config) {
        String path = PropertiesUtil.toString((Object)config.get(PATH), null);
        this.trigger = new ResourceEventDistributionTrigger(path, bundleContext);
    }

    @Deactivate
    public void deactivate() {
        this.trigger.disable();
    }

    @Override
    public void register(@NotNull DistributionRequestHandler requestHandler) throws DistributionException {
        this.trigger.register(requestHandler);
    }

    @Override
    public void unregister(@NotNull DistributionRequestHandler requestHandler) throws DistributionException {
        this.trigger.unregister(requestHandler);
    }

    protected void bindRepository(SlingRepository slingRepository) {
        this.repository = slingRepository;
    }

    protected void unbindRepository(SlingRepository slingRepository) {
        if (this.repository == slingRepository) {
            this.repository = null;
        }
    }
}

