/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.resources.impl.common;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.sling.api.resource.ModifyingResourceProvider;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.distribution.resources.impl.common.AbstractReadableResourceProvider;
import org.apache.sling.distribution.resources.impl.common.SimpleModifiableResource;
import org.apache.sling.distribution.resources.impl.common.SimplePathInfo;

public abstract class AbstractModifyingResourceProvider
extends AbstractReadableResourceProvider
implements ModifyingResourceProvider {
    private final Map<String, Map<String, Object>> changedResources = new HashMap<String, Map<String, Object>>();
    private final Set<String> deletedResources = new HashSet<String>();

    protected AbstractModifyingResourceProvider(String resourceRoot) {
        super(resourceRoot);
    }

    public Resource create(ResourceResolver resolver, String path, Map<String, Object> properties) throws PersistenceException {
        SimplePathInfo pathInfo = this.extractPathInfo(path);
        if (pathInfo == null) {
            throw new PersistenceException("Invalid path: " + path, null);
        }
        if (!this.hasPermission(resolver, pathInfo.getResourcePath(), "add_node")) {
            throw new PersistenceException("Not enough permissions");
        }
        String resourceName = pathInfo.getMainResourceName();
        boolean added = this.addToChangedResources(resolver, resourceName, properties, true);
        if (!added) {
            throw new PersistenceException("Resource already exists at " + path, null, resourceName, null);
        }
        return this.buildMainResource(resolver, pathInfo, properties, new Object[0]);
    }

    public void delete(ResourceResolver resolver, String requestPath) throws PersistenceException {
        SimplePathInfo pathInfo = this.extractPathInfo(requestPath);
        if (pathInfo == null) {
            throw new PersistenceException("Invalid path: " + requestPath, null);
        }
        if (!this.hasPermission(resolver, pathInfo.getResourcePath(), "remove")) {
            throw new PersistenceException("Not enough permissions");
        }
        String resourceName = pathInfo.getMainResourceName();
        if (!this.deletedResources.contains(resourceName)) {
            this.deletedResources.add(resourceName);
            this.changedResources.remove(resourceName);
        }
    }

    public void revert(ResourceResolver resolver) {
        this.reset();
    }

    public void commit(ResourceResolver resolver) throws PersistenceException {
        if (!this.hasChanges(resolver)) {
            return;
        }
        this.saveInternalResources(resolver, this.changedResources, this.deletedResources);
        this.reset();
        resolver.commit();
    }

    public boolean hasChanges(ResourceResolver resolver) {
        return this.changedResources.size() > 0 || this.deletedResources.size() > 0;
    }

    public void change(ResourceResolver resourceResolver, String requestPath, Map<String, Object> properties) {
        SimplePathInfo pathInfo = this.extractPathInfo(requestPath);
        if (pathInfo == null) {
            return;
        }
        if (!this.hasPermission(resourceResolver, pathInfo.getResourcePath(), "set_property")) {
            return;
        }
        String resourceName = pathInfo.getMainResourceName();
        this.addToChangedResources(resourceResolver, resourceName, properties, false);
    }

    private boolean addToChangedResources(ResourceResolver resolver, String resourceName, Map<String, Object> newProperties, boolean failIfAlreadyExists) {
        boolean deleted = this.deletedResources.remove(resourceName);
        SimplePathInfo pathInfo = SimplePathInfo.parsePathInfo(this.resourceRoot, this.resourceRoot + "/" + resourceName);
        Map<String, Object> existingResource = this.getResourceProperties(resolver, pathInfo);
        if (failIfAlreadyExists && !deleted && existingResource != null) {
            return false;
        }
        HashMap<String, Object> properties = new HashMap<String, Object>();
        if (existingResource != null) {
            properties.putAll(existingResource);
        }
        if (newProperties != null) {
            properties.putAll(newProperties);
        }
        this.changedResources.put(resourceName, properties);
        return true;
    }

    @Override
    protected Map<String, Object> getResourceProperties(ResourceResolver resolver, SimplePathInfo pathInfo) {
        if (pathInfo.isMain()) {
            String resourceName = pathInfo.getMainResourceName();
            if (this.deletedResources.contains(resourceName)) {
                return null;
            }
            if (this.changedResources.containsKey(resourceName)) {
                return this.changedResources.get(resourceName);
            }
        }
        return super.getResourceProperties(resolver, pathInfo);
    }

    @Override
    Resource buildMainResource(ResourceResolver resourceResolver, SimplePathInfo pathInfo, Map<String, Object> properties, Object ... adapters) {
        return new SimpleModifiableResource(resourceResolver, this, pathInfo.getResourcePath(), properties);
    }

    private void reset() {
        this.changedResources.clear();
        this.deletedResources.clear();
    }

    protected abstract void saveInternalResources(ResourceResolver var1, Map<String, Map<String, Object>> var2, Set<String> var3) throws PersistenceException;
}

