/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.transport.impl;

import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.io.IOUtils;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.fluent.Executor;
import org.apache.http.client.fluent.Request;
import org.apache.http.client.fluent.Response;
import org.apache.http.conn.HttpHostConnectException;
import org.apache.http.entity.ContentType;
import org.apache.http.message.BasicHeader;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.distribution.DistributionRequest;
import org.apache.sling.distribution.common.DistributionException;
import org.apache.sling.distribution.common.RecoverableDistributionException;
import org.apache.sling.distribution.log.impl.DefaultDistributionLog;
import org.apache.sling.distribution.packaging.DistributionPackage;
import org.apache.sling.distribution.packaging.DistributionPackageBuilder;
import org.apache.sling.distribution.packaging.DistributionPackageInfo;
import org.apache.sling.distribution.packaging.impl.AbstractDistributionPackage;
import org.apache.sling.distribution.packaging.impl.DistributionPackageUtils;
import org.apache.sling.distribution.transport.DistributionTransportSecret;
import org.apache.sling.distribution.transport.DistributionTransportSecretProvider;
import org.apache.sling.distribution.transport.impl.DefaultRemoteDistributionPackage;
import org.apache.sling.distribution.transport.impl.DistributionEndpoint;
import org.apache.sling.distribution.transport.impl.DistributionTransport;
import org.apache.sling.distribution.transport.impl.DistributionTransportContext;
import org.apache.sling.distribution.transport.impl.HttpConfiguration;
import org.apache.sling.distribution.transport.impl.HttpTransportUtils;
import org.apache.sling.distribution.transport.impl.RemoteDistributionPackage;
import org.apache.sling.distribution.util.RequestUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleHttpDistributionTransport
implements DistributionTransport {
    private static final String USERNAME = "username";
    private static final String PASSWORD = "password";
    private static final String AUTHORIZATION = "authorization";
    private static final String EXECUTOR_CONTEXT_KEY_PREFIX = "ExecutorContextKey";
    private static final String DIGEST_HEADER = "Digest";
    private static final String PACKAGE_INFO_PROPERTY_ORIGIN_URI = "internal.origin.uri";
    private final DefaultDistributionLog log;
    private final DistributionEndpoint distributionEndpoint;
    private final DistributionPackageBuilder packageBuilder;
    private final DistributionTransportSecretProvider secretProvider;
    private final HttpConfiguration httpConfiguration;
    private final String contextKeyExecutor;

    public SimpleHttpDistributionTransport(DefaultDistributionLog log, DistributionEndpoint distributionEndpoint, DistributionPackageBuilder packageBuilder, DistributionTransportSecretProvider secretProvider, HttpConfiguration httpConfiguration) {
        this.log = log;
        this.distributionEndpoint = distributionEndpoint;
        this.packageBuilder = packageBuilder;
        this.secretProvider = secretProvider;
        this.httpConfiguration = httpConfiguration;
        this.contextKeyExecutor = "ExecutorContextKey_" + this.getHostAndPort(distributionEndpoint.getUri()) + "_" + UUID.randomUUID();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deliverPackage(@NotNull ResourceResolver resourceResolver, @NotNull DistributionPackage distributionPackage, @NotNull DistributionTransportContext distributionContext) throws DistributionException {
        String hostAndPort = this.getHostAndPort(this.distributionEndpoint.getUri());
        DistributionPackageInfo info = distributionPackage.getInfo();
        URI packageOrigin = (URI)info.get(PACKAGE_INFO_PROPERTY_ORIGIN_URI, URI.class);
        if (packageOrigin != null && hostAndPort.equals(this.getHostAndPort(packageOrigin))) {
            this.log.debug("skipping distribution of package {}\u00a0to same origin {}", distributionPackage.getId(), hostAndPort);
        } else {
            try {
                AbstractDistributionPackage adb;
                Executor executor = this.getExecutor(distributionContext);
                Request req = Request.Post((URI)this.distributionEndpoint.getUri()).connectTimeout(this.httpConfiguration.getConnectTimeout().intValue()).socketTimeout(this.httpConfiguration.getSocketTimeout().intValue()).addHeader("Connection", "Close").useExpectContinue();
                String authorizationHeader = this.getAuthSecret();
                if (null != authorizationHeader) {
                    req.addHeader((Header)new BasicHeader("Authorization", authorizationHeader));
                }
                if (distributionPackage instanceof AbstractDistributionPackage && (adb = (AbstractDistributionPackage)distributionPackage).getDigestAlgorithm() != null && adb.getDigestMessage() != null) {
                    req.addHeader(DIGEST_HEADER, String.format("%s=%s", adb.getDigestAlgorithm(), adb.getDigestMessage()));
                }
                InputStream inputStream = null;
                try {
                    inputStream = DistributionPackageUtils.createStreamWithHeader(distributionPackage);
                    req.bodyStream(inputStream, ContentType.APPLICATION_OCTET_STREAM);
                    Response response = executor.execute(req);
                    response.returnContent();
                }
                finally {
                    IOUtils.closeQuietly((InputStream)inputStream);
                }
                this.log.debug("delivered packageId={}, endpoint={}", distributionPackage.getId(), this.distributionEndpoint.getUri());
            }
            catch (HttpHostConnectException e) {
                throw new RecoverableDistributionException("endpoint not available " + this.distributionEndpoint.getUri(), e);
            }
            catch (HttpResponseException e) {
                int statusCode = e.getStatusCode();
                if (statusCode == 404 || statusCode == 401) {
                    throw new RecoverableDistributionException("not enough rights for " + this.distributionEndpoint.getUri(), e);
                }
                throw new DistributionException(e);
            }
            catch (Exception e) {
                throw new DistributionException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public RemoteDistributionPackage retrievePackage(@NotNull ResourceResolver resourceResolver, @NotNull DistributionRequest distributionRequest, @NotNull DistributionTransportContext distributionContext) throws DistributionException {
        block7: {
            DefaultRemoteDistributionPackage defaultRemoteDistributionPackage;
            this.log.debug("pulling from {}", this.distributionEndpoint.getUri());
            URI distributionURI = RequestUtils.appendDistributionRequest(this.distributionEndpoint.getUri(), distributionRequest);
            Executor executor = this.getExecutor(distributionContext);
            InputStream inputStream = HttpTransportUtils.fetchNextPackage(executor, distributionURI, this.httpConfiguration);
            if (inputStream == null) {
                return null;
            }
            try {
                DistributionPackage responsePackage = this.packageBuilder.readPackage(resourceResolver, inputStream);
                responsePackage.getInfo().put(PACKAGE_INFO_PROPERTY_ORIGIN_URI, distributionURI);
                this.log.debug("pulled package with info {}", new Object[]{responsePackage.getInfo()});
                defaultRemoteDistributionPackage = new DefaultRemoteDistributionPackage(responsePackage, executor, distributionURI);
            }
            catch (Throwable throwable) {
                try {
                    IOUtils.closeQuietly((InputStream)inputStream);
                    throw throwable;
                }
                catch (HttpHostConnectException e) {
                    this.log.debug("could not connect to {} - skipping", this.distributionEndpoint.getUri());
                    break block7;
                }
                catch (Exception ex) {
                    this.log.error("cannot retrieve packages", ex);
                }
            }
            IOUtils.closeQuietly((InputStream)inputStream);
            return defaultRemoteDistributionPackage;
        }
        return null;
    }

    private String getHostAndPort(URI uri) {
        return uri.getHost() + ":" + uri.getPort();
    }

    private Executor getExecutor(DistributionTransportContext distributionContext) {
        Executor executor = (Executor)distributionContext.get(this.contextKeyExecutor, Executor.class);
        if (executor == null) {
            executor = this.buildExecutor();
            distributionContext.put(this.contextKeyExecutor, executor);
        }
        return executor;
    }

    private Executor buildAuthExecutor(String username, String password) {
        URI uri = this.distributionEndpoint.getUri();
        Executor executor = Executor.newInstance().auth(new HttpHost(uri.getHost(), uri.getPort(), uri.getScheme()), username, password).authPreemptive(new HttpHost(uri.getHost(), uri.getPort(), uri.getScheme()));
        this.log.debug("authenticate user={}, endpoint={}", username, uri);
        return executor;
    }

    private Executor buildAuthExecutor(Map<String, String> credentialsMap) {
        return null != credentialsMap && !credentialsMap.containsKey(AUTHORIZATION) ? this.buildAuthExecutor(credentialsMap.get(USERNAME), credentialsMap.get(PASSWORD)) : Executor.newInstance();
    }

    private Executor buildExecutor() {
        Map<String, String> credentialsMap = this.getCredentialsMap();
        return this.buildAuthExecutor(credentialsMap);
    }

    private String getAuthSecret() {
        Map<String, String> credentialsMap = this.getCredentialsMap();
        if (null != credentialsMap && credentialsMap.containsKey(AUTHORIZATION)) {
            return credentialsMap.get(AUTHORIZATION);
        }
        return null;
    }

    private Map<String, String> getCredentialsMap() {
        DistributionTransportSecret secret = this.secretProvider.getSecret(this.distributionEndpoint.getUri());
        Map credentialsMap = null;
        if (null != secret) {
            credentialsMap = secret.asCredentialsMap();
        }
        return credentialsMap;
    }
}

