/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.resources.impl;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.sling.distribution.agent.DistributionAgentState;
import org.apache.sling.distribution.agent.spi.DistributionAgent;
import org.apache.sling.distribution.component.impl.DistributionComponent;
import org.apache.sling.distribution.component.impl.DistributionComponentKind;
import org.apache.sling.distribution.component.impl.DistributionComponentProvider;
import org.apache.sling.distribution.log.spi.DistributionLog;
import org.apache.sling.distribution.packaging.DistributionPackageInfo;
import org.apache.sling.distribution.packaging.impl.DistributionPackageUtils;
import org.apache.sling.distribution.queue.DistributionQueueEntry;
import org.apache.sling.distribution.queue.DistributionQueueItem;
import org.apache.sling.distribution.queue.DistributionQueueItemStatus;
import org.apache.sling.distribution.queue.DistributionQueueStatus;
import org.apache.sling.distribution.queue.spi.DistributionQueue;
import org.apache.sling.distribution.resources.impl.DistributionServiceResourceProvider;
import org.apache.sling.distribution.resources.impl.common.SimplePathInfo;

public class ExtendedDistributionServiceResourceProvider
extends DistributionServiceResourceProvider {
    private static final String QUEUES_PATH = "queues";
    private static final String LOG_PATH = "log";
    private static final String STATUS_PATH = "status";
    private static final int MAX_QUEUE_LENGTH = 5000;
    private static final int MAX_QUEUE_CHUNK = 100;

    public ExtendedDistributionServiceResourceProvider(String kind, DistributionComponentProvider componentProvider, String resourceRoot) {
        super(kind, componentProvider, resourceRoot);
    }

    @Override
    protected Map<String, Object> getChildResourceProperties(DistributionComponent<?> component, String childResourceName) {
        DistributionAgent agent;
        DistributionComponentKind kind = component.getKind();
        if (DistributionComponentKind.AGENT == kind && (agent = (DistributionAgent)component.getService()) != null && childResourceName != null) {
            if (childResourceName.startsWith(QUEUES_PATH)) {
                SimplePathInfo queuePathInfo = SimplePathInfo.parsePathInfo(QUEUES_PATH, childResourceName);
                return this.getQueueProperties(agent, queuePathInfo);
            }
            if (childResourceName.startsWith(LOG_PATH)) {
                HashMap<String, Object> result = new HashMap<String, Object>();
                result.put("sling:resourceType", "sling/distribution/service/log");
                DistributionLog distributionLog = agent.getLog();
                result.put("internal:adaptable", distributionLog);
                return result;
            }
            if (childResourceName.startsWith(STATUS_PATH)) {
                HashMap<String, Object> result = new HashMap<String, Object>();
                DistributionAgentState agentState = agent.getState();
                result.put("state", agentState.name());
                return result;
            }
        }
        return null;
    }

    @Override
    protected Iterable<String> getChildResourceChildren(DistributionComponent<?> component, String childResourceName) {
        DistributionAgent agent;
        DistributionComponentKind kind = component.getKind();
        if (DistributionComponentKind.AGENT == kind && (agent = (DistributionAgent)component.getService()) != null && childResourceName == null) {
            ArrayList<String> nameList = new ArrayList<String>();
            nameList.add(QUEUES_PATH);
            nameList.add(LOG_PATH);
            nameList.add(STATUS_PATH);
            return nameList;
        }
        return null;
    }

    private Map<String, Object> getQueueProperties(DistributionAgent agent, SimplePathInfo queueInfo) {
        if (queueInfo.isRoot()) {
            HashMap<String, Object> result = new HashMap<String, Object>();
            ArrayList<String> nameList = new ArrayList<String>();
            for (String name : agent.getQueueNames()) {
                nameList.add(name);
            }
            result.put("items", nameList.toArray(new String[nameList.size()]));
            result.put("sling:resourceType", "sling/distribution/service/agent/queue/list");
            return result;
        }
        if (queueInfo.isMain()) {
            String queueName = queueInfo.getMainResourceName();
            HashMap<String, Object> result = new HashMap<String, Object>();
            DistributionQueue queue = agent.getQueue(queueName);
            if (queue != null) {
                DistributionQueueStatus queueStatus = queue.getStatus();
                result.put("sling:resourceType", "sling/distribution/service/agent/queue");
                result.put("state", queueStatus.getState().name());
                result.put("empty", queueStatus.isEmpty());
                result.put("itemsCount", queueStatus.getItemsCount());
                result.put("capabilities", this.queueCapabilities(queue));
                if (queueName.startsWith("error-")) {
                    String retryQueue = queueName.replace("error-", "");
                    result.put("retryQueue", retryQueue);
                }
                ArrayList<String> nameList = new ArrayList<String>();
                DistributionQueueEntry entry = queue.getHead();
                if (entry != null) {
                    nameList.add(entry.getId());
                }
                result.put("items", nameList.toArray(new String[nameList.size()]));
                result.put("internal:itemsIterator", new QueueItemsIterator(queue));
                result.put("internal:adaptable", queue);
            }
            return result;
        }
        if (queueInfo.isChild()) {
            String queueName = queueInfo.getMainResourceName();
            Map<String, Object> result = new HashMap<String, Object>();
            DistributionQueue queue = agent.getQueue(queueName);
            if (queue != null) {
                String itemId = queueInfo.getChildResourceName();
                DistributionQueueEntry entry = queue.getEntry(itemId);
                result = this.getItemProperties(entry);
            }
            return result;
        }
        return null;
    }

    private Map<String, Object> getItemProperties(DistributionQueueEntry entry) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (entry != null) {
            result.put("sling:resourceType", "sling/distribution/service/agent/queue/item");
            DistributionQueueItem item = entry.getItem();
            DistributionPackageInfo packageInfo = DistributionPackageUtils.fromQueueItem(item);
            result.put("id", entry.getId());
            result.put("size", item.getSize());
            result.put("paths", packageInfo.getPaths());
            result.put("action", packageInfo.getRequestType());
            result.put("userid", packageInfo.get("internal.request.user", String.class));
            DistributionQueueItemStatus status = entry.getStatus();
            result.put("attempts", status.getAttempts());
            result.put("time", status.getEntered().getTime());
            result.put("state", status.getItemState().name());
            Throwable error = status.getError();
            if (error != null) {
                StringWriter trace = new StringWriter();
                error.printStackTrace(new PrintWriter(trace));
                result.put("errorTrace", trace.toString());
                result.put("errorMessage", error.getMessage());
            }
        }
        return result;
    }

    private String[] queueCapabilities(DistributionQueue queue) {
        ArrayList<String> capabilities = new ArrayList<String>();
        if (queue.hasCapability("removable")) {
            capabilities.add("removable");
        }
        if (queue.hasCapability("appendable")) {
            capabilities.add("appendable");
        }
        if (queue.hasCapability("clearable")) {
            capabilities.add("clearable");
        }
        return capabilities.toArray(new String[capabilities.size()]);
    }

    class QueueItemsIterator
    implements Iterator<Map<String, Object>> {
        private final DistributionQueue queue;
        private Iterator<DistributionQueueEntry> items;
        int fetched = 0;

        QueueItemsIterator(DistributionQueue queue) {
            this.queue = queue;
        }

        @Override
        public boolean hasNext() {
            boolean shouldFetch;
            if (this.fetched > 5000) {
                return false;
            }
            boolean bl = shouldFetch = this.items == null || !this.items.hasNext();
            if (shouldFetch) {
                this.items = this.queue.getEntries(this.fetched, 100).iterator();
            }
            return this.items.hasNext();
        }

        @Override
        public Map<String, Object> next() {
            DistributionQueueEntry queueEntry = this.items.next();
            String itemName = queueEntry.getId();
            Map itemProperties = ExtendedDistributionServiceResourceProvider.this.getItemProperties(queueEntry);
            itemProperties.put("internal:adaptable", itemName);
            ++this.fetched;
            return itemProperties;
        }

        @Override
        public void remove() {
            this.items.remove();
        }
    }
}

