/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.resources.impl;

import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceProvider;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.apache.sling.distribution.component.impl.DistributionComponentProvider;
import org.apache.sling.distribution.resources.impl.ExtendedDistributionServiceResourceProvider;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=true, label="Apache Sling Distribution Resources - Service Resource Provider Factory", description="Distribution Service Resource Provider Factory", configurationFactory=true, specVersion="1.1", policy=ConfigurationPolicy.REQUIRE)
@Service(value={ResourceProvider.class})
@Properties(value={@Property(name="provider.roots"), @Property(name="provider.ownsRoots", boolValue={true}, propertyPrivate=true)})
@Property(name="webconsole.configurationFactory.nameHint", value={"Resource kind: {kind}"})
public class DistributionServiceResourceProviderFactory
implements ResourceProvider {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Property
    private static final String KIND = "kind";
    @Reference
    private DistributionComponentProvider componentProvider;
    private ResourceProvider resourceProvider;

    @Activate
    public void activate(BundleContext context, Map<String, Object> properties) {
        this.log.debug("activating resource provider with config {}", properties);
        String kind = PropertiesUtil.toString((Object)properties.get(KIND), null);
        String resourceRoot = PropertiesUtil.toString((Object)properties.get("provider.roots"), null);
        this.resourceProvider = new ExtendedDistributionServiceResourceProvider(kind, this.componentProvider, resourceRoot);
        this.log.debug("created resource provider {}", (Object)this.resourceProvider);
    }

    @Deactivate
    public void deactivate(BundleContext context) {
        this.resourceProvider = null;
    }

    public Resource getResource(ResourceResolver resourceResolver, HttpServletRequest request, String path) {
        return this.getResource(resourceResolver, path);
    }

    public Resource getResource(ResourceResolver resourceResolver, String path) {
        return this.resourceProvider.getResource(resourceResolver, path);
    }

    public Iterator<Resource> listChildren(Resource parent) {
        return this.resourceProvider.listChildren(parent);
    }

    protected void bindComponentProvider(DistributionComponentProvider distributionComponentProvider) {
        this.componentProvider = distributionComponentProvider;
    }

    protected void unbindComponentProvider(DistributionComponentProvider distributionComponentProvider) {
        if (this.componentProvider == distributionComponentProvider) {
            this.componentProvider = null;
        }
    }
}

