/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.packaging.impl.importer;

import java.io.InputStream;
import java.util.Map;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.apache.sling.distribution.common.DistributionException;
import org.apache.sling.distribution.event.impl.DistributionEventFactory;
import org.apache.sling.distribution.packaging.DistributionPackage;
import org.apache.sling.distribution.packaging.DistributionPackageBuilder;
import org.apache.sling.distribution.packaging.DistributionPackageInfo;
import org.apache.sling.distribution.packaging.impl.DistributionPackageImporter;
import org.apache.sling.distribution.packaging.impl.importer.LocalDistributionPackageImporter;
import org.jetbrains.annotations.NotNull;

@Component(label="Apache Sling Distribution Importer - Local Package Importer Factory", metatype=true, configurationFactory=true, specVersion="1.1", policy=ConfigurationPolicy.REQUIRE)
@Service(value={DistributionPackageImporter.class})
@Property(name="webconsole.configurationFactory.nameHint", value={"Importer name: {name}"})
public class LocalDistributionPackageImporterFactory
implements DistributionPackageImporter {
    @Property(label="Name", description="The name of the importer.")
    private static final String NAME = "name";
    @Property(name="packageBuilder.target", label="Package Builder", description="The target reference for the DistributionPackageBuilder used to create distribution packages, e.g. use target=(name=...) to bind to services by name.", value={"(name=default)"})
    @Reference(name="packageBuilder")
    private DistributionPackageBuilder packageBuilder;
    @Reference
    private DistributionEventFactory eventFactory;
    private DistributionPackageImporter importer;

    @Activate
    public void activate(Map<String, Object> config) {
        String name = PropertiesUtil.toString((Object)config.get(NAME), null);
        this.importer = new LocalDistributionPackageImporter(name, this.eventFactory, this.packageBuilder);
    }

    @Override
    public void importPackage(@NotNull ResourceResolver resourceResolver, @NotNull DistributionPackage distributionPackage) throws DistributionException {
        this.importer.importPackage(resourceResolver, distributionPackage);
    }

    @Override
    @NotNull
    public DistributionPackageInfo importStream(@NotNull ResourceResolver resourceResolver, @NotNull InputStream stream) throws DistributionException {
        return this.importer.importStream(resourceResolver, stream);
    }

    protected void bindPackageBuilder(DistributionPackageBuilder distributionPackageBuilder) {
        this.packageBuilder = distributionPackageBuilder;
    }

    protected void unbindPackageBuilder(DistributionPackageBuilder distributionPackageBuilder) {
        if (this.packageBuilder == distributionPackageBuilder) {
            this.packageBuilder = null;
        }
    }

    protected void bindEventFactory(DistributionEventFactory distributionEventFactory) {
        this.eventFactory = distributionEventFactory;
    }

    protected void unbindEventFactory(DistributionEventFactory distributionEventFactory) {
        if (this.eventFactory == distributionEventFactory) {
            this.eventFactory = null;
        }
    }
}

